/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.ExternalDocumentation;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExternalDocumentationValidator
extends TypeValidator<ExternalDocumentation> {
    private static final TraceComponent tc = Tr.register(ExternalDocumentationValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final ExternalDocumentationValidator INSTANCE = new ExternalDocumentationValidator();
    static final long serialVersionUID = 7146751731431061333L;

    public static ExternalDocumentationValidator getInstance() {
        return INSTANCE;
    }

    private ExternalDocumentationValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, ExternalDocumentation t) {
        ValidatorUtils.validateRequiredField(t.getUrl(), "External Documentation", "url").ifPresent(helper::addValidationEvent);
        if (t.getUrl() != null && !ValidatorUtils.isValidURL(t.getUrl())) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"externalDocumentationInvalidURL", (Object[])new Object[]{t.getUrl()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }
}

