/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.info.Info;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InfoValidator
extends TypeValidator<Info> {
    private static final TraceComponent tc = Tr.register(InfoValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final InfoValidator INSTANCE = new InfoValidator();
    static final long serialVersionUID = 3119565297808136141L;

    public static InfoValidator getInstance() {
        return INSTANCE;
    }

    private InfoValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Info t) {
        ValidatorUtils.validateRequiredField(t.getVersion(), "/info", "version").ifPresent(helper::addValidationEvent);
        ValidatorUtils.validateRequiredField(t.getTitle(), "/info", "title").ifPresent(helper::addValidationEvent);
        if (t.getTermsOfService() != null && !ValidatorUtils.isValidURL(t.getTermsOfService())) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"infoTermsOfServiceInvalidURL", (Object[])new Object[]{t.getTermsOfService()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }
}

