/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.ReferenceValidator;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MediaTypeValidator
extends TypeValidator<MediaType> {
    private static final TraceComponent tc = Tr.register(MediaTypeValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final MediaTypeValidator INSTANCE = new MediaTypeValidator();
    static final long serialVersionUID = -7945362516046269868L;

    public static MediaTypeValidator getInstance() {
        return INSTANCE;
    }

    private MediaTypeValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, MediaType t) {
        Map encoding;
        String example = t.getExample();
        Map examples = t.getExamples();
        if (example != null && !example.isEmpty() && examples != null && !examples.isEmpty()) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeExampleOrExamples", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
        }
        if ((encoding = t.getEncoding()) != null && !encoding.isEmpty()) {
            Set encodingProperties = encoding.keySet();
            if (t.getSchema() != null) {
                Schema schema = t.getSchema();
                if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
                    String ref = schema.get$ref();
                    ReferenceValidator referenceValidator = ReferenceValidator.getInstance();
                    Object component = referenceValidator.validate(helper, context, key, ref);
                    if (!schema.getClass().isInstance(component)) {
                        String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceToObjectInvalid", (Object[])new Object[]{ref, schema.getClass().getName()});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                    } else {
                        Schema componentSchema = (Schema)component;
                        Map schemaProperties = componentSchema != null ? componentSchema.getProperties() : null;
                        for (String encodingProperty : encodingProperties) {
                            if (schemaProperties != null && schemaProperties.containsKey(encodingProperty)) continue;
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEncodingProperty", (Object[])new Object[]{encodingProperty});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                        }
                    }
                } else if (t.getSchema().getProperties() != null) {
                    for (String encodingProperty : encodingProperties) {
                        if (schema.getProperties().containsKey(encodingProperty)) continue;
                        String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEncodingProperty", (Object[])new Object[]{encodingProperty});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                    }
                } else {
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEmptySchema", (Object[])new Object[0]);
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                }
            } else {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"mediaTypeEmptySchema", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            }
        }
    }
}

