/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.security.OAuthFlow;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuthFlowValidator
extends TypeValidator<OAuthFlow> {
    private static final TraceComponent tc = Tr.register(OAuthFlowValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final OAuthFlowValidator INSTANCE = new OAuthFlowValidator();
    static final long serialVersionUID = 5847845929826414687L;

    public static OAuthFlowValidator getInstance() {
        return INSTANCE;
    }

    private OAuthFlowValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OAuthFlow t) {
        String message;
        if (t.getAuthorizationUrl() != null && !ValidatorUtils.isValidURL(t.getAuthorizationUrl())) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getAuthorizationUrl()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        if (t.getTokenUrl() != null && !ValidatorUtils.isValidURL(t.getTokenUrl())) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getTokenUrl()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        if (t.getRefreshUrl() != null && !ValidatorUtils.isValidURL(t.getRefreshUrl())) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"oAuthFlowInvalidURL", (Object[])new Object[]{t.getRefreshUrl()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }
}

