/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.tags.Tag;
import java.util.HashSet;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIValidator
extends TypeValidator<OpenAPI> {
    private static final TraceComponent tc = Tr.register(OpenAPIValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final OpenAPIValidator INSTANCE = new OpenAPIValidator();
    static final long serialVersionUID = -102484278432936652L;

    public static OpenAPIValidator getInstance() {
        return INSTANCE;
    }

    private OpenAPIValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OpenAPI t) {
        if (t != null) {
            List tags;
            String openapiVersion = t.getOpenapi();
            ValidatorUtils.validateRequiredField(openapiVersion, "#/", "openapi").ifPresent(helper::addValidationEvent);
            ValidatorUtils.validateRequiredField(t.getInfo(), "#/", "info").ifPresent(helper::addValidationEvent);
            ValidatorUtils.validateRequiredField(t.getPaths(), "#/", "paths").ifPresent(helper::addValidationEvent);
            if (openapiVersion != null && !openapiVersion.startsWith("3.")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"openAPIVersionInvalid", (Object[])new Object[]{openapiVersion});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            }
            if ((tags = t.getTags()) != null) {
                HashSet<String> tagNames = new HashSet<String>();
                for (Tag tag : tags) {
                    if (tagNames.add(tag.getName())) continue;
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"openAPITagIsNotUnique", (Object[])new Object[]{tag.getName()});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                }
            }
        }
    }
}

