/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.responses.ApiResponses;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OperationValidator
extends TypeValidator<Operation> {
    private static final TraceComponent tc = Tr.register(OperationValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final OperationValidator INSTANCE = new OperationValidator();
    static final long serialVersionUID = -485422617349609995L;

    public static OperationValidator getInstance() {
        return INSTANCE;
    }

    private OperationValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Operation t) {
        String id = t.getOperationId();
        if (id != null && helper.addOperationId(id)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"operationIdsMustBeUnique", (Object[])new Object[]{id});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        ApiResponses responses = t.getResponses();
        ValidatorUtils.validateRequiredField(responses, "Operation", "responses").ifPresent(helper::addValidationEvent);
    }
}

