/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ParameterValidator
extends TypeValidator<Parameter> {
    private static final TraceComponent tc = Tr.register(ParameterValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final ParameterValidator INSTANCE = new ParameterValidator();
    static final long serialVersionUID = -1230954461449141683L;

    public static ParameterValidator getInstance() {
        return INSTANCE;
    }

    private ParameterValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Parameter t) {
        String message;
        String message2;
        String reference = t.get$ref();
        if (reference != null && !reference.isEmpty()) {
            ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
            return;
        }
        ValidatorUtils.validateRequiredField(t.getName(), "parameter", "name").ifPresent(helper::addValidationEvent);
        String in = t.getIn();
        ValidatorUtils.validateRequiredField(in, "parameter." + t.getName(), "in").ifPresent(helper::addValidationEvent);
        if (!(in == null || in.equals("query") || in.equals("header") || in.equals("path") || in.equals("cookie"))) {
            message2 = Tr.formatMessage((TraceComponent)tc, (String)"parameterInFieldInvalid", (Object[])new Object[]{t.getName(), in});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message2));
        }
        if (t.getExample() != null && !t.getExample().isEmpty() && t.getExamples() != null && !t.getExamples().isEmpty()) {
            message2 = Tr.formatMessage((TraceComponent)tc, (String)"parameterExampleOrExamples", (Object[])new Object[]{t.getName()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message2));
        }
        Schema schema = t.getSchema();
        Content content = t.getContent();
        if (schema == null && content == null) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"parameterSchemaOrContent", (Object[])new Object[]{t.getName()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        if (schema != null && content != null) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"parameterSchemaAndContent", (Object[])new Object[]{t.getName()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        if (content != null && content.size() > 1) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"parameterContentMapMustNotBeEmpty", (Object[])new Object[]{t.getName()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }
}

