/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.parameters.Parameter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PathItemValidator
extends TypeValidator<PathItem> {
    private static final TraceComponent tc = Tr.register(PathItemValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final PathItemValidator INSTANCE = new PathItemValidator();
    static final long serialVersionUID = 1587181239171429176L;

    public static PathItemValidator getInstance() {
        return INSTANCE;
    }

    private PathItemValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, PathItem t) {
        String ref = t.get$ref();
        if (ref != null && ref.startsWith("#")) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidRef", (Object[])new Object[]{ref, key});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        this.validateParameters(helper, key, t);
    }

    private void validateParameters(ValidationHelper helper, String pathStr, PathItem path) {
        Map operationMap;
        Set<String> declaredPathParameters;
        HashSet<String> definedSharedPathParameters = new HashSet<String>();
        HashSet<String> definedSharedQueryParameters = new HashSet<String>();
        HashSet<String> definedSharedHeaderParameters = new HashSet<String>();
        HashSet<String> definedSharedCookieParameters = new HashSet<String>();
        List sharedParameters = path.getParameters();
        if (sharedParameters != null) {
            for (Parameter parameter : sharedParameters) {
                String message;
                if (this.isPathParameter(parameter) && !parameter.getRequired().booleanValue()) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemRequiredField", (Object[])new Object[]{parameter.getName(), pathStr});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                }
                if (!(this.isPathParameter(parameter) && !definedSharedPathParameters.add(parameter.getName()) || this.isQueryParameter(parameter) && !definedSharedQueryParameters.add(parameter.getName()) || this.isHeaderParameter(parameter) && !definedSharedHeaderParameters.add(parameter.getName())) && (!this.isCookieParameter(parameter) || definedSharedCookieParameters.add(parameter.getName()))) continue;
                message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemDuplicate", (Object[])new Object[]{pathStr, parameter.getIn(), parameter.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            }
        }
        if (!(declaredPathParameters = this.validatePathAndRetrievePathParams(helper, pathStr)).containsAll(definedSharedPathParameters)) {
            HashSet undeclaredParameters = new HashSet(definedSharedPathParameters);
            undeclaredParameters.removeAll(declaredPathParameters);
            boolean isMultiple = undeclaredParameters.size() > 1;
            String message = isMultiple ? Tr.formatMessage((TraceComponent)tc, (String)"pathItemParameterNotDeclaredMultiple", (Object[])new Object[]{path, undeclaredParameters.size(), undeclaredParameters}) : Tr.formatMessage((TraceComponent)tc, (String)"pathItemParameterNotDeclaredSingle", (Object[])new Object[]{path, undeclaredParameters});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
        }
        if ((operationMap = path.readOperationsMap()) != null) {
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = (Operation)operationMap.get(httpMethod);
                this.validateOperationParameters(helper, operation, declaredPathParameters, definedSharedPathParameters, pathStr, httpMethod.toString());
            }
        }
    }

    private void validateOperationParameters(ValidationHelper helper, Operation operation, Set<String> declaredPathParameters, Set<String> definedSharedPathParams, String path, String operationType) {
        String message;
        HashSet<String> definedPathParameters = new HashSet<String>();
        HashSet<String> definedQueryParameters = new HashSet<String>();
        HashSet<String> definedHeaderParameters = new HashSet<String>();
        HashSet<String> definedCookieParameters = new HashSet<String>();
        List parameters = operation.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            for (Parameter parameter : parameters) {
                if (parameter != null) {
                    if (this.isPathParameter(parameter) && !parameter.getRequired().booleanValue()) {
                        message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationRequiredField", (Object[])new Object[]{parameter.getName(), operationType, path});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                    }
                    if (!(this.isPathParameter(parameter) && !definedPathParameters.add(parameter.getName()) || this.isQueryParameter(parameter) && !definedQueryParameters.add(parameter.getName()) || this.isHeaderParameter(parameter) && !definedHeaderParameters.add(parameter.getName())) && (!this.isCookieParameter(parameter) || definedCookieParameters.add(parameter.getName()))) continue;
                    message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationDuplicate", (Object[])new Object[]{operationType, path, parameter.getIn(), parameter.getName()});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                    continue;
                }
                message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationNullParameter", (Object[])new Object[]{operationType, path});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            }
        }
        if (!declaredPathParameters.containsAll(definedPathParameters)) {
            HashSet undeclaredParameters = new HashSet(definedPathParameters);
            undeclaredParameters.removeAll(declaredPathParameters);
            boolean isMultiple = undeclaredParameters.size() > 1;
            message = isMultiple ? Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationParameterNotDeclaredMultiple", (Object[])new Object[]{operationType, path, undeclaredParameters.size(), undeclaredParameters}) : Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationParameterNotDeclaredSingle", (Object[])new Object[]{operationType, path, undeclaredParameters});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
        }
        for (String declaredParam : declaredPathParameters) {
            if (definedSharedPathParams.contains(declaredParam) || definedPathParameters.contains(declaredParam)) continue;
            message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationNoPathParameterDeclared", (Object[])new Object[]{operationType, path, declaredParam});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }

    private boolean isCookieParameter(Parameter parameter) {
        return parameter != null && "cookie".equals(parameter.getIn());
    }

    private boolean isHeaderParameter(Parameter parameter) {
        return parameter != null && "header".equals(parameter.getIn());
    }

    private boolean isQueryParameter(Parameter parameter) {
        return parameter != null && "query".equals(parameter.getIn());
    }

    private boolean isPathParameter(Parameter parameter) {
        return parameter != null && "path".equals(parameter.getIn());
    }

    private Set<String> validatePathAndRetrievePathParams(ValidationHelper helper, String pathStr) {
        String pathToCheck = pathStr;
        HashSet<String> pathParameters = new HashSet<String>();
        while (pathToCheck.contains("{")) {
            int lastIndex;
            if (!pathToCheck.contains("}")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                return pathParameters;
            }
            int firstIndex = pathToCheck.indexOf("{");
            if (firstIndex > (lastIndex = pathToCheck.indexOf("}"))) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                return pathParameters;
            }
            String parameter = pathToCheck.substring(firstIndex + 1, lastIndex);
            if (parameter.isEmpty() || parameter.contains("{") || parameter.contains("/")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                return pathParameters;
            }
            pathParameters.add(parameter);
            pathToCheck = pathToCheck.substring(lastIndex + 1);
        }
        if (pathToCheck.contains("}")) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            return pathParameters;
        }
        return pathParameters;
    }
}

