/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.Components;
import java.util.Map;
import java.util.logging.Logger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ReferenceValidator {
    private static final TraceComponent tc = Tr.register(ReferenceValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final Logger LOGGER = Logger.getLogger(ReferenceValidator.class.getName());
    private static final ReferenceValidator INSTANCE = new ReferenceValidator();
    static final long serialVersionUID = -3349355472629213784L;

    public static ReferenceValidator getInstance() {
        return INSTANCE;
    }

    private ReferenceValidator() {
    }

    public Object validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, String $ref) {
        if (context.getModel().getComponents() != null && $ref != null) {
            Components components = context.getModel().getComponents();
            if ($ref.contains(".json") || $ref.contains(".yml") || $ref.contains(".yaml") || $ref.contains("/x-") || $ref.startsWith("http://") || $ref.startsWith("https://")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceExternalOrExtension", (Object[])new Object[]{$ref});
                LOGGER.warning(message);
            } else {
                boolean validRefStruct = true;
                String[] references = $ref.split("/");
                if (!$ref.startsWith("#/components/") || references.length != 4) {
                    validRefStruct = false;
                }
                if (validRefStruct) {
                    block20: for (int i = 2; i < references.length - 1; ++i) {
                        String name = references[i + 1];
                        switch (references[i]) {
                            case "schemas": {
                                Map schemas = components.getSchemas();
                                if (schemas != null && schemas.containsKey(name)) {
                                    return schemas.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            case "responses": {
                                Map responses = components.getResponses();
                                if (responses != null && responses.containsKey(name)) {
                                    return responses.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            case "parameters": {
                                Map parameters = components.getParameters();
                                if (parameters != null && parameters.containsKey(name)) {
                                    return parameters.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            case "examples": {
                                Map examples = components.getExamples();
                                if (examples != null && examples.containsKey(name)) {
                                    return examples.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            case "requestBodies": {
                                Map requestBodies = components.getRequestBodies();
                                if (requestBodies != null && requestBodies.containsKey(name)) {
                                    return requestBodies.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            case "headers": {
                                Map headers = components.getHeaders();
                                if (headers != null && headers.containsKey(name)) {
                                    return headers.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            case "securitySchemes": {
                                Map securitySchemes = components.getSecuritySchemes();
                                if (securitySchemes != null && securitySchemes.containsKey(name)) {
                                    return securitySchemes.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            case "links": {
                                Map links = components.getLinks();
                                if (links != null && links.containsKey(name)) {
                                    return links.get(name);
                                }
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                                continue block20;
                            }
                            default: {
                                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotValid", (Object[])new Object[]{$ref});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                            }
                        }
                    }
                } else {
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotValidFormat", (Object[])new Object[]{$ref});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                }
            }
        } else {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNull", (Object[])new Object[]{context.getModel().getComponents(), $ref});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        return null;
    }
}

