/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.responses.ApiResponses;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResponsesValidator
extends TypeValidator<ApiResponses> {
    private static final TraceComponent tc = Tr.register(ResponsesValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final ResponsesValidator INSTANCE = new ResponsesValidator();
    static final long serialVersionUID = 4587265345788739586L;

    public static ResponsesValidator getInstance() {
        return INSTANCE;
    }

    private ResponsesValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, ApiResponses t) {
        if (t.size() == 0 && t.getDefault() == null) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"responseMustContainOneCode", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        } else if (!t.keySet().stream().anyMatch(v -> this.isSuccessStatusCode((String)v))) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"responseShouldContainSuccess", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
        }
    }

    @FFDCIgnore(value={NumberFormatException.class})
    private boolean isSuccessStatusCode(String s) {
        if (s == null) {
            return false;
        }
        if ("2XX".equals(s) || "default".equals(s)) {
            return true;
        }
        if (s.length() != 3) {
            return false;
        }
        try {
            int i = Integer.parseInt(s);
            return i >= 200 && i <= 299;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

