/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.security.SecurityRequirement;
import io.swagger.oas.models.security.SecurityScheme;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityRequirementValidator
extends TypeValidator<SecurityRequirement> {
    private static final TraceComponent tc = Tr.register(SecurityRequirementValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final SecurityRequirementValidator INSTANCE = new SecurityRequirementValidator();
    static final long serialVersionUID = 5387638038873839567L;

    public static SecurityRequirementValidator getInstance() {
        return INSTANCE;
    }

    private SecurityRequirementValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, SecurityRequirement t) {
        if (!t.isEmpty()) {
            Map schemes = null;
            if (context.getModel().getComponents() != null) {
                schemes = context.getModel().getComponents().getSecuritySchemes();
            }
            Set h = t.keySet();
            for (String name : h) {
                String message;
                if (schemes == null || !schemes.containsKey(name) || schemes.get(name) == null) {
                    String message2 = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementNotDeclared", (Object[])new Object[]{name});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, "SecurityRequirement", message2));
                    continue;
                }
                String type = ((SecurityScheme)schemes.get(name)).getType() != null ? ((SecurityScheme)schemes.get(name)).getType().toString() : null;
                List value = (List)t.get((Object)name);
                if ("oauth2".equals(type) || "openIdConnect".equals(type)) {
                    if (value != null && !value.isEmpty()) continue;
                    message = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementScopeNamesRequired", (Object[])new Object[]{name, value});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, "SecurityRequirement", message));
                    continue;
                }
                if (!"apiKey".equals(type) && !"http".equals(type) || value == null || value.isEmpty()) continue;
                message = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementFieldNotEmpty", (Object[])new Object[]{name, value});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, "SecurityRequirement", message));
            }
        } else {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementIsEmpty", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, "SecurityRequirement", message));
        }
    }
}

