/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.security.SecurityScheme;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecuritySchemeValidator
extends TypeValidator<SecurityScheme> {
    private static final TraceComponent tc = Tr.register(SecuritySchemeValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final SecuritySchemeValidator INSTANCE = new SecuritySchemeValidator();
    static final long serialVersionUID = -6937636072910630834L;

    public static SecuritySchemeValidator getInstance() {
        return INSTANCE;
    }

    private SecuritySchemeValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, SecurityScheme t) {
        String reference = t.get$ref();
        if (reference != null && !reference.isEmpty()) {
            ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
            return;
        }
        Optional<OASValidationResult.ValidationEvent> op_type = ValidatorUtils.validateRequiredField(t.getType(), "#/components/securitySchemes/" + key, "type");
        if (op_type.isPresent()) {
            op_type.ifPresent(helper::addValidationEvent);
        } else if ("apiKey".equals(t.getType().toString())) {
            ValidatorUtils.validateRequiredField(t.getName(), "#/components/securitySchemes/" + key, "name").ifPresent(helper::addValidationEvent);
            Optional<OASValidationResult.ValidationEvent> op_in = ValidatorUtils.validateRequiredField(t.getIn(), "#/components/securitySchemes/" + key, "in");
            if (op_in.isPresent()) {
                op_in.ifPresent(helper::addValidationEvent);
            } else {
                HashSet<String> inValues = new HashSet<String>(Arrays.asList("query", "header", "cookie"));
                if (!inValues.contains(t.getIn().toString())) {
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeInFieldInvalid", (Object[])new Object[]{key, t.getIn().toString()});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                }
            }
            if (t.getBearerFormat() != null || ValidatorUtils.flowsIsSet(t.getFlows()) || t.getOpenIdConnectUrl() != null || t.getScheme() != null) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeNonApplicableField", (Object[])new Object[]{t.getType().toString()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
            }
        } else if ("http".equals(t.getType().toString())) {
            ValidatorUtils.validateRequiredField(t.getScheme(), "#/components/securitySchemes/" + key, "scheme").ifPresent(helper::addValidationEvent);
            if (t.getOpenIdConnectUrl() != null || ValidatorUtils.flowsIsSet(t.getFlows()) || t.getName() != null || t.getIn() != null) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeNonApplicableField", (Object[])new Object[]{t.getType().toString()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
            }
        } else if ("oauth2".equals(t.getType().toString())) {
            ValidatorUtils.validateRequiredField(t.getFlows(), "#/components/securitySchemes/" + key, "flows").ifPresent(helper::addValidationEvent);
            if (t.getOpenIdConnectUrl() != null || t.getName() != null || t.getBearerFormat() != null || t.getIn() != null || t.getScheme() != null) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeNonApplicableField", (Object[])new Object[]{t.getType().toString()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
            }
        } else if ("openIdConnect".equals(t.getType().toString())) {
            String message;
            Optional<OASValidationResult.ValidationEvent> op_url = ValidatorUtils.validateRequiredField(t.getOpenIdConnectUrl(), "#/components/securitySchemes/" + key, "openIdConnectUrl");
            if (op_url.isPresent()) {
                op_url.ifPresent(helper::addValidationEvent);
            } else if (!ValidatorUtils.isValidURL(t.getOpenIdConnectUrl())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeInvalidURL", (Object[])new Object[]{t.getOpenIdConnectUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            }
            if (t.getBearerFormat() != null || ValidatorUtils.flowsIsSet(t.getFlows()) || t.getName() != null || t.getIn() != null || t.getScheme() != null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeNonApplicableField", (Object[])new Object[]{t.getType().toString()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
            }
        }
    }
}

