/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.servers.ServerVariables;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerValidator
extends TypeValidator<Server> {
    private static final TraceComponent tc = Tr.register(ServerValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final ServerValidator INSTANCE = new ServerValidator();
    static final long serialVersionUID = -7384398149927615044L;

    public static ServerValidator getInstance() {
        return INSTANCE;
    }

    private ServerValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Server t) {
        String url = t.getUrl();
        if (url != null) {
            Set<String> variables = this.validateURL(helper, url);
            this.validateServerVariables(helper, variables, t);
        } else {
            ValidatorUtils.validateRequiredField(url, key, "url").ifPresent(helper::addValidationEvent);
        }
    }

    private void validateServerVariables(ValidationHelper helper, Set<String> variables, Server t) {
        ServerVariables serverVariables = t.getVariables();
        for (String variable : variables) {
            if (serverVariables != null && serverVariables.containsKey((Object)variable)) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"serverVariableNotDefined", (Object[])new Object[]{variable});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }

    private Set<String> validateURL(ValidationHelper helper, String url) {
        String pathToCheck = url;
        HashSet<String> serverVariables = new HashSet<String>();
        while (pathToCheck.contains("{")) {
            int lastIndex;
            if (!pathToCheck.contains("}")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                return serverVariables;
            }
            int firstIndex = pathToCheck.indexOf("{");
            if (firstIndex > (lastIndex = pathToCheck.indexOf("}"))) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                return serverVariables;
            }
            String variable = pathToCheck.substring(firstIndex + 1, lastIndex);
            if (variable.isEmpty() || variable.contains("{") || variable.contains("/")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                return serverVariables;
            }
            serverVariables.add(variable);
            pathToCheck = pathToCheck.substring(lastIndex + 1);
        }
        if (pathToCheck.contains("}")) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"serverInvalidURL", (Object[])new Object[]{pathToCheck});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            return serverVariables;
        }
        return serverVariables;
    }
}

