/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.ReferenceValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.security.OAuthFlow;
import io.swagger.oas.models.security.OAuthFlows;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ValidatorUtils {
    private static final TraceComponent tc = Tr.register(ValidatorUtils.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    static final long serialVersionUID = -311046210012470551L;

    public static <T> Optional<OASValidationResult.ValidationEvent> validateRequiredField(T value, String location, String fieldName) {
        boolean isValid = true;
        if (value == null) {
            isValid = false;
        } else {
            if (value instanceof String && String.valueOf(value).isEmpty()) {
                isValid = false;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                isValid = false;
            }
        }
        if (!isValid) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"requiredFieldMissing", (Object[])new Object[]{location, fieldName});
            OASValidationResult.ValidationEvent event = new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, location, message);
            return Optional.of(event);
        }
        return Optional.empty();
    }

    @FFDCIgnore(value={MalformedURLException.class})
    public static boolean isValidURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean flowsIsSet(OAuthFlows flows) {
        if (flows != null) {
            OAuthFlow implicit = flows.getImplicit();
            OAuthFlow authCode = flows.getAuthorizationCode();
            OAuthFlow clientCred = flows.getClientCredentials();
            OAuthFlow password = flows.getPassword();
            if (implicit != null && (StringUtils.isNotBlank((CharSequence)implicit.getAuthorizationUrl()) || StringUtils.isNotBlank((CharSequence)implicit.getTokenUrl()) || StringUtils.isNotBlank((CharSequence)implicit.getRefreshUrl()) || implicit.getScopes() != null || implicit.getExtensions() != null)) {
                return true;
            }
            if (authCode != null && (StringUtils.isNotBlank((CharSequence)authCode.getTokenUrl()) || StringUtils.isNotBlank((CharSequence)authCode.getRefreshUrl()) || StringUtils.isNotBlank((CharSequence)authCode.getAuthorizationUrl()) || authCode.getScopes() != null || authCode.getExtensions() != null)) {
                return true;
            }
            if (clientCred != null && (StringUtils.isNotBlank((CharSequence)clientCred.getTokenUrl()) || StringUtils.isNotBlank((CharSequence)clientCred.getRefreshUrl()) || StringUtils.isNotBlank((CharSequence)clientCred.getAuthorizationUrl()) || clientCred.getScopes() != null || clientCred.getExtensions() != null)) {
                return true;
            }
            if (password != null && (StringUtils.isNotBlank((CharSequence)password.getTokenUrl()) || StringUtils.isNotBlank((CharSequence)password.getRefreshUrl()) || StringUtils.isNotBlank((CharSequence)password.getAuthorizationUrl()) || password.getScopes() != null || password.getExtensions() != null)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static void referenceValidatorHelper(String reference, Object t, ValidationHelper helper, OpenAPIModelWalker.Context context, String key) {
        ReferenceValidator referenceValidator = ReferenceValidator.getInstance();
        Object component = referenceValidator.validate(helper, context, key, reference);
        if (!t.getClass().isInstance(component)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceToObjectInvalid", (Object[])new Object[]{reference, t.getClass().getName()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }
}

