/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.openapi.internal.OASProviderWrapper;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.openapi.merge.OASRenameVisitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.openapi.OASProviderConfig;
import io.swagger.oas.models.Components;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OASMergeService {
    public static final String OA_TAGS = "$.tags";
    public static final String OA_COMPONENTS = "$.components";
    public static final String OA_COMPONENTS_EXAMPLES = "$.components.examples";
    public static final String OA_COMPONENTS_CALLBACKS = "$.components.callbacks";
    public static final String OA_COMPONENTS_LINKS = "$.components.links";
    public static final String OA_COMPONENTS_HEADERS = "$.components.headers";
    public static final String OA_COMPONENTS_PARAMETERS = "$.components.parameters";
    public static final String OA_COMPONENTS_REQUEST_BODIES = "$.components.requestBodies";
    public static final String OA_COMPONENTS_RESPONSES = "$.components.responses";
    public static final String OA_COMPONENTS_SECURITY_SHEMES = "$.components.securitySchemes";
    public static final String OA_COMPONENTS_SCHEMAS = "$.components.schemas";
    public static final String OA_PATHS = "$.paths";
    public static final String OA_OPERATION_ID = "$.paths..operationId";
    private static final TraceComponent tc = Tr.register(OASMergeService.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private final Map<String, Integer> referencesCount = new HashMap<String, Integer>();
    private final Set<String> operationIds = new HashSet<String>();
    private final List<OASProviderWrapper> OASProviders = new LinkedList<OASProviderWrapper>();
    private final Map<String, Map<String, String>> conflictsMap = new HashMap<String, Map<String, String>>();
    private volatile OASProviderWrapper incomingProvider = null;
    private OpenAPI OAInProgress = null;
    private volatile boolean skipAddingKeys = false;
    static final long serialVersionUID = -8548160364965871974L;

    public synchronized void addAPIProvider(OASProviderWrapper inDoc) {
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("Started merging OASProvider: " + inDoc.getOpenAPIProvider()), (Object[])new Object[0]);
        }
        this.conflictsMap.clear();
        inDoc.getJsonPathKeys().clear();
        this.OASProviders.add(inDoc);
        this.incomingProvider = inDoc;
        List results = inDoc.getOpenAPIProvider().getResults();
        List configs = results.stream().map(result -> result.getOASProviderConfig()).collect(Collectors.toList());
        this.skipAddingKeys = false;
        for (OASProviderConfig config : configs) {
            this.OAInProgress = this.incomingProvider.getOpenAPI(config);
            this.addServers();
            this.addTags();
            this.addPaths();
            this.addComponents();
            this.addSecurity();
            this.addExtensions();
            List<Operation> operations = OASMergeService.getAllOperations(this.OAInProgress);
            for (Operation operation : operations) {
                String operationId = operation.getOperationId();
                if (operationId == null) continue;
                if (this.operationIds.contains(operationId)) {
                    int count = 0;
                    String newOperationId = operationId + "_" + count;
                    while (this.operationIds.contains(newOperationId)) {
                        newOperationId = operationId + "_" + ++count;
                    }
                    this.getConflictsMap(OA_OPERATION_ID).put(operationId, newOperationId);
                    operation.setOperationId(newOperationId);
                    this.operationIds.add(newOperationId);
                    continue;
                }
                this.operationIds.add(operationId);
            }
            this.renameReferences();
            this.skipAddingKeys = true;
        }
        this.incomingProvider = null;
        this.OAInProgress = null;
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("Done merging OASProvider: " + inDoc.getOpenAPIProvider()), (Object[])new Object[0]);
        }
    }

    public synchronized void removeAPIProvider(OASProviderWrapper inDoc) {
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("Started removing OASProvider: " + inDoc.getOpenAPIProvider()), (Object[])new Object[0]);
        }
        this.decrementReferencesCount(inDoc);
        Set opIds = OASMergeService.getAllOperations(inDoc.getOpenAPI()).stream().map(op -> op.getOperationId()).collect(Collectors.toSet());
        this.operationIds.removeAll(opIds);
        this.OASProviders.remove(inDoc);
        inDoc.getJsonPathKeys().clear();
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("Done removing OASProvider: " + inDoc.getOpenAPIProvider()), (Object[])new Object[0]);
        }
    }

    private void incrementReferencesCount(String jpKey) {
        Integer c = this.referencesCount.get(jpKey);
        int count = c != null ? c : 0;
        this.referencesCount.put(jpKey, ++count);
    }

    private void decrementReferencesCount(OASProviderWrapper apiProvider) {
        if (OpenAPIUtils.isDumpEnabled.test(tc)) {
            Tr.dump((TraceComponent)tc, (String)("References before removal: " + this.debugPrintReferences()), (Object[])new Object[0]);
        }
        for (String jpKey : apiProvider.getJsonPathKeys()) {
            int count;
            Integer c = this.referencesCount.get(jpKey);
            int n = count = c != null ? c : 0;
            if (--count > 0) {
                this.referencesCount.put(jpKey, count);
                continue;
            }
            this.referencesCount.remove(jpKey);
        }
        if (OpenAPIUtils.isDumpEnabled.test(tc)) {
            Tr.dump((TraceComponent)tc, (String)("References after removal: " + this.debugPrintReferences()), (Object[])new Object[0]);
        }
    }

    private void addPaths() {
        Paths incomingPaths = this.OAInProgress.getPaths();
        if (incomingPaths == null || incomingPaths.isEmpty()) {
            return;
        }
        incomingPaths.forEach((path, pathItem) -> this.addKey("$.paths." + path));
    }

    private void addTags() {
        List incomingTags = this.OAInProgress.getTags();
        if (incomingTags == null || incomingTags.isEmpty()) {
            return;
        }
        incomingTags.stream().forEach(tag -> {
            String tagName = tag.getName();
            String jpKey = "$.tags[?(@.name=='" + tagName + "')]";
            int count = 1;
            while (this.detectConflict(jpKey, tag)) {
                tag.setName(tagName + count);
                jpKey = "$.tags[?(@.name=='" + tag.getName() + "')]";
                ++count;
            }
            if (!tagName.equals(tag.getName())) {
                this.setConlictPair(OA_TAGS, tagName, tag.getName());
            }
            this.addKey(jpKey);
        });
    }

    private boolean shouldAddBasePath(List<Server> servers) {
        if (servers.size() != 1) {
            return false;
        }
        Server server = servers.get(0);
        if (server == null) {
            return false;
        }
        String url = server.getUrl();
        if (url == null) {
            return false;
        }
        if (url.equals("/")) {
            return false;
        }
        if (!url.startsWith("/")) {
            return false;
        }
        if (url.contains("{") || url.contains("}")) {
            return false;
        }
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)"Found 1 server with a basepath. Adding to paths", (Object[])new Object[0]);
        }
        return true;
    }

    private void addServers() {
        List incomingServers = this.OAInProgress.getServers();
        if (incomingServers == null || incomingServers.isEmpty()) {
            return;
        }
        Paths incomingPaths = this.OAInProgress.getPaths();
        if (incomingPaths == null || incomingPaths.isEmpty()) {
            return;
        }
        if (this.shouldAddBasePath(incomingServers)) {
            Paths paths = new Paths();
            paths.setExtensions(incomingPaths.getExtensions());
            incomingPaths.forEach((path, pathItem) -> {
                if (pathItem.getServers() == null) {
                    String serverUrl = ((Server)incomingServers.get(0)).getUrl();
                    String url = serverUrl.endsWith("/") ? serverUrl.substring(0, serverUrl.length()) : serverUrl;
                    paths.addPathItem(url + path, pathItem);
                } else {
                    paths.addPathItem(path, pathItem);
                }
            });
            this.OAInProgress.setPaths(paths);
        } else {
            incomingPaths.values().forEach(path -> {
                if (path.getServers() == null) {
                    path.setServers(incomingServers);
                }
            });
        }
        this.OAInProgress.setServers(null);
    }

    private void addExtensions() {
        Map incomingExtensions = this.OAInProgress.getExtensions();
        if (incomingExtensions == null || incomingExtensions.isEmpty()) {
            return;
        }
        incomingExtensions.forEach((k, v) -> this.addKey("$." + k));
    }

    private <T> Map<String, T> handleMapRename(Map<String, T> map, String jpKeyPrefix) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap new_map = new HashMap();
        map.forEach((k, v) -> {
            String jpathKey = jpKeyPrefix + "." + k;
            int count = 1;
            String new_key = k;
            while (this.detectConflict(jpathKey, v)) {
                new_key = k + count;
                jpathKey = jpKeyPrefix + "." + new_key;
                ++count;
            }
            if (!k.equals(new_key)) {
                this.setConlictPair(jpKeyPrefix, (String)k, new_key);
            }
            new_map.put(new_key, v);
            this.addKey(jpathKey);
        });
        return new_map;
    }

    private void addComponents() {
        Components incomingComponents = this.OAInProgress.getComponents();
        if (incomingComponents == null) {
            return;
        }
        Map m = null;
        m = this.handleMapRename(incomingComponents.getExamples(), OA_COMPONENTS_EXAMPLES);
        incomingComponents.setExamples(m);
        m = this.handleMapRename(incomingComponents.getCallbacks(), OA_COMPONENTS_CALLBACKS);
        incomingComponents.setCallbacks(m);
        m = this.handleMapRename(incomingComponents.getHeaders(), OA_COMPONENTS_HEADERS);
        incomingComponents.setHeaders(m);
        m = this.handleMapRename(incomingComponents.getLinks(), OA_COMPONENTS_LINKS);
        incomingComponents.setLinks(m);
        m = this.handleMapRename(incomingComponents.getParameters(), OA_COMPONENTS_PARAMETERS);
        incomingComponents.setParameters(m);
        m = this.handleMapRename(incomingComponents.getRequestBodies(), OA_COMPONENTS_REQUEST_BODIES);
        incomingComponents.setRequestBodies(m);
        m = this.handleMapRename(incomingComponents.getResponses(), OA_COMPONENTS_RESPONSES);
        incomingComponents.setResponses(m);
        m = this.handleMapRename(incomingComponents.getSecuritySchemes(), OA_COMPONENTS_SECURITY_SHEMES);
        incomingComponents.setSecuritySchemes(m);
        m = this.handleMapRename(incomingComponents.getSchemas(), OA_COMPONENTS_SCHEMAS);
        incomingComponents.setSchemas(m);
        Map incomingExt = incomingComponents.getExtensions();
        if (incomingExt != null && !incomingExt.isEmpty()) {
            incomingExt.forEach((k, v) -> this.addKey("$.components." + k));
        }
    }

    private void addSecurity() {
        List incomingSecReq = this.OAInProgress.getSecurity();
        if (incomingSecReq == null || incomingSecReq.isEmpty()) {
            return;
        }
        Paths incomingPaths = this.OAInProgress.getPaths();
        if (incomingPaths == null) {
            return;
        }
        List<Operation> operations = incomingPaths.values().stream().flatMap(path -> Stream.of(path.getGet(), path.getPost(), path.getPut(), path.getDelete(), path.getHead(), path.getOptions(), path.getPatch(), path.getTrace())).filter(operation -> operation != null && operation.getSecurity() == null).collect(Collectors.toList());
        operations.forEach(operation -> operation.setSecurity(incomingSecReq));
    }

    public String debugPrintReferences() {
        StringBuilder sb = new StringBuilder();
        sb.append("Number of APIProvider references per key:\n");
        this.referencesCount.forEach((k, v) -> sb.append(k + ":" + v + "\n"));
        return sb.toString();
    }

    private boolean detectConflict(String jpKey, Object newItem) {
        if (this.referencesCount.get(jpKey) == null) {
            return false;
        }
        if (this.skipAddingKeys) {
            return true;
        }
        OASProviderWrapper wrapper = this.OASProviders.stream().filter(provider -> provider.getJsonPathKeys().contains(jpKey)).findFirst().orElse(null);
        if (wrapper == null) {
            return false;
        }
        Object item = this.getItemAtKey(jpKey, wrapper.getOpenAPI());
        return !item.equals(newItem);
    }

    private void addKey(String jpKey) {
        if (!this.skipAddingKeys) {
            this.incomingProvider.getJsonPathKeys().add(jpKey);
            this.incrementReferencesCount(jpKey);
        }
    }

    private void setConlictPair(String type, String original, String newName) {
        Map<String, String> conflictPairs = this.getConflictsMap(type);
        conflictPairs.put(original, newName);
    }

    private Map<String, String> getConflictsMap(String type) {
        Map<String, String> conflicts = this.conflictsMap.get(type);
        if (conflicts == null) {
            conflicts = new HashMap<String, String>();
            this.conflictsMap.put(type, conflicts);
        }
        return conflicts;
    }

    private Object getItemAtKey(String jpKey, OpenAPI openAPI) {
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)("Trying to get item at key: " + jpKey), (Object[])new Object[0]);
        }
        if (jpKey.startsWith(OA_TAGS)) {
            if (openAPI.getTags() == null) {
                return null;
            }
            Pattern p = Pattern.compile("name=='(.*)'");
            Matcher m = p.matcher(jpKey);
            if (m.find()) {
                String tagName = m.group(1);
                return openAPI.getTags().stream().filter(tag -> tag.getName().equals(tagName)).findFirst().orElse(null);
            }
        } else {
            if (jpKey.startsWith(OA_PATHS)) {
                String pathKey = jpKey.split("\\.")[2];
                return openAPI.getPaths().get((Object)pathKey);
            }
            if (jpKey.startsWith(OA_COMPONENTS)) {
                String[] items = jpKey.split("\\.");
                String itemKey = items.length >= 4 ? items[3] : items[2];
                Components components = openAPI.getComponents();
                if (components == null) {
                    return null;
                }
                if (jpKey.startsWith(OA_COMPONENTS_EXAMPLES)) {
                    return components.getExamples().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_CALLBACKS)) {
                    return components.getCallbacks().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_HEADERS)) {
                    return components.getHeaders().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_LINKS)) {
                    return components.getLinks().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_PARAMETERS)) {
                    return components.getParameters().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_REQUEST_BODIES)) {
                    return components.getRequestBodies().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_RESPONSES)) {
                    return components.getResponses().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_SECURITY_SHEMES)) {
                    return components.getSecuritySchemes().get(itemKey);
                }
                if (jpKey.startsWith(OA_COMPONENTS_SCHEMAS)) {
                    return components.getSchemas().get(itemKey);
                }
                if (jpKey.startsWith("$.components.x-")) {
                    return components.getExtensions().get(itemKey);
                }
            } else if (jpKey.startsWith("$.x-")) {
                String extensionKey = jpKey.substring("$.".length());
                return openAPI.getExtensions().get(extensionKey);
            }
        }
        return null;
    }

    private void renameReferences() {
        OpenAPI openAPI = this.OAInProgress;
        OASRenameVisitor renameVisitor = new OASRenameVisitor(openAPI, this.conflictsMap);
        renameVisitor.renameRefs();
    }

    private <T> Map<String, T> mergeMaps(Map<String, T> resultMap, Map<String, T> inMap) {
        if (inMap == null || inMap.isEmpty()) {
            return resultMap;
        }
        if (resultMap == null) {
            resultMap = new HashMap<String, T>();
        }
        resultMap.putAll(inMap);
        return resultMap;
    }

    public void mergeOpenAPI(OpenAPI result, OpenAPI in) {
        Map extensions;
        Paths inPaths;
        Components inComponents;
        List inTags = in.getTags();
        if (inTags != null && !inTags.isEmpty()) {
            Set tagNames = null;
            if (result.getTags() != null) {
                tagNames = result.getTags().stream().map(tag -> tag.getName()).collect(Collectors.toSet());
            }
            for (Tag tag2 : inTags) {
                if (tagNames != null && tagNames.contains(tag2.getName())) continue;
                result.addTagsItem(tag2);
            }
        }
        if ((inComponents = in.getComponents()) != null) {
            if (result.getComponents() == null) {
                result.setComponents(new Components());
            }
            Components resComponents = result.getComponents();
            Map resMap = this.mergeMaps(resComponents.getCallbacks(), inComponents.getCallbacks());
            resComponents.setCallbacks(resMap);
            resMap = this.mergeMaps(resComponents.getExamples(), inComponents.getExamples());
            resComponents.setExamples(resMap);
            resMap = this.mergeMaps(resComponents.getExtensions(), inComponents.getExtensions());
            resComponents.setExtensions(resMap);
            resMap = this.mergeMaps(resComponents.getHeaders(), inComponents.getHeaders());
            resComponents.setHeaders(resMap);
            resMap = this.mergeMaps(resComponents.getLinks(), inComponents.getLinks());
            resComponents.setLinks(resMap);
            resMap = this.mergeMaps(resComponents.getParameters(), inComponents.getParameters());
            resComponents.setParameters(resMap);
            resMap = this.mergeMaps(resComponents.getRequestBodies(), inComponents.getRequestBodies());
            resComponents.setRequestBodies(resMap);
            resMap = this.mergeMaps(resComponents.getResponses(), inComponents.getResponses());
            resComponents.setResponses(resMap);
            resMap = this.mergeMaps(resComponents.getSchemas(), inComponents.getSchemas());
            resComponents.setSchemas(resMap);
            resMap = this.mergeMaps(resComponents.getSecuritySchemes(), inComponents.getSecuritySchemes());
            resComponents.setSecuritySchemes(resMap);
        }
        if ((inPaths = in.getPaths()) != null && !inPaths.isEmpty()) {
            if (result.getPaths() == null) {
                result.setPaths(new Paths());
            }
            Paths resultPaths = result.getPaths();
            inPaths.forEach((pathKey, pathItem) -> resultPaths.addPathItem(pathKey, pathItem));
        }
        if ((extensions = in.getExtensions()) != null && !extensions.isEmpty()) {
            extensions.forEach((extKey, extVal) -> result.addExtension(extKey, extVal));
        }
    }

    public static List<Operation> getAllOperations(OpenAPI openAPI) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (openAPI.getPaths() != null) {
            openAPI.getPaths().forEach((path, pathItem) -> operations.addAll(OASMergeService.getAllOperationsForPath(pathItem)));
        }
        return operations;
    }

    public static List<Operation> getAllOperationsForPath(PathItem pathItem) {
        Stream<Object> ops = Arrays.asList(pathItem.getGet(), pathItem.getPost(), pathItem.getPut(), pathItem.getDelete(), pathItem.getHead(), pathItem.getOptions(), pathItem.getPatch(), pathItem.getTrace()).stream();
        ops = ops.filter(Objects::nonNull);
        return ops.collect(Collectors.toList());
    }
}

