/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.DefaultOpenAPIModelVisitor;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.links.Link;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.security.SecurityScheme;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OASRenameVisitor
extends DefaultOpenAPIModelVisitor {
    private final Map<String, Map<String, String>> conflicsMap;
    private final OpenAPI openAPI;
    static final long serialVersionUID = -2030277750111701382L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OASRenameVisitor(OpenAPI openAPI, Map confMap) {
        this.conflicsMap = confMap;
        this.openAPI = openAPI;
    }

    public void renameRefs() {
        OpenAPIModelWalker walker = new OpenAPIModelWalker(this.openAPI);
        walker.accept(this);
    }

    @Override
    public void visitExample(OpenAPIModelWalker.Context context, Example example) {
        String oldName;
        String newName;
        String reference = example.get$ref();
        if (reference != null && reference.startsWith("#/components/examples/") && (newName = this.getNewName("$.components.examples", oldName = reference.split("/")[3])) != null) {
            example.set$ref("#/components/examples/" + newName);
        }
    }

    @Override
    public void visitExample(OpenAPIModelWalker.Context context, String key, Example example) {
        String oldName;
        String newName;
        String reference = example.get$ref();
        if (reference != null && reference.startsWith("#/components/examples/") && (newName = this.getNewName("$.components.examples", oldName = reference.split("/")[3])) != null) {
            example.set$ref("#/components/examples/" + newName);
        }
    }

    @Override
    public void visitHeader(OpenAPIModelWalker.Context context, String key, Header header) {
        String oldName;
        String newName;
        String reference = header.get$ref();
        if (reference != null && reference.startsWith("#/components/headers/") && (newName = this.getNewName("$.components.headers", oldName = reference.split("/")[3])) != null) {
            header.set$ref("#/components/headers/" + newName);
        }
    }

    @Override
    public void visitLink(OpenAPIModelWalker.Context context, String key, Link link) {
        String reference = link.get$ref();
        if (reference != null && reference.startsWith("#/components/links/")) {
            String oldName = reference.split("/")[3];
            String newName = this.getNewName("$.components.links", oldName);
            if (newName != null) {
                link.set$ref("#/components/links/" + newName);
            }
        } else if (reference == null) {
            String operaitonId = link.getOperationId();
            String new_operationId = this.getConflictsMap("$.paths..operationId").get(operaitonId);
            if (new_operationId != null) {
                link.setOperationId(new_operationId);
            }
        }
    }

    @Override
    public void visitParameter(OpenAPIModelWalker.Context context, Parameter p) {
        String oldName;
        String newName;
        String reference = p.get$ref();
        if (reference != null && reference.startsWith("#/components/parameters/") && (newName = this.getNewName("$.components.parameters", oldName = reference.split("/")[3])) != null) {
            p.set$ref("#/components/parameters/" + newName);
        }
    }

    @Override
    public void visitParameter(OpenAPIModelWalker.Context context, String key, Parameter p) {
        String oldName;
        String newName;
        String reference = p.get$ref();
        if (reference != null && reference.startsWith("#/components/parameters/") && (newName = this.getNewName("$.components.parameters", oldName = reference.split("/")[3])) != null) {
            p.set$ref("#/components/parameters/" + newName);
        }
    }

    @Override
    public void visitRequestBody(OpenAPIModelWalker.Context context, RequestBody rb) {
        String oldName;
        String newName;
        String reference = rb.get$ref();
        if (reference != null && reference.startsWith("#/components/requestBodies/") && (newName = this.getNewName("$.components.requestBodies", oldName = reference.split("/")[3])) != null) {
            rb.set$ref("#/components/requestBodies/" + newName);
        }
    }

    @Override
    public void visitRequestBody(OpenAPIModelWalker.Context context, String key, RequestBody rb) {
        String oldName;
        String newName;
        String reference = rb.get$ref();
        if (reference != null && reference.startsWith("#/components/requestBodies/") && (newName = this.getNewName("$.components.requestBodies", oldName = reference.split("/")[3])) != null) {
            rb.set$ref("#/components/requestBodies/" + newName);
        }
    }

    @Override
    public void visitResponse(OpenAPIModelWalker.Context context, String key, ApiResponse response) {
        String oldName;
        String newName;
        String reference = response.get$ref();
        if (reference != null && reference.startsWith("#/components/responses/") && (newName = this.getNewName("$.components.responses", oldName = reference.split("/")[3])) != null) {
            response.set$ref("#/components/responses/" + newName);
        }
    }

    @Override
    public void visitSchema(OpenAPIModelWalker.Context context, Schema<?> schema) {
        String oldName;
        String newName;
        String reference = schema.get$ref();
        if (reference != null && reference.startsWith("#/components/schemas/") && (newName = this.getNewName("$.components.schemas", oldName = reference.split("/")[3])) != null) {
            schema.set$ref("#/components/schemas/" + newName);
        }
    }

    @Override
    public void visitSchema(OpenAPIModelWalker.Context context, String key, Schema<?> schema) {
        String oldName;
        String newName;
        String reference = schema.get$ref();
        if (reference != null && reference.startsWith("#/components/schemas/") && (newName = this.getNewName("$.components.schemas", oldName = reference.split("/")[3])) != null) {
            schema.set$ref("#/components/schemas/" + newName);
        }
    }

    @Override
    public void visitSecurityScheme(OpenAPIModelWalker.Context context, String key, SecurityScheme scheme) {
        String oldName;
        String newName;
        String reference = scheme.get$ref();
        if (reference != null && reference.startsWith("#/components/securitySchemes/") && (newName = this.getNewName("$.components.securitySchemes", oldName = reference.split("/")[3])) != null) {
            scheme.set$ref("#/components/securitySchemes/" + newName);
        }
    }

    @Override
    public void visitOperation(OpenAPIModelWalker.Context context, Operation operation) {
        List tags = operation.getTags();
        if (tags != null) {
            Iterator tagsIt = tags.iterator();
            HashSet<String> new_tags = new HashSet<String>();
            while (tagsIt.hasNext()) {
                String tagName = (String)tagsIt.next();
                String new_tagName = this.getNewName("$.tags", tagName);
                if (new_tagName == null) continue;
                tagsIt.remove();
                new_tags.add(new_tagName);
            }
            tags.addAll(new_tags);
        }
    }

    private String getNewName(String type, String original) {
        Map<String, String> conflictPairs = this.getConflictsMap(type);
        return conflictPairs.get(original);
    }

    private Map<String, String> getConflictsMap(String type) {
        Map<String, String> conflicts = this.conflicsMap.get(type);
        if (conflicts == null) {
            conflicts = new HashMap<String, String>();
            this.conflicsMap.put(type, conflicts);
        }
        return conflicts;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.merge.OASRenameVisitor", OASRenameVisitor.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    }
}

