/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.webbeans.context.CDIContainerConfig;
import com.ibm.ws.webbeans.context.CDIContainerType;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import org.osgi.service.component.ComponentContext;

public class CDIAdapter
implements ContainerAdapter<CDIContainerConfig> {
    private static final TraceComponent tc = Tr.register(CDIAdapter.class);

    public CDIContainerConfig adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        CDIContainerConfig containerConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"adapt", (Object[])new Object[0]);
        }
        if ((containerConfig = (CDIContainerConfig)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), CDIContainerConfig.class)) == null) {
            containerConfig = new CDIContainerConfig();
            NonPersistentCache cache = (NonPersistentCache)containerToAdapt.adapt(NonPersistentCache.class);
            WebModuleInfo webModuleInfo = (WebModuleInfo)cache.getFromCache(WebModuleInfo.class);
            if (webModuleInfo != null) {
                containerConfig.setType(CDIContainerType.WAR);
                containerConfig.setCdiEnabled(containerToAdapt.getEntry("/WEB-INF/beans.xml") != null);
            } else {
                containerConfig.setType(CDIContainerType.EJB);
                containerConfig.setCdiEnabled(containerToAdapt.getEntry("/META-INF/beans.xml") != null);
            }
            if (containerConfig.getType() == CDIContainerType.WAR && !containerConfig.isCdiEnabled()) {
                Entry libDir;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"container is a war, but no beans.xml in the WEB-INF directory.  Checking the jars", (Object[])new Object[0]);
                }
                if ((libDir = containerToAdapt.getEntry("/WEB-INF/lib")) != null) {
                    try {
                        Container libDirContainer = (Container)libDir.adapt(Container.class);
                        if (libDirContainer != null) {
                            containerConfig.setCdiEnabled(this.findAnyBeansXml(libDirContainer));
                        }
                    }
                    catch (UnableToAdaptException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            }
            cache.addToCache(CDIContainerConfig.class, (Object)containerConfig);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"adapt", (Object)containerConfig);
        }
        return containerConfig;
    }

    private boolean findAnyBeansXml(Container container) {
        for (Entry subEntry : container) {
            try {
                Container subEntryContainer = (Container)subEntry.adapt(Container.class);
                String libEntryString = subEntry.getPath();
                if (!libEntryString.endsWith(".jar") || subEntryContainer.getEntry("/META-INF/beans.xml") == null) continue;
                return true;
            }
            catch (UnableToAdaptException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Unable to adapt a jar within the application.  Error: {0}", (Object[])new Object[]{e});
            }
        }
        return false;
    }

    protected void activate(ComponentContext context) {
    }

    protected void deactivate(ComponentContext context) {
    }
}

