/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.context;

import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.webbeans.context.CDIContainerConfig;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.LibertyContextsService;

public class CDIContextHolder
implements CDIMetaData {
    private Set<ContainerInfo> containerInfos;
    private ModuleInfo moduleInfo;
    private final List<Container> containers = new ArrayList<Container>();
    private WebBeansContext webBeansContext;
    private LibertyContextsService contextsService = null;
    private volatile boolean contextsInitialized = false;
    private boolean isEjb = false;
    ResourceRefConfigFactory resourceRefConfigFactory;
    private boolean lifeCycleStarted = false;
    private List<Object> listEjbEndpoints;
    private List<Class<?>> beanClasses;
    private ClassLoader contextClassLoader;
    private boolean isCDIEnabled = false;

    @Override
    public List<Class<?>> getBeanClasses() {
        return this.beanClasses;
    }

    @Override
    public void setBeanClasses(List<Class<?>> beanClasses) {
        this.beanClasses = beanClasses;
    }

    @Override
    public void cleanupBeanClasses() {
        this.beanClasses = null;
    }

    @Override
    public void setWebBeansContext(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    @Override
    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    @Override
    public boolean isEjb() {
        return this.isEjb;
    }

    @Override
    public void setIsEjb(boolean b) {
        this.isEjb = b;
    }

    @Override
    public synchronized boolean isLifecycleStarted() {
        return this.lifeCycleStarted;
    }

    @Override
    public synchronized void setLifeCycleStarted(boolean b) {
        this.lifeCycleStarted = b;
    }

    @Override
    public void setContainerInfos(Set<ContainerInfo> infos) {
        this.containerInfos = infos;
    }

    @Override
    public Set<ContainerInfo> getContainerInfos() {
        return this.containerInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LibertyContextsService getContextsService() {
        if (this.contextsService == null && this.webBeansContext != null) {
            CDIContextHolder cDIContextHolder = this;
            synchronized (cDIContextHolder) {
                if (!this.contextsInitialized) {
                    this.contextsService = (LibertyContextsService)this.webBeansContext.getContextsService();
                    this.contextsInitialized = true;
                }
            }
        }
        return this.contextsService;
    }

    @Override
    public synchronized List<Object> getListEJBEndpoints() {
        return this.listEjbEndpoints;
    }

    @Override
    public synchronized void addEJBEndpoints(Object ejbEndpoints) {
        if (this.listEjbEndpoints == null) {
            this.listEjbEndpoints = new ArrayList<Object>();
        }
        this.listEjbEndpoints.add(ejbEndpoints);
    }

    @Override
    public synchronized void removeAllEJBEndpoints() {
        this.listEjbEndpoints = null;
    }

    @Override
    public void setModuleInfo(ModuleInfo info) {
        this.moduleInfo = info;
    }

    @Override
    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    @Override
    public ResourceRefConfigFactory getResourceRefFactory() {
        return this.resourceRefConfigFactory;
    }

    @Override
    public void setResourceRefFactory(ResourceRefConfigFactory factory) {
        this.resourceRefConfigFactory = factory;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        this.contextClassLoader = loader;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Override
    public boolean isCDIEnabled() {
        return this.isCDIEnabled;
    }

    public void setCDIEnabled(Container container) throws UnableToAdaptException {
        if (!this.isCDIEnabled) {
            CDIContainerConfig cdiContainerConfig = (CDIContainerConfig)container.adapt(CDIContainerConfig.class);
            this.isCDIEnabled = cdiContainerConfig.isCdiEnabled();
        }
    }
}

