/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.impl.scanner;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.config.extended.RefBndAndExtHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.javaee.dd.managedbean.ManagedBean;
import com.ibm.ws.javaee.dd.managedbean.ManagedBeanBnd;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webbeans.context.CDIContextHolder;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.ws.webbeans.impl.scanner.ResourceInjectionBagService;
import com.ibm.ws.webbeans.services.ResourceInjectionBag;
import com.ibm.ws.webbeans.services.ResourceInjectionServiceImpl;
import com.ibm.wsspi.adaptable.module.Adaptable;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.corespi.se.DefaultBDABeansXmlScanner;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.WebBeansUtil;

public class LibertyScannerService
implements ScannerService {
    private static final TraceComponent tc = Tr.register(LibertyScannerService.class);
    private static final String CROSS_EJB_MODULE_BINDINGS = "com.ibm.ws.webbeans.crossEjbModuleBindings";
    private Set<URL> beanUrls;
    private HashMap<String, Class<?>> beanClasses;
    private HashSet<Class<?>> beanClassesSet;
    private Boolean isBDAScannerEnabled;
    private BDABeansXmlScanner bdaBeansXmlScanner;
    private WebBeansContext webBeansContext;
    private ResourceInjectionBag currentRib;
    private Container moduleContainer;
    private int alreadyCalled = 0;
    static final String CLASS_EXT = ".class";
    static final int CLASS_EXT_SIZE = 6;
    static final String DOT = ".";
    static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    static final String META_INF_BEANS_XML = "META-INF/beans.xml";

    public Set<String> getAllAnnotations(String className) {
        Class<?> clazz;
        if (this.beanClasses != null && (clazz = this.beanClasses.get(className)) != null) {
            Annotation[] annos = clazz.getAnnotations();
            HashSet<String> annoSet = new HashSet<String>();
            for (int i = 0; i < annos.length; ++i) {
                annoSet.add(annos[i].toString());
            }
            return annoSet;
        }
        return Collections.emptySet();
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return this.bdaBeansXmlScanner;
    }

    public Set<Class<?>> getBeanClasses() {
        if (this.beanClasses != null) {
            if (this.beanClassesSet == null) {
                this.beanClassesSet = new HashSet(this.beanClasses.values());
            }
            return this.beanClassesSet;
        }
        return Collections.emptySet();
    }

    public Set<URL> getBeanXmls() {
        if (this.beanUrls != null) {
            return this.beanUrls;
        }
        return Collections.emptySet();
    }

    public void init(Object object) {
        if (!(object instanceof Container)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"init was passed an object that is not a Container", (Object[])new Object[0]);
            }
            return;
        }
        this.moduleContainer = (Container)object;
    }

    public void setWebBeansContext(WebBeansContext webBeansContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting webBeansContext for " + this), (Object[])new Object[0]);
        }
        this.webBeansContext = webBeansContext;
        this.setBDAEnabledFlag(webBeansContext);
    }

    private void setBDAEnabledFlag(WebBeansContext webBeansContext) {
        String usage = this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.useBDABeansXMLScanner");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing isBDAScannerEnabled for " + this + ": " + usage), (Object[])new Object[0]);
        }
        this.isBDAScannerEnabled = Boolean.valueOf(usage);
    }

    public boolean isBDABeansXmlScanningEnabled() {
        boolean result = false;
        if (this.isBDAScannerEnabled != null) {
            result = this.isBDAScannerEnabled;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isBDAScannerEnabled=" + result), (Object[])new Object[0]);
        }
        return result;
    }

    public void release() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Calling release for " + this), (Object[])new Object[0]);
        }
        this.beanUrls = null;
        this.beanClasses = null;
        this.beanClassesSet = null;
    }

    public void setResourceInjectionBagServices(Iterator<ResourceInjectionBagService> resourceInjectionBagServices, List<Container> containers) {
        if (resourceInjectionBagServices != null) {
            this.currentRib = null;
            if (containers != null) {
                while (resourceInjectionBagServices.hasNext()) {
                    ResourceInjectionBagService ribService = resourceInjectionBagServices.next();
                    for (Container c : containers) {
                        ResourceInjectionBag singleBag = ribService.getResourceInjectionBag(c);
                        if (singleBag == null) continue;
                        if (this.currentRib == null) {
                            this.currentRib = singleBag;
                            continue;
                        }
                        this.currentRib.copyValues(singleBag);
                    }
                }
            }
        }
    }

    public void scan() {
        this.scan(null);
    }

    /*
     * WARNING - void declaration
     */
    public void scan(CDIMetaData cdiMetaData) {
        void var9_15;
        ArrayList<ContainerInfo> classContainers;
        if (tc.isDebugEnabled()) {
            ++this.alreadyCalled;
            if (this.alreadyCalled > 1) {
                Tr.debug((TraceComponent)tc, (String)("scanner service scan for this module has been called this many times: " + this.alreadyCalled), (Object[])new Object[0]);
            }
        }
        this.beanUrls = new HashSet<URL>();
        this.beanClasses = new HashMap();
        TreeSet<String> beanClassNames = new TreeSet<String>();
        ModuleInfo moduleInfo = null;
        CDIMetaData localCDIMetaData = cdiMetaData;
        if (cdiMetaData == null) {
            try {
                CDIMetaData myMetaData;
                NonPersistentCache cache = (NonPersistentCache)this.moduleContainer.adapt(NonPersistentCache.class);
                localCDIMetaData = myMetaData = (CDIMetaData)cache.getFromCache(CDIContextHolder.class);
                classContainers = new ArrayList<ContainerInfo>(myMetaData.getContainerInfos());
                moduleInfo = myMetaData.getModuleInfo();
            }
            catch (UnableToAdaptException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR - exiting out of scan", (Object[])new Object[0]);
                }
                return;
            }
        } else {
            classContainers = new ArrayList<ContainerInfo>(cdiMetaData.getContainerInfos());
            moduleInfo = cdiMetaData.getModuleInfo();
        }
        HashMap<URL, Set<String>> beansXmlUrlToClassNames = new HashMap<URL, Set<String>>();
        ClassLoader cl = moduleInfo == null ? WebBeansUtil.getCurrentClassLoader() : moduleInfo.getClassLoader();
        for (ContainerInfo containerInfo : classContainers) {
            ContainerInfo.Type type = containerInfo.getType();
            Container container = containerInfo.getContainer();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found a Class Container ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Class Container Name: " + containerInfo.getName()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Class Container Type: " + type), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Class Container Path: " + container.getPath()), (Object[])new Object[0]);
            }
            Entry beansXmlEntry = null;
            switch (type) {
                case WEB_MODULE: {
                    break;
                }
                case WEB_INF_CLASSES: {
                    beansXmlEntry = this.moduleContainer.getEntry(WEB_INF_BEANS_XML);
                    if (beansXmlEntry != null) break;
                    beansXmlEntry = container.getEntry(META_INF_BEANS_XML);
                    break;
                }
                default: {
                    beansXmlEntry = container.getEntry(META_INF_BEANS_XML);
                }
            }
            if (beansXmlEntry == null) {
                if (!tc.isDebugEnabled()) continue;
                if (type == ContainerInfo.Type.EJB_MODULE) {
                    Tr.debug((TraceComponent)tc, (String)"EJB case: Class Container is not a BDA", (Object[])new Object[0]);
                    continue;
                }
                if (type == ContainerInfo.Type.WEB_MODULE) continue;
                Tr.debug((TraceComponent)tc, (String)"Class Container is not a BDA", (Object[])new Object[0]);
                continue;
            }
            URL beansXmlUrl = beansXmlEntry.getResource();
            Set<String> classes = this.findAllClassesInContainer(container);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Class Container is a BDA!", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Class Container beans.xml: " + beansXmlUrl), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Classes In Container: " + classes), (Object[])new Object[0]);
            }
            beansXmlUrlToClassNames.put(beansXmlUrl, classes);
            this.beanUrls.add(beansXmlUrl);
            beanClassNames.addAll(classes);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("All class names in web modules' BDAs: " + beanClassNames), (Object[])new Object[0]);
        }
        ArrayList injectionClasses = new ArrayList();
        this.loadBeanClasses(cl, beanClassNames, injectionClasses);
        if (localCDIMetaData.isEjb()) {
            localCDIMetaData.setBeanClasses(injectionClasses);
        }
        this.bdaBeansXmlScanner = new DefaultBDABeansXmlScanner();
        for (Map.Entry entry : beansXmlUrlToClassNames.entrySet()) {
            URL beansXmlUrl = (URL)entry.getKey();
            String beansXmlFilePath = beansXmlUrl.toExternalForm();
            for (String className : (Set)entry.getValue()) {
                Class<?> clazz = this.beanClasses.get(className);
                this.bdaBeansXmlScanner.setBeansXml(clazz, beansXmlFilePath);
            }
        }
        boolean bl = false;
        if (moduleInfo != null) {
            ModuleMetaData mmd = ((ExtendedModuleInfo)moduleInfo).getMetaData();
            ResourceInjectionService resourceInjectionService = WebBeansFinder.getSingletonInstance(mmd).getService(ResourceInjectionService.class);
            if (resourceInjectionService instanceof ResourceInjectionServiceImpl) {
                ((ResourceInjectionServiceImpl)resourceInjectionService).initialize(mmd, injectionClasses, cl, this.currentRib);
                boolean bl2 = true;
            }
        } else {
            ResourceInjectionService resourceInjectionService = WebBeansFinder.getSingletonInstance().getService(ResourceInjectionService.class);
            if (resourceInjectionService instanceof ResourceInjectionServiceImpl) {
                ((ResourceInjectionServiceImpl)resourceInjectionService).initialize(injectionClasses, cl, this.currentRib);
                boolean bl3 = true;
            }
        }
        this.processEJBResourceRefs(localCDIMetaData, moduleInfo, cl, (boolean)var9_15);
    }

    public void processEJBResourceRefs(CDIMetaData cdiMetaData) {
        ModuleInfo moduleInfo = null;
        CDIMetaData localCDIMetaData = cdiMetaData;
        if (cdiMetaData == null) {
            try {
                CDIMetaData myMetaData;
                NonPersistentCache cache = (NonPersistentCache)this.moduleContainer.adapt(NonPersistentCache.class);
                localCDIMetaData = myMetaData = (CDIMetaData)cache.getFromCache(CDIContextHolder.class);
                moduleInfo = myMetaData.getModuleInfo();
            }
            catch (UnableToAdaptException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR - exiting out of processEJBResourceRefs", (Object[])new Object[0]);
                }
                return;
            }
        } else {
            moduleInfo = cdiMetaData.getModuleInfo();
        }
        ClassLoader cl = moduleInfo == null ? WebBeansUtil.getCurrentClassLoader() : moduleInfo.getClassLoader();
        this.processEJBResourceRefs(localCDIMetaData, moduleInfo, cl);
    }

    public void processEJBResourceRefs(CDIMetaData cdiMetaData, ModuleInfo moduleInfo, ClassLoader cl) {
        this.processEJBResourceRefs(cdiMetaData, moduleInfo, cl, false);
    }

    public void processEJBResourceRefs(CDIMetaData cdiMetaData, ModuleInfo moduleInfo, ClassLoader cl, boolean hasBeenPorcessed) {
        if (moduleInfo != null) {
            Container currentContainer = moduleInfo.getContainer();
            try {
                ManagedBeanBnd managedBeanBnd = (ManagedBeanBnd)currentContainer.adapt(ManagedBeanBnd.class);
                if (managedBeanBnd != null) {
                    ModuleMetaData mmd;
                    ResourceInjectionService ris;
                    String crossEjbModuleBindingsStr;
                    if (this.webBeansContext != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"WebBeansContext not null, try to get value of: com.ibm.ws.webbeans.crossEjbModuleBindings", (Object[])new Object[0]);
                        }
                        crossEjbModuleBindingsStr = this.webBeansContext.getSecurityService().doPrivilegedGetSystemProperty(CROSS_EJB_MODULE_BINDINGS, "false");
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"WebBeansContext is null, try to get value of: com.ibm.ws.webbeans.crossEjbModuleBindings", (Object[])new Object[0]);
                        }
                        crossEjbModuleBindingsStr = WebBeansContext.currentInstance().getSecurityService().doPrivilegedGetSystemProperty(CROSS_EJB_MODULE_BINDINGS, "false");
                    }
                    boolean isCrossEjbModuleBindings = Boolean.valueOf(crossEjbModuleBindingsStr);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("isCrossEjbModuleBindings is set to: " + isCrossEjbModuleBindings), (Object[])new Object[0]);
                    }
                    ResourceInjectionBag allBindings = new ResourceInjectionBag();
                    List mbs = managedBeanBnd.getManagedBeans();
                    if (mbs != null) {
                        for (ManagedBean mb : mbs) {
                            ResourceInjectionBag bindings = new ResourceInjectionBag();
                            HashMap<String, String> ejbRefBndMap = new HashMap<String, String>();
                            RefBndAndExtHelper.configureEJBRefBindings((RefBindingsGroup)mb, ejbRefBndMap);
                            HashMap<String, String> envEntryValues = new HashMap<String, String>();
                            HashMap<String, String> envEntryBindings = new HashMap<String, String>();
                            RefBndAndExtHelper.configureEnvEntryBindings((RefBindingsGroup)mb, envEntryValues, envEntryBindings);
                            HashMap<String, String> msgDestValues = new HashMap<String, String>();
                            RefBndAndExtHelper.configureMessageDestinationRefBindings((RefBindingsGroup)mb, msgDestValues);
                            HashMap<String, String> resourceEnvRefBindings = new HashMap<String, String>();
                            RefBndAndExtHelper.configureResourceEnvRefBindings((RefBindingsGroup)mb, resourceEnvRefBindings);
                            HashMap<String, String> resourceRefBindings = new HashMap<String, String>();
                            ResourceRefConfigList resourceRefConfigList = this.createResourceRefConfigList(cdiMetaData.getResourceRefFactory());
                            RefBndAndExtHelper.configureResourceRefBindings((RefBindingsGroup)mb, resourceRefBindings, (ResourceRefConfigList)resourceRefConfigList);
                            if (isCrossEjbModuleBindings) {
                                ArrayList<String> classesScanned = new ArrayList<String>();
                                classesScanned.add(mb.getClazz());
                                bindings.classesScanned = classesScanned;
                            }
                            bindings.ejbRefBindings = ejbRefBndMap;
                            bindings.envEntryBindings = envEntryBindings;
                            bindings.envEntryValues = envEntryValues;
                            bindings.msgDestRefBindings = msgDestValues;
                            bindings.resourceEnvRefBindings = resourceEnvRefBindings;
                            bindings.resourceRefBindings = resourceRefBindings;
                            bindings.resourceRefConfigList = resourceRefConfigList;
                            allBindings.copyValues(bindings);
                        }
                    }
                    if (isCrossEjbModuleBindings) {
                        allBindings.webBeansContext = this.webBeansContext;
                    }
                    if ((ris = WebBeansFinder.getSingletonInstance(mmd = ((ExtendedModuleInfo)moduleInfo).getMetaData()).getService(ResourceInjectionService.class)) instanceof ResourceInjectionServiceImpl && !hasBeenPorcessed) {
                        List<Class<?>> injectionClasses = cdiMetaData.getBeanClasses();
                        ((ResourceInjectionServiceImpl)ris).initialize(mmd, injectionClasses, cl, allBindings);
                        if (isCrossEjbModuleBindings) {
                            for (Class<?> injectionClass : injectionClasses) {
                                ((ResourceInjectionServiceImpl)ris).addToClassToModuleWithBindings(injectionClass, mmd.getJ2EEName());
                            }
                        }
                    }
                }
            }
            catch (UnableToAdaptException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR - exiting out of scan", (Object[])new Object[0]);
                }
                return;
            }
        }
    }

    public ResourceRefConfigList createResourceRefConfigList(ResourceRefConfigFactory factory) {
        if (factory == null) {
            return null;
        }
        return factory.createResourceRefConfigList();
    }

    private <T> T adapt(Adaptable adaptable, Class<T> adaptTarget) {
        try {
            return (T)adaptable.adapt(adaptTarget);
        }
        catch (Throwable thrown) {
            return null;
        }
    }

    private void loadBeanClasses(ClassLoader cl, Set<String> beanClassNames, List<Class<?>> injectionClasses) {
        if (beanClassNames != null) {
            this.beanClasses = new HashMap();
            for (String className : beanClassNames) {
                try {
                    Class<?> clazz = cl.loadClass(className);
                    injectionClasses.add(clazz);
                    this.beanClasses.put(className, clazz);
                }
                catch (ClassNotFoundException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Skipping additional class which can't be loaded", (Object[])new Object[]{className, cl});
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".loadBeanClasses"), (String)"553", (Object)this);
                }
            }
        }
    }

    private Set<String> findAllClassesInContainer(Container c) {
        TreeSet<String> classNames = new TreeSet<String>();
        this.findAllClassesInContainer(c, null, classNames);
        return classNames;
    }

    private void findAllClassesInContainer(Container container, String packageName, Set<String> classNames) {
        String entryPath = null;
        for (Entry entry : container) {
            String entryName = entry.getName();
            entryPath = packageName == null ? entryName : packageName + DOT + entryName;
            if (entryPath.endsWith(CLASS_EXT)) {
                int classNameLength = entryPath.length() - 6;
                String className = entryPath.substring(0, classNameLength);
                classNames.add(className);
                continue;
            }
            Container entryContainer = this.adapt((Adaptable)entry, Container.class);
            if (entryContainer == null) continue;
            this.findAllClassesInContainer(entryContainer, entryPath, classNames);
        }
    }
}

