/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.impl.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;

public class CdiContainer {
    private static final TraceComponent tc = Tr.register(CdiContainer.class);
    private static final AtomicReference<CdiContainer> INSTANCE = new AtomicReference();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public static CdiContainer getActiveInstance() {
        return INSTANCE.get();
    }

    protected void activate(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        INSTANCE.set(this);
        this.updateConfiguration(properties);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this), (Object[])new Object[0]);
        }
        INSTANCE.compareAndSet(this, null);
    }

    protected void modified(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Modifying " + this), (Object[])new Object[0]);
        }
        this.updateConfiguration(properties);
    }

    protected void updateConfiguration(Map<String, Object> properties) {
        if (properties != null) {
            this.properties.clear();
            this.properties.putAll(properties);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current Properties: " + this.properties), (Object[])new Object[0]);
        }
    }
}

