/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.impl.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webbeans.impl.service.SecurityContextStore;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Properties;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.spi.SecurityService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="com.ibm.ws.cdi.impl.DefaultSecurityService", property={"service.vendor=IBM", "service.ranking:Integer=50"})
public class DefaultSecurityService
implements SecurityService {
    private static final TraceComponent tc = Tr.register(DefaultSecurityService.class);
    private final ConcurrentServiceReferenceSet<SecurityContextStore> securityContextStores = new ConcurrentServiceReferenceSet("securityContextStore");
    private static final int METHOD_CLASS_GETDECLAREDCONSTRUCTOR = 1;
    private static final int METHOD_CLASS_GETDECLAREDCONSTRUCTORS = 2;
    private static final int METHOD_CLASS_GETDECLAREDMETHOD = 3;
    private static final int METHOD_CLASS_GETDECLAREDMETHODS = 4;
    private static final int METHOD_CLASS_GETDECLAREDFIELD = 5;
    private static final int METHOD_CLASS_GETDECLAREDFIELDS = 6;
    private static final PrivilegedActionGetSystemProperties SYSTEM_PROPERTY_ACTION = new PrivilegedActionGetSystemProperties();

    protected void activate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.securityContextStores.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.securityContextStores.deactivate(compcontext);
    }

    @Reference(name="securityContextStore", service=SecurityContextStore.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE)
    protected void setSecurityContextStore(ServiceReference<SecurityContextStore> ref) {
        this.securityContextStores.addReference(ref);
    }

    protected void unsetSecurityContextStore(ServiceReference<SecurityContextStore> ref) {
        this.securityContextStores.removeReference(ref);
    }

    public Principal getCurrentPrincipal() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCurrentPrincipal", (Object[])new Object[0]);
        }
        Principal principal = null;
        Iterator contextStores = this.securityContextStores.getServices();
        while (contextStores.hasNext() && principal == null) {
            SecurityContextStore securityContextStore = (SecurityContextStore)contextStores.next();
            if (securityContextStore == null) continue;
            principal = securityContextStore.getCurrentPrincipal();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Principal from " + securityContextStore + ": " + principal), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCurrentPrincipal", principal);
        }
        return principal;
    }

    public <T> Constructor<T> doPrivilegedGetDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, parameterTypes, 1));
        if (obj instanceof NoSuchMethodException) {
            return null;
        }
        return (Constructor)obj;
    }

    public <T> Constructor<?>[] doPrivilegedGetDeclaredConstructors(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 2));
        return (Constructor[])obj;
    }

    public <T> Method doPrivilegedGetDeclaredMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, new Object[]{name, parameterTypes}, 3));
        if (obj instanceof NoSuchMethodException) {
            return null;
        }
        return (Method)obj;
    }

    public <T> Method[] doPrivilegedGetDeclaredMethods(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 4));
        return (Method[])obj;
    }

    public <T> Field doPrivilegedGetDeclaredField(Class<T> clazz, String name) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, name, 5));
        if (obj instanceof NoSuchFieldException) {
            return null;
        }
        return (Field)obj;
    }

    public <T> Field[] doPrivilegedGetDeclaredFields(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 6));
        return (Field[])obj;
    }

    public void doPrivilegedSetAccessible(AccessibleObject obj, boolean flag) {
        AccessController.doPrivileged(new PrivilegedActionForSetAccessible(obj, flag));
    }

    public boolean doPrivilegedIsAccessible(AccessibleObject obj) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedActionForIsAccessible(obj));
    }

    public <T> T doPrivilegedObjectCreate(Class<T> clazz) throws PrivilegedActionException, IllegalAccessException, InstantiationException {
        return (T)AccessController.doPrivileged(new PrivilegedActionForObjectCreation(clazz));
    }

    public void doPrivilegedSetSystemProperty(String propertyName, String value) {
        AccessController.doPrivileged(new PrivilegedActionForSetProperty(propertyName, value));
    }

    public String doPrivilegedGetSystemProperty(String propertyName, String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedActionForProperty(propertyName, defaultValue));
    }

    public Properties doPrivilegedGetSystemProperties() {
        return AccessController.doPrivileged(SYSTEM_PROPERTY_ACTION);
    }

    protected static class PrivilegedActionForObjectCreation
    implements PrivilegedExceptionAction<Object> {
        private final Class<?> clazz;

        protected PrivilegedActionForObjectCreation(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Object run() throws Exception {
            try {
                return this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
        }
    }

    protected static class PrivilegedActionGetSystemProperties
    implements PrivilegedAction<Properties> {
        protected PrivilegedActionGetSystemProperties() {
        }

        @Override
        public Properties run() {
            return System.getProperties();
        }
    }

    protected static class PrivilegedActionForSetProperty
    implements PrivilegedAction<Object> {
        private final String propertyName;
        private final String value;

        protected PrivilegedActionForSetProperty(String propertyName, String value) {
            this.propertyName = propertyName;
            this.value = value;
        }

        @Override
        public String run() {
            System.setProperty(this.propertyName, this.value);
            return null;
        }
    }

    protected static class PrivilegedActionForProperty
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        protected PrivilegedActionForProperty(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }

    protected static class PrivilegedActionForIsAccessible
    implements PrivilegedAction<Object> {
        private final AccessibleObject object;

        protected PrivilegedActionForIsAccessible(AccessibleObject object) {
            this.object = object;
        }

        @Override
        public Object run() {
            return this.object.isAccessible();
        }
    }

    protected static class PrivilegedActionForSetAccessible
    implements PrivilegedAction<Object> {
        private final AccessibleObject object;
        private final boolean flag;

        protected PrivilegedActionForSetAccessible(AccessibleObject object, boolean flag) {
            this.object = object;
            this.flag = flag;
        }

        @Override
        public Object run() {
            this.object.setAccessible(this.flag);
            return null;
        }
    }

    protected static class PrivilegedActionForClass
    implements PrivilegedAction<Object> {
        private final Class<?> clazz;
        private final Object parameters;
        private final int method;

        protected PrivilegedActionForClass(Class<?> clazz, Object parameters, int method) {
            this.clazz = clazz;
            this.parameters = parameters;
            this.method = method;
        }

        @Override
        public Object run() {
            try {
                switch (this.method) {
                    case 1: {
                        return this.clazz.getDeclaredConstructor((Class[])this.parameters);
                    }
                    case 2: {
                        return this.clazz.getDeclaredConstructors();
                    }
                    case 3: {
                        String name = (String)((Object[])this.parameters)[0];
                        Class[] realParameters = (Class[])((Object[])this.parameters)[1];
                        return this.clazz.getDeclaredMethod(name, realParameters);
                    }
                    case 4: {
                        return this.clazz.getDeclaredMethods();
                    }
                    case 5: {
                        return this.clazz.getDeclaredField((String)this.parameters);
                    }
                    case 6: {
                        return this.clazz.getDeclaredFields();
                    }
                }
                return new WebBeansException("unknown security method: " + this.method);
            }
            catch (Exception exception) {
                return exception;
            }
        }
    }
}

