/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.impl.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.ws.webbeans.impl.service.LibertyLoaderService;
import com.ibm.ws.webbeans.impl.service.LoaderFactoryService;
import com.ibm.ws.webbeans.impl.service.OpenWebBeansPluginFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class LibertyLoaderFactoryService
implements LoaderFactoryService {
    private static final TraceComponent TC = Tr.register(LibertyLoaderFactoryService.class);
    private final ConcurrentServiceReferenceSet<OpenWebBeansPlugin> owbPlugins = new ConcurrentServiceReferenceSet("owbPlugin");
    private final ConcurrentServiceReferenceSet<OpenWebBeansPluginFactory> owbPluginFactories = new ConcurrentServiceReferenceSet("owbPluginFactory");

    public void activate(ComponentContext compcontext) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.owbPlugins.activate(compcontext);
        this.owbPluginFactories.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.owbPlugins.deactivate(compcontext);
        this.owbPluginFactories.deactivate(compcontext);
    }

    protected void setOwbPlugin(ServiceReference<OpenWebBeansPlugin> ref) {
        this.owbPlugins.addReference(ref);
    }

    protected void unsetOwbPlugin(ServiceReference<OpenWebBeansPlugin> ref) {
        this.owbPlugins.removeReference(ref);
    }

    protected void setOwbPluginFactory(ServiceReference<OpenWebBeansPluginFactory> ref) {
        this.owbPluginFactories.addReference(ref);
    }

    protected void unsetOwbPluginFactory(ServiceReference<OpenWebBeansPluginFactory> ref) {
        this.owbPluginFactories.removeReference(ref);
    }

    @Override
    public LibertyLoaderService createLibertyLoaderService(List<Container> containers, CDIMetaData cdiMD, CDIMetaData cdiAppMD) {
        Iterator pluginFactories;
        ArrayList<OpenWebBeansPlugin> allPlugins = new ArrayList<OpenWebBeansPlugin>();
        Iterator plugins = this.owbPlugins.getServices();
        if (plugins != null) {
            while (plugins.hasNext()) {
                OpenWebBeansPlugin plugin = (OpenWebBeansPlugin)plugins.next();
                allPlugins.add(plugin);
            }
        }
        if ((pluginFactories = this.owbPluginFactories.getServices()) != null) {
            while (pluginFactories.hasNext()) {
                OpenWebBeansPluginFactory pluginFactory = (OpenWebBeansPluginFactory)pluginFactories.next();
                allPlugins.add(pluginFactory.createFactory(containers, cdiMD, cdiAppMD));
            }
        }
        LibertyLoaderService lls = new LibertyLoaderService(allPlugins);
        return lls;
    }
}

