/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.impl.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.ArrayList;
import java.util.List;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;

public class LibertyLoaderService
extends DefaultLoaderService {
    private static final TraceComponent TC = Tr.register(LibertyLoaderService.class);
    private final List<OpenWebBeansPlugin> plugins;

    public LibertyLoaderService(List<OpenWebBeansPlugin> plugins) {
        this.plugins = plugins;
    }

    @Override
    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("loading " + serviceType + " from " + classLoader), (Object[])new Object[0]);
        }
        ArrayList<Object> results = new ArrayList<Object>();
        if (OpenWebBeansPlugin.class.equals(serviceType) && this.plugins != null) {
            for (OpenWebBeansPlugin plugin : this.plugins) {
                results.add(plugin);
            }
        }
        results.addAll(super.load(serviceType, classLoader));
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("loaded " + results.size() + " results for " + serviceType + ": " + results), (Object[])new Object[0]);
        }
        return results;
    }
}

