/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.impl.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.ws.webbeans.impl.providers.OpenWebBeansPropertyProvider;
import com.ibm.ws.webbeans.impl.scanner.LibertyScannerService;
import com.ibm.ws.webbeans.impl.scanner.ResourceInjectionBagService;
import com.ibm.ws.webbeans.impl.service.CDISlotAccessor;
import com.ibm.ws.webbeans.impl.service.LoaderFactoryService;
import com.ibm.ws.webbeans.services.CDIComponentImpl;
import com.ibm.wsspi.adaptable.module.Adaptable;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.context.LibertyContextsService;
import org.apache.webbeans.corespi.DefaultSingletonService;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.util.Asserts;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class LibertySingletonService
extends DefaultSingletonService
implements SingletonService<WebBeansContext> {
    private static final TraceComponent tc = Tr.register(LibertySingletonService.class);
    private final ConcurrentServiceReferenceSet<OpenWebBeansPropertyProvider> owbPropertyProviders;
    private final ConcurrentServiceReferenceSet<SecurityService> securityServices;
    private final AtomicServiceReference<LoaderFactoryService> loaderFactoryService;
    private final AtomicServiceReference<CDISlotAccessor> cdiSlotService;
    private final AtomicServiceReference<ResourceInjectionService> resourceInjectionService;
    private static final AtomicServiceReference<SerializationService> serializationService = new AtomicServiceReference("serializationService");
    protected final Map<ClassLoader, WebBeansContext> singletonMap;
    protected final Map<Object, WeakReference<ClassLoader>> objectToClassLoaderMap;
    protected Properties defaultProperties;
    private final ConcurrentServiceReferenceSet<ResourceInjectionBagService> resourceInjectionBagService;

    public LibertySingletonService() {
        block2: {
            this.owbPropertyProviders = new ConcurrentServiceReferenceSet("owbPropertyProvider");
            this.securityServices = new ConcurrentServiceReferenceSet("securityService");
            this.loaderFactoryService = new AtomicServiceReference("loaderFactoryService");
            this.cdiSlotService = new AtomicServiceReference("cdiSlotService");
            this.resourceInjectionService = new AtomicServiceReference("resourceInjectionService");
            this.singletonMap = new WeakHashMap<ClassLoader, WebBeansContext>();
            this.objectToClassLoaderMap = new IdentityHashMap<Object, WeakReference<ClassLoader>>();
            this.defaultProperties = new Properties();
            this.resourceInjectionBagService = new ConcurrentServiceReferenceSet("resourceInjectionBagService");
            URL defaultFile = this.getClass().getClassLoader().getResource("META-INF/openwebbeans/openwebbeans.properties");
            try {
                this.defaultProperties.load(defaultFile.openConnection().getInputStream());
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"unable to load default openwebbeans.properties from inside of the bundle", (Object[])new Object[0]);
            }
        }
    }

    protected void activate(ComponentContext compcontext) {
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
            }
            this.owbPropertyProviders.activate(compcontext);
            this.securityServices.activate(compcontext);
            this.loaderFactoryService.activate(compcontext);
            this.cdiSlotService.activate(compcontext);
            this.resourceInjectionService.activate(compcontext);
            this.resourceInjectionBagService.activate(compcontext);
            serializationService.activate(compcontext);
            try {
                WebBeansFinder.setSingletonService(this);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("unable to reset SingletonService: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.owbPropertyProviders.deactivate(compcontext);
        this.securityServices.deactivate(compcontext);
        this.loaderFactoryService.deactivate(compcontext);
        this.cdiSlotService.deactivate(compcontext);
        this.resourceInjectionService.deactivate(compcontext);
        this.resourceInjectionBagService.deactivate(compcontext);
        serializationService.deactivate(compcontext);
    }

    protected void setOwbPropertyProvider(ServiceReference<OpenWebBeansPropertyProvider> ref) {
        this.owbPropertyProviders.addReference(ref);
    }

    protected void unsetOwbPropertyProvider(ServiceReference<OpenWebBeansPropertyProvider> ref) {
        this.owbPropertyProviders.removeReference(ref);
    }

    public void setResourceInjectionBagService(ServiceReference<ResourceInjectionBagService> ref) {
        this.resourceInjectionBagService.addReference(ref);
    }

    public void unsetResourceInjectionBagService(ServiceReference<ResourceInjectionBagService> ref) {
        this.resourceInjectionBagService.removeReference(ref);
    }

    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServices.addReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServices.removeReference(ref);
    }

    protected void setLoaderFactoryService(ServiceReference<LoaderFactoryService> ref) {
        this.loaderFactoryService.setReference(ref);
    }

    protected void unsetLoaderFactoryService(ServiceReference<LoaderFactoryService> ref) {
        this.loaderFactoryService.unsetReference(ref);
    }

    protected void setCdiSlotService(ServiceReference<CDISlotAccessor> ref) {
        this.cdiSlotService.setReference(ref);
    }

    protected void unsetCdiSlotService(ServiceReference<CDISlotAccessor> ref) {
        this.cdiSlotService.unsetReference(ref);
    }

    protected void setResourceInjectionService(ServiceReference<ResourceInjectionService> ref) {
        this.resourceInjectionService.setReference(ref);
    }

    protected void unsetResourceInjectionService(ServiceReference<ResourceInjectionService> ref) {
        this.resourceInjectionService.unsetReference(ref);
    }

    protected void setSerializationService(ServiceReference<SerializationService> ref) {
        serializationService.setReference(ref);
    }

    protected void unsetSerializationService(ServiceReference<SerializationService> ref) {
        serializationService.unsetReference(ref);
    }

    public static SerializationService getSerializationService() {
        return (SerializationService)serializationService.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebBeansContext get(Object key) {
        ModuleMetaData mmd = null;
        if (key != null && key instanceof ModuleMetaData) {
            mmd = (ModuleMetaData)key;
        } else {
            ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            ComponentMetaData cmd = cmdai.getComponentMetaData();
            if (cmd != null) {
                mmd = cmd.getModuleMetaData();
            }
        }
        CDIMetaData cdiMMD = null;
        if (mmd != null) {
            cdiMMD = (CDIMetaData)mmd.getMetaData(((CDISlotAccessor)this.cdiSlotService.getService()).getSlotObject());
        }
        if (cdiMMD == null) {
            cdiMMD = CDIComponentImpl.cdiMetaDataThreadLocal.get();
        }
        if (cdiMMD == null) {
            return null;
        }
        WebBeansContext webBeansContext = cdiMMD.getWebBeansContext();
        if (webBeansContext != null) {
            return webBeansContext;
        }
        CDIMetaData cDIMetaData = cdiMMD;
        synchronized (cDIMetaData) {
            webBeansContext = cdiMMD.getWebBeansContext();
            if (webBeansContext == null) {
                ScannerService ss;
                String ejbLifeCycleClass;
                WebBeansContextBuilder builder = new WebBeansContextBuilder();
                Iterator propertyProviders = this.owbPropertyProviders.getServices();
                while (propertyProviders.hasNext()) {
                    builder.mergeProperties((OpenWebBeansPropertyProvider)propertyProviders.next());
                }
                ArrayList<Container> resourceInjectionContainers = null;
                if (cdiMMD.isEjb() && (ejbLifeCycleClass = builder.owbConfig.getProperty("org.apache.webbeans.ejb.lifecycle.EjbLifecycle")) != null) {
                    Properties p = new Properties();
                    p.put("org.apache.webbeans.spi.ContainerLifecycle", ejbLifeCycleClass);
                    builder.overrideProperties(p);
                }
                builder.mergeProperties(this.defaultProperties);
                ArrayList<Container> containersToLoad = new ArrayList<Container>();
                Set<ContainerInfo> containerInfos = cdiMMD.getContainerInfos();
                if (containerInfos != null) {
                    for (ContainerInfo ci : containerInfos) {
                        containersToLoad.add(ci.getContainer());
                        if (ci.getType() != ContainerInfo.Type.WEB_MODULE) continue;
                        if (resourceInjectionContainers == null) {
                            resourceInjectionContainers = new ArrayList<Container>();
                        }
                        resourceInjectionContainers.add(ci.getContainer());
                    }
                }
                CDIMetaData cdiAppMD = (CDIMetaData)mmd.getApplicationMetaData().getMetaData(((CDISlotAccessor)this.cdiSlotService.getService()).getApplicationSlotObject());
                builder.addService(LoaderService.class, ((LoaderFactoryService)this.loaderFactoryService.getService()).createLibertyLoaderService(containersToLoad, cdiMMD, cdiAppMD));
                builder.addService(ResourceInjectionService.class, this.resourceInjectionService);
                builder.addService(SecurityService.class, this.securityServices);
                LibertyContextsService contextsService = cdiAppMD.getContextsService();
                builder.addService(ContextsService.class, contextsService);
                webBeansContext = builder.build();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created WebBeansContext - " + webBeansContext), (Object[])new Object[0]);
                }
                if ((ss = webBeansContext.getScannerService()) != null && ss instanceof LibertyScannerService) {
                    LibertyScannerService lss = (LibertyScannerService)ss;
                    lss.setWebBeansContext(webBeansContext);
                    lss.setResourceInjectionBagServices(this.resourceInjectionBagService.getServices(), resourceInjectionContainers);
                }
                cdiMMD.setWebBeansContext(webBeansContext);
            }
        }
        return webBeansContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInstances(ClassLoader classLoader) {
        Asserts.assertNotNull(classLoader, "classloader is null");
        Map<ClassLoader, WebBeansContext> map = this.singletonMap;
        synchronized (map) {
            this.singletonMap.remove(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getSingletonClassLoader(Object object) {
        Asserts.assertNotNull(object, "object is null");
        Map<Object, WeakReference<ClassLoader>> map = this.objectToClassLoaderMap;
        synchronized (map) {
            WeakReference<ClassLoader> current;
            if (this.objectToClassLoaderMap.containsKey(object) && (current = this.objectToClassLoaderMap.get(object)) != null) {
                return (ClassLoader)current.get();
            }
        }
        return null;
    }

    private <T> T adapt(Adaptable adaptable, Class<T> adaptTarget) {
        try {
            return (T)adaptable.adapt(adaptTarget);
        }
        catch (Throwable thrown) {
            return null;
        }
    }

    private static class WebBeansContextBuilder {
        private final OpenWebBeansConfiguration owbConfig = new OpenWebBeansConfiguration();
        private final Map<Class<?>, Object> services = new HashMap();

        public WebBeansContextBuilder() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Initializing " + this.owbConfig), (Object[])new Object[0]);
            }
        }

        public void overrideProperties(Properties properties) {
            if (properties == null) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Overriding " + properties.size() + " configuration properties ... "), (Object[])new Object[0]);
            }
            for (String key : properties.stringPropertyNames()) {
                String oldValue = this.owbConfig.getProperty(key);
                String value = properties.getProperty(key);
                if (oldValue == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Setting OWB configuration property: " + key + "=" + value), (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Current OWB configuration property: " + key + "=" + oldValue + " (overriding with value=" + value + ")"), (Object[])new Object[0]);
                }
                this.owbConfig.setProperty(key, value);
            }
        }

        public void mergeProperties(Properties properties) {
            if (properties == null) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Merging " + properties.size() + " configuration properties ... "), (Object[])new Object[0]);
            }
            for (String key : properties.stringPropertyNames()) {
                String value = this.owbConfig.getProperty(key);
                if (value == null) {
                    value = properties.getProperty(key);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Setting OWB configuration property: " + key + "=" + value), (Object[])new Object[0]);
                    }
                    this.owbConfig.setProperty(key, value);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Current OWB configuration property: " + key + "=" + value + " (ignoring value=" + properties.getProperty(key) + ")"), (Object[])new Object[0]);
            }
        }

        public void mergeProperties(OpenWebBeansPropertyProvider provider) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Merging OWB configuration properties from " + provider.getClass().getName()), (Object[])new Object[0]);
            }
            this.mergeProperties(provider.getProperties());
        }

        public <T> void addService(Class<T> type, ConcurrentServiceReferenceSet<T> references) {
            if (this.canAddService(type)) {
                Iterator instances = references.getServices();
                if (instances.hasNext()) {
                    this.addService(type, instances.next());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No instances of " + type.getName() + " are currently not available through DS."), (Object[])new Object[0]);
                }
            }
        }

        public <T> void addService(Class<T> type, AtomicServiceReference<T> reference) {
            if (this.canAddService(type)) {
                this.addService(type, reference.getService());
            }
        }

        private <T> boolean canAddService(Class<T> type) {
            String name = type.getName();
            String value = this.owbConfig.getProperty(name);
            if (value == null) {
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An instance of " + name + " will be managed by OWB instead of DS: " + value), (Object[])new Object[0]);
            }
            return false;
        }

        private <T> void addService(Class<T> type, T instance) {
            if (instance == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("An instance of " + type.getName() + " is currently not available through DS."), (Object[])new Object[0]);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An instance of " + type.getName() + " will be managed by DS instead of OWB: " + instance), (Object[])new Object[0]);
            }
            this.services.put(type, instance);
        }

        public WebBeansContext build() {
            return new WebBeansContext(this.services, this.owbConfig);
        }
    }
}

