/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.services;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webbeans.services.CDIService;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class BeanManagerObjectFactoryInfo
extends ObjectFactoryInfo
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(BeanManagerObjectFactoryInfo.class);
    private final AtomicServiceReference<CDIService> cdiServiceRef = new AtomicServiceReference("cdiService");

    public Class<? extends Annotation> getAnnotationClass() {
        return Resource.class;
    }

    public Class<?> getType() {
        return BeanManager.class;
    }

    public boolean isOverrideAllowed() {
        return false;
    }

    public Class<? extends ObjectFactory> getObjectFactoryClass() {
        return BeanManagerObjectFactoryInfo.class;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance : " + Util.identity((Object)obj)), (Object[])new Object[0]);
        }
        BeanManager bm = null;
        if (obj instanceof Reference && this.getClass().getName().equals(((Reference)obj).getFactoryClassName())) {
            CDIService cdiService = this.getCdiService();
            if (cdiService == null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The CDIService is not available. The server cannot locate the CDI BeanManager until the CDIService has started.", (Object[])new Object[0]);
                }
            } else {
                bm = cdiService.getCurrentBeanManager();
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance: ", bm);
        }
        return bm;
    }

    public void activate(ComponentContext context) {
        this.cdiServiceRef.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.cdiServiceRef.deactivate(context);
    }

    protected void setCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.setReference(ref);
    }

    protected void unsetCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.unsetReference(ref);
    }

    private CDIService getCdiService() {
        return (CDIService)this.cdiServiceRef.getService();
    }
}

