/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.services;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.webbeans.services.CDIManagedObjectState;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import javax.enterprise.context.spi.CreationalContext;

public class CDIManagedObject<T>
implements ManagedObject<T> {
    private static final long serialVersionUID = 4530406277812949127L;
    private static final TraceComponent tc = Tr.register(CDIManagedObject.class);
    T _managedObject = null;
    CreationalContext<?> _cc = null;
    private String _beanScope = null;

    public CDIManagedObject(T o, CreationalContext<?> cc, String beanScope) {
        this._cc = cc;
        this._managedObject = o;
        this._beanScope = beanScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(Util.identity(this._managedObject) + " creating --> " + Util.identity(this._cc) + " beanScope: " + beanScope), (Object[])new Object[0]);
        }
    }

    public <R> R getContextData(Class<R> klass) {
        if (klass == CreationalContext.class) {
            return klass.cast(this._cc);
        }
        return null;
    }

    public T getObject() {
        return this._managedObject;
    }

    public ManagedObjectContext getContext() {
        return new CDIManagedObjectState(this._cc);
    }

    public void release() {
        if (null != this._cc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(Util.identity(this._managedObject) + " releasing --> " + Util.identity(this._cc)), (Object[])new Object[0]);
            }
            this._cc.release();
            this._cc = null;
            this._managedObject = null;
        }
    }

    public boolean isLifecycleManaged() {
        return false;
    }

    public String getBeanScope() {
        return this._beanScope;
    }

    public T inject(ReferenceContext referenceContext) throws ManagedObjectException {
        InjectionTarget[] targets = null;
        try {
            targets = referenceContext.getInjectionTargets(this._managedObject.getClass());
        }
        catch (InjectionException e) {
            throw new ManagedObjectException((Throwable)e);
        }
        InjectionTargetContext injectionContext = new InjectionTargetContext(){

            public <S> S getInjectionTargetContextData(Class<S> data) {
                return CDIManagedObject.this.getContextData(data);
            }
        };
        T object = this.inject(targets, injectionContext);
        return object;
    }

    public T inject(InjectionTarget[] targets, InjectionTargetContext injectionContext) throws ManagedObjectException {
        for (InjectionTarget injectionTarget : targets) {
            try {
                injectionTarget.inject(this._managedObject, injectionContext);
            }
            catch (InjectionException e) {
                throw new ManagedObjectException((Throwable)e);
            }
        }
        return this._managedObject;
    }
}

