/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.services;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.ws.webbeans.impl.service.CDISlotAccessor;
import com.ibm.ws.webbeans.services.CDIEJBBean;
import com.ibm.ws.webbeans.services.CDIEJBBeanAccessor;
import com.ibm.ws.webbeans.services.CDIManagedObject;
import com.ibm.ws.webbeans.services.CDIManagedObjectState;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.InjectableConstructor;

public class CDIManagedObjectFactoryImpl<T>
implements ManagedObjectFactory<T> {
    private static final TraceComponent tc = Tr.register(CDIManagedObjectFactoryImpl.class);
    private Class<T> _managedClass = null;
    private CDIEJBBeanAccessor _ejbAccessor = null;
    private BeanManager beanManager = null;
    private Constructor<T> _constructor;
    private List<InjectionPoint> _injectionPoints;
    private AbstractOwbBean<?> _abstractOwbBean;
    private Bean<T> bean;
    private boolean _beanLookupComplete = false;
    private final CDISlotAccessor _slotAccessor;
    private final ModuleMetaData _moduleMetaData;

    public CDIManagedObjectFactoryImpl(Class<T> classToManage, CDISlotAccessor slotAccessor, CDIEJBBeanAccessor ejbAccessor, ModuleMetaData moduleMetaData) {
        this._managedClass = classToManage;
        this._slotAccessor = slotAccessor;
        this._ejbAccessor = ejbAccessor;
        this._moduleMetaData = moduleMetaData;
    }

    public Class<T> getManagedObjectClass() {
        return this._managedClass;
    }

    public boolean isManaged() {
        return true;
    }

    private BeanManager getBeanManager() {
        if (this.beanManager != null) {
            return this.beanManager;
        }
        CDIMetaData myMetaData = (CDIMetaData)this._moduleMetaData.getMetaData(this._slotAccessor.getSlotObject());
        WebBeansContext context = myMetaData.getWebBeansContext();
        if (context != null) {
            this.beanManager = context.getBeanManagerImpl();
            return this.beanManager;
        }
        return null;
    }

    public ManagedObject<T> existingInstance(Object instance) {
        CDIManagedObject<Object> moi = null;
        BeanManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("existingInstance entered with: " + Util.identity((Object)instance)), (Object[])new Object[0]);
            }
            CreationalContext cc = beanManager.createCreationalContext(null);
            moi = new CDIManagedObject<Object>(instance, cc, this.getBeanScope());
        }
        return moi;
    }

    public ManagedObjectContext createContext() {
        BeanManager bm = this.getBeanManager();
        if (bm == null) {
            return null;
        }
        return new CDIManagedObjectState(bm.createCreationalContext(null));
    }

    private synchronized void initializeConstructor() {
        if (this._constructor == null) {
            CDIEJBBean cdiEjbBean;
            if (this._ejbAccessor != null && (cdiEjbBean = this._ejbAccessor.getCDIEJBBean(this._managedClass)) != null) {
                this._constructor = cdiEjbBean.getConstructor();
                this._abstractOwbBean = cdiEjbBean.getAbstractOwbBean();
                this._injectionPoints = this._abstractOwbBean.getInjectionPoint(this._constructor);
            } else {
                Set beans;
                BeanManager beanManager = this.getBeanManager();
                if (beanManager != null && (beans = beanManager.getBeans(this._managedClass, new Annotation[0])) != null && beans.size() > 0) {
                    for (Bean bean : beans) {
                        if (!bean.getBeanClass().equals(this._managedClass) || !(bean instanceof ManagedBean)) continue;
                        ManagedBean mbean = (ManagedBean)bean;
                        this._constructor = mbean.getConstructor();
                        this._injectionPoints = mbean.getInjectionPoint(this._constructor);
                        this._abstractOwbBean = mbean;
                        break;
                    }
                }
                if (this._constructor == null) {
                    try {
                        this._constructor = this._managedClass.getConstructor(new Class[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public Constructor<T> getConstructor() {
        this.initializeConstructor();
        return this._constructor;
    }

    private Object[] createArguments(CreationalContext<?> cc) {
        this.initializeConstructor();
        ArrayList<Object> list = new ArrayList<Object>();
        if (this._injectionPoints != null) {
            InjectableConstructor<T> ic = new InjectableConstructor<T>(this._constructor, this._abstractOwbBean, cc);
            List<InjectionPoint> injectedPoints = this._injectionPoints;
            block0: for (int i = 0; i < injectedPoints.size(); ++i) {
                for (InjectionPoint point : injectedPoints) {
                    AnnotatedParameter parameter = (AnnotatedParameter)point.getAnnotated();
                    if (parameter.getPosition() != i) continue;
                    list.add(ic.inject(point));
                    continue block0;
                }
            }
        }
        return list.toArray();
    }

    private ManagedObject<T> createManagedObject(CreationalContext<?> cc) throws ManagedObjectException {
        CDIManagedObject<Object> moi = null;
        Object[] arguments = this.createArguments(cc);
        Object instance = null;
        try {
            instance = this._constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new ManagedObjectException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createManagedObject : instance = " + Util.identity(instance)), (Object[])new Object[0]);
        }
        moi = new CDIManagedObject<Object>(instance, cc, this.getBeanScope());
        return moi;
    }

    public ManagedObject<T> createManagedObject() throws ManagedObjectException {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            CreationalContext cc = beanManager.createCreationalContext(null);
            return this.createManagedObject(cc);
        }
        throw new ManagedObjectException((Throwable)new IllegalStateException("BeanManager not available"));
    }

    public ManagedObject<T> createManagedObject(ManagedObjectInvocationContext<T> invocationContext) throws ManagedObjectException {
        ManagedObjectContext managedObjectContext = invocationContext.getManagedObjectContext();
        CreationalContext cc = (CreationalContext)managedObjectContext.getContextData(CreationalContext.class);
        if (cc != null) {
            return this.createManagedObject(cc);
        }
        throw new ManagedObjectException((Throwable)new IllegalStateException("CreationalContext not available"));
    }

    public ManagedObject<T> createManagedObject(T existingInstance, ManagedObjectInvocationContext<T> invocationContext) throws ManagedObjectException {
        CDIManagedObject<T> moi = null;
        BeanManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("existingInstance entered with: " + Util.identity(existingInstance)), (Object[])new Object[0]);
            }
            CreationalContext cc = null;
            if (invocationContext != null) {
                ManagedObjectContext managedObjectContext = invocationContext.getManagedObjectContext();
                cc = (CreationalContext)managedObjectContext.getContextData(CreationalContext.class);
            } else {
                cc = beanManager.createCreationalContext(null);
            }
            moi = new CDIManagedObject<T>(existingInstance, cc, this.getBeanScope());
        }
        return moi;
    }

    public boolean managesInjectionAndInterceptors() {
        return false;
    }

    private Bean<T> getBean() {
        if (!this._beanLookupComplete) {
            BeanManager beanManager = this.getBeanManager();
            if (beanManager != null) {
                Set beans = beanManager.getBeans(this._managedClass, new Annotation[0]);
                if (beans.size() == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("No Beans found for managed class: " + this.getManagedObjectClass()), (Object[])new Object[0]);
                    }
                } else {
                    this.bean = beanManager.resolve(beans);
                }
            }
            this._beanLookupComplete = true;
        }
        return this.bean;
    }

    public String getBeanScope() {
        Bean<T> bean = this.getBean();
        String beanScope = null;
        if (bean != null) {
            beanScope = bean.getScope().getCanonicalName();
        }
        return beanScope;
    }
}

