/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.services;

import com.ibm.ws.managedobject.DefaultManagedObjectService;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.ws.webbeans.impl.service.CDISlotAccessor;
import com.ibm.ws.webbeans.services.CDIEJBBeanAccessor;
import com.ibm.ws.webbeans.services.CDIManagedObjectFactoryImpl;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class CDIManagedObjectService
implements ManagedObjectService {
    private final AtomicServiceReference<CDIEJBBeanAccessor> cdiEJBAccessorRef = new AtomicServiceReference("cdiEjbAccessor");
    private final AtomicServiceReference<CDISlotAccessor> cdiSlotAccessorRef = new AtomicServiceReference("cdiSlotAccessor");
    private final AtomicServiceReference<DefaultManagedObjectService> defaultMOSRef = new AtomicServiceReference("defaultManagedObjectService");

    public void activate(ComponentContext context) {
        this.cdiEJBAccessorRef.activate(context);
        this.cdiSlotAccessorRef.activate(context);
        this.defaultMOSRef.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.cdiEJBAccessorRef.deactivate(context);
        this.cdiSlotAccessorRef.deactivate(context);
        this.defaultMOSRef.deactivate(context);
    }

    protected void setCdiEjbAccessor(ServiceReference<CDIEJBBeanAccessor> ref) {
        this.cdiEJBAccessorRef.setReference(ref);
    }

    protected void unsetCdiEjbAccessor(ServiceReference<CDIEJBBeanAccessor> ref) {
        this.cdiEJBAccessorRef.unsetReference(ref);
    }

    protected void setCdiSlotAccessor(ServiceReference<CDISlotAccessor> ref) {
        this.cdiSlotAccessorRef.setReference(ref);
    }

    protected void unsetCdiSlotAccessor(ServiceReference<CDISlotAccessor> ref) {
        this.cdiSlotAccessorRef.unsetReference(ref);
    }

    protected void setDefaultManagedObjectService(ServiceReference<DefaultManagedObjectService> ref) {
        this.defaultMOSRef.setReference(ref);
    }

    protected void unsetDefaultManagedObjectService(ServiceReference<DefaultManagedObjectService> ref) {
        this.defaultMOSRef.unsetReference(ref);
    }

    public <T> ManagedObjectFactory<T> createManagedObjectFactory(ModuleMetaData mmd, Class<T> klass, boolean requestManagingInjectionAndInterceptors) throws ManagedObjectException {
        CDIManagedObjectFactoryImpl<T> managedObjectFactory = null;
        managedObjectFactory = this.isCDIEnabled(mmd) ? new CDIManagedObjectFactoryImpl<T>(klass, (CDISlotAccessor)this.cdiSlotAccessorRef.getService(), (CDIEJBBeanAccessor)this.cdiEJBAccessorRef.getService(), mmd) : ((DefaultManagedObjectService)this.defaultMOSRef.getServiceWithException()).createManagedObjectFactory(mmd, klass, requestManagingInjectionAndInterceptors);
        return managedObjectFactory;
    }

    public <T> ManagedObjectFactory<T> createManagedObjectFactory(ModuleMetaData mmd, Class<T> klass, boolean requestManagingInjectionAndInterceptors, ReferenceContext referenceContext) throws ManagedObjectException {
        return this.createManagedObjectFactory(mmd, klass, requestManagingInjectionAndInterceptors);
    }

    public <T> ManagedObjectFactory<T> createEJBManagedObjectFactory(ModuleMetaData mmd, Class<T> klass, String ejbName) throws ManagedObjectException {
        return this.createManagedObjectFactory(mmd, klass, false);
    }

    public <T> ManagedObjectFactory<T> createInterceptorManagedObjectFactory(ModuleMetaData mmd, Class<T> klass) throws ManagedObjectException {
        return this.createManagedObjectFactory(mmd, klass, false);
    }

    public <T> ManagedObject<T> createManagedObject(ModuleMetaData mmd, T instance) throws ManagedObjectException {
        throw new UnsupportedOperationException();
    }

    private boolean isCDIEnabled(ModuleMetaData moduleMetaData) {
        CDISlotAccessor slotAccessor = (CDISlotAccessor)this.cdiSlotAccessorRef.getService();
        MetaDataSlot slot = slotAccessor.getSlotObject();
        CDIMetaData cdiMetaData = (CDIMetaData)moduleMetaData.getMetaData(slot);
        boolean isCDIEnabled = false;
        if (cdiMetaData != null) {
            isCDIEnabled = cdiMetaData.isCDIEnabled();
        }
        return isCDIEnabled;
    }
}

