/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.services;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webbeans.services.InjectInjectionObjectFactory;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionSimpleBinding;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Inject;

public class InjectInjectionBinding
extends InjectionSimpleBinding<Inject> {
    private static final TraceComponent tc = Tr.register(InjectInjectionBinding.class);
    private static final boolean ignoreInjectionFailure = InjectInjectionBinding.ignoreInjectionFailure();

    private static boolean ignoreInjectionFailure() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(System.getProperty("com.ibm.ws.cdi.ignoreInjectionFailure"));
            }
        });
    }

    public InjectInjectionBinding(Inject annotation, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super((Annotation)annotation, nameSpaceConfig);
    }

    public J2EEName getJ2EEName() {
        return this.ivJ2eeName;
    }

    public boolean isResolved() {
        return true;
    }

    public Object getInjectionObjectInstance(Object targetObject, InjectionTargetContext targetContext) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectionObjectInstance", (Object[])new Object[0]);
        }
        CreationalContext cc = (CreationalContext)targetContext.getInjectionTargetContextData(CreationalContext.class);
        Object retObj = InjectInjectionObjectFactory.getInstance().getObjectInstance(this, targetObject, cc);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInjectionObjectInstance : " + Util.identity((Object)retObj)));
        }
        return retObj;
    }

    public void setInjectionClassType(Method method) throws InjectionException {
        if (method.getParameterTypes().length == 1) {
            super.setInjectionClassType(method);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializer method multi parameter Injection. InjectionClassType will be null.", (Object[])new Object[0]);
        }
    }

    public Object getInjectionObject(Object targetObject, InjectionTargetContext targetContext) throws InjectionException {
        try {
            return super.getInjectionObject(targetObject, targetContext);
        }
        catch (InjectionException e) {
            if (!ignoreInjectionFailure) {
                throw e;
            }
            return null;
        }
    }
}

