/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.services;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webbeans.impl.service.LibertySingletonService;
import com.ibm.ws.webbeans.services.CDIService;
import com.ibm.ws.webbeans.services.InjectInjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Provider;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class InjectInjectionObjectFactory {
    private static final TraceComponent tc = Tr.register(InjectInjectionObjectFactory.class);
    private final AtomicServiceReference<CDIService> cdiServiceRef = new AtomicServiceReference("cdiService");
    private final AtomicServiceReference<LibertySingletonService> contextServiceRef = new AtomicServiceReference("contextService");
    private static InjectInjectionObjectFactory _this = null;

    public static InjectInjectionObjectFactory getInstance() {
        return _this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(InjectInjectionBinding iBinding, Object targetObject, CreationalContext<?> cc) throws Exception {
        CDIService jcdiSvc;
        BeanManager ibmBeanManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjectInstance", (Object[])new Object[]{iBinding, Util.identity((Object)targetObject), Util.identity(cc)});
        }
        if (null == (ibmBeanManager = (jcdiSvc = (CDIService)this.cdiServiceRef.getService()).getCurrentBeanManager())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JCDI runtime cannot resolve " + iBinding.getDisplayName() + " because of a null IBMBeanManager"), (Object[])new Object[0]);
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", null);
            }
            return null;
        }
        InjectInjectionObjectFactory.allBeanDebug(ibmBeanManager);
        Object[] injectedObjects = Collections.EMPTY_SET.toArray();
        boolean singleParamfieldOrMethodInjection = false;
        Class injectionClassType = iBinding.getInjectionClassType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WAS.injection injectionClassType: " + injectionClassType), (Object[])new Object[0]);
        }
        InjectionTarget injectionTargetWAS = iBinding.getInjectionTarget();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WAS.injection: " + injectionTargetWAS), (Object[])new Object[0]);
        }
        Class<?> injectableComponentClass = injectionTargetWAS.getMember().getDeclaringClass();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WAS injectableComponentClass: " + injectableComponentClass), (Object[])new Object[0]);
        }
        AnnotatedType annotated = ibmBeanManager.createAnnotatedType(injectableComponentClass);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OWB annotated: " + annotated), (Object[])new Object[0]);
        }
        javax.enterprise.inject.spi.InjectionTarget it = null;
        it = ibmBeanManager instanceof InjectableBeanManager ? ((InjectableBeanManager)ibmBeanManager).createInjectionTarget(annotated, false) : (ibmBeanManager instanceof BeanManagerImpl ? ((BeanManagerImpl)ibmBeanManager).createInjectionTarget(annotated, false) : ibmBeanManager.createInjectionTarget(annotated));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OWB InjectionTarget: " + it), (Object[])new Object[0]);
        }
        Set injectionPoints = it.getInjectionPoints();
        InjectInjectionObjectFactory.debugOWBInjectionPoints(injectionPoints);
        injectedObjects = new Object[injectionPoints.size()];
        int position = 0;
        for (InjectionPoint injectionPointOWB : injectionPoints) {
            if (injectionPointOWB.getMember().equals(injectionTargetWAS.getMember())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("MATCH  " + injectionTargetWAS), (Object[])new Object[0]);
                }
                boolean injectionPointBeanLocalSetOnStack = false;
                Object injectionObject = null;
                try {
                    if (null != injectionClassType) {
                        injectionPointBeanLocalSetOnStack = this.setOWBInjectionPointToSupportInstanceAndEventBean(injectionTargetWAS, injectionPointOWB);
                    }
                    if (injectionPointOWB.getAnnotated() instanceof AnnotatedParameter) {
                        position = ((AnnotatedParameter)injectionPointOWB.getAnnotated()).getPosition();
                    }
                    injectedObjects[position] = injectionObject = InjectInjectionObjectFactory.getInjectableReference(ibmBeanManager, injectionPointOWB, cc);
                    this.addThisDependentToDependentCreationalContext(targetObject, injectionObject, injectionPointOWB, cc);
                }
                finally {
                    if (injectionPointBeanLocalSetOnStack) {
                        InjectionPointBean.unsetThreadLocal();
                    }
                }
                if (null == injectionClassType || null == injectionObject) continue;
                singleParamfieldOrMethodInjection = true;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"field or single parameter method injection", (Object[])new Object[0]);
                break;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            InjectInjectionObjectFactory.debugNoOWBInjectionPointMatch(iBinding, injectionTargetWAS, injectionPointOWB);
        }
        if (injectedObjects.length > 0) {
            injectedObjects = InjectInjectionObjectFactory.pruneNulls(injectedObjects);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            InjectInjectionObjectFactory.debugInjectionObjects(injectedObjects);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance");
        }
        if (singleParamfieldOrMethodInjection) {
            return injectedObjects[0];
        }
        return injectedObjects;
    }

    private static Object[] pruneNulls(Object[] arrayThatContainsNulls) {
        ArrayList<Object> listOfObjects = new ArrayList<Object>(arrayThatContainsNulls.length);
        for (Object object : arrayThatContainsNulls) {
            if (null == object) continue;
            listOfObjects.add(object);
        }
        return listOfObjects.toArray();
    }

    private static void debugOWBInjectionPoints(Set<InjectionPoint> injectionPoints) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OWB injectionPoints: SIZE: " + injectionPoints.size()), (Object[])new Object[0]);
            for (InjectionPoint injectionPoint : injectionPoints) {
                Tr.debug((TraceComponent)tc, (String)("\t OWB InjectionPoint: " + injectionPoint), (Object[])new Object[0]);
            }
        }
    }

    private void addThisDependentToDependentCreationalContext(Object targetObject, Object injectionObject, InjectionPoint injectionPointOWB, CreationalContext<?> dependentCreationalContext) {
        InjectionResolver ir = new InjectionResolver(((LibertySingletonService)this.contextServiceRef.getService()).get(null));
        Bean<?> injectedContextualBean = ir.getInjectionPointBean(injectionPointOWB);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("injectedContextualBean " + injectedContextualBean), (Object[])new Object[0]);
        }
        if (!WebBeansUtil.isStaticInjection(injectionPointOWB) && WebBeansUtil.isDependent(injectedContextualBean)) {
            ((CreationalContextImpl)dependentCreationalContext).addDependent(targetObject, injectedContextualBean, injectionObject);
        }
    }

    private boolean setOWBInjectionPointToSupportInstanceAndEventBean(InjectionTarget injectionTargetWAS, InjectionPoint injectionPointOWB) {
        boolean injectionPointBeanLocalSetOnStack = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setOWBInjectionPointToSupportInstanceAndEventBean", (Object[])new Object[]{injectionTargetWAS, injectionPointOWB});
        }
        if (injectionTargetWAS.getInjectionClassType().equals(Instance.class) || injectionTargetWAS.getInjectionClassType().equals(Provider.class)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting owb injection point for InstanceBean", (Object[])new Object[0]);
            }
            InstanceBean.local.set(injectionPointOWB);
        } else if (injectionTargetWAS.getInjectionClassType().equals(Event.class)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting owb injection point for EventBean", (Object[])new Object[0]);
            }
            EventBean.local.set(injectionPointOWB);
        } else {
            InjectionResolver ir = new InjectionResolver(((LibertySingletonService)this.contextServiceRef.getService()).get(null));
            Bean<?> injectedBean = ir.getInjectionPointBean(injectionPointOWB);
            boolean isDependentInjectedBean = WebBeansUtil.isDependent(injectedBean);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("injectedBean " + injectedBean + " isDependent " + isDependentInjectedBean), (Object[])new Object[0]);
            }
            if (isDependentInjectedBean && !InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(injectionPointOWB.getType()))) {
                injectionPointBeanLocalSetOnStack = InjectionPointBean.setThreadLocal(injectionPointOWB);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setOWBInjectionPointToSupportInstanceAndEventBean", (Object)injectionPointBeanLocalSetOnStack);
        }
        return injectionPointBeanLocalSetOnStack;
    }

    private static Object getInjectableReference(BeanManager ibmBeanManager, InjectionPoint injectionPointOWB, CreationalContext<?> dependentCreationalContext) {
        Object injectionObject = ibmBeanManager.getInjectableReference(injectionPointOWB, dependentCreationalContext);
        if (injectionObject instanceof BeanManager) {
            injectionObject = ibmBeanManager;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"injectionObject = ibmBeanManager", (Object[])new Object[0]);
            }
        }
        return injectionObject;
    }

    private static void debugNoOWBInjectionPointMatch(InjectInjectionBinding iBinding, InjectionTarget injectionTargetWAS, InjectionPoint injectionPointOWB) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OWB and WAS member data do NOT MATCH", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("injectionPointOWB.getMember()=" + injectionPointOWB.getMember()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("injectionTargetWAS.getMember()=" + injectionTargetWAS.getMember()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("injectionPointOWB.getType()=" + injectionPointOWB.getType()), (Object[])new Object[0]);
            if (iBinding.getInjectionClassType() != null) {
                Tr.debug((TraceComponent)tc, (String)("injectionTargetWAS.getGenericType()=" + injectionTargetWAS.getGenericType()), (Object[])new Object[0]);
            }
        }
    }

    private static void allBeanDebug(BeanManager beanManager) throws InjectionException {
        if (null == beanManager) {
            throw new InjectionException("  We have been asked to inject a CDI managed bean in an EE type with a null BeanManager. There is no Bean Manager to get the CDI Bean reference");
        }
        Set allBeans = beanManager.getBeans(Object.class, new Annotation[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"\t \t ***** ALL Beans: ***** ", (Object[])new Object[0]);
        }
        for (Bean bean : allBeans) {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Bean: " + bean), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"\t \t ***** ALL Beans: ***** ", (Object[])new Object[0]);
        }
    }

    private static void debugInjectionObjects(Object[] injectionObjects) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (injectionObjects.length == 0) {
                Tr.debug((TraceComponent)tc, (String)" []", (Object[])new Object[0]);
                return;
            }
            StringBuilder buffer = new StringBuilder(injectionObjects.length * 16);
            buffer.append('[');
            for (int i = 0; i < injectionObjects.length; ++i) {
                if (injectionObjects[i] != injectionObjects) {
                    buffer.append(Util.identity((Object)injectionObjects[i]));
                } else {
                    buffer.append("(this Collection)");
                }
                if (i >= injectionObjects.length - 1) continue;
                buffer.append(',');
            }
            buffer.append(']');
            Tr.debug((TraceComponent)tc, (String)("SUCCESS " + buffer.toString()), (Object[])new Object[0]);
        }
    }

    public void activate(ComponentContext context) {
        this.cdiServiceRef.activate(context);
        this.contextServiceRef.activate(context);
        _this = this;
    }

    public void deactivate(ComponentContext context) {
        this.cdiServiceRef.deactivate(context);
        this.contextServiceRef.deactivate(context);
        _this = null;
    }

    protected void setCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.setReference(ref);
    }

    protected void unsetCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.unsetReference(ref);
    }

    protected void setContextService(ServiceReference<LibertySingletonService> ref) {
        this.contextServiceRef.setReference(ref);
    }

    protected void unsetContextService(ServiceReference<LibertySingletonService> ref) {
        this.contextServiceRef.unsetReference(ref);
    }
}

