/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.services;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webbeans.services.InjectInjectionBinding;
import com.ibm.ws.webbeans.services.ResourceInjectionBag;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.WebBeansUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class ResourceInjectionServiceImpl
implements ResourceInjectionService {
    private static final TraceComponent tc = Tr.register(ResourceInjectionServiceImpl.class);
    private final AtomicServiceReference<InjectionEngine> injectionEngineServiceRef = new AtomicServiceReference("injectionEngine");
    private final Map<J2EEName, HashMap<Class<?>, InjectionTarget[]>> modules = new ConcurrentHashMap();
    private static final String DUMMY_STRING = "owb.actual.resource.dummy";
    private final Map<String, J2EEName> classToModuleWithBindings = new HashMap<String, J2EEName>();
    private static final String CROSS_EJB_MODULE_BINDINGS = "com.ibm.ws.webbeans.crossEjbModuleBindings";
    private WebBeansContext webBeansContext;
    private boolean isCrossEjbModuleBindings;
    private final ThreadLocal<J2EEName> fallbackJ2EENames = new ThreadLocal();

    protected void activate(ComponentContext compcontext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.injectionEngineServiceRef.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.injectionEngineServiceRef.deactivate(compcontext);
    }

    protected void setInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineServiceRef.setReference(ref);
    }

    protected void unsetInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineServiceRef.unsetReference(ref);
    }

    public void initialize(List<Class<?>> injectionClasses, ClassLoader cl) {
        this.initialize(injectionClasses, cl, null);
    }

    public void initialize(List<Class<?>> injectionClasses, ClassLoader cl, ResourceInjectionBag bag) {
        ComponentMetaData cmd = null;
        ModuleMetaData mmd = null;
        cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd != null) {
            mmd = cmd.getModuleMetaData();
            this.initialize(mmd, injectionClasses, cl, bag);
        }
    }

    public void initialize(ModuleMetaData mmd, List<Class<?>> injectionClasses, ClassLoader cl, ResourceInjectionBag bag) {
        block19: {
            J2EEName j2eeName = null;
            if (mmd != null) {
                j2eeName = mmd.getJ2EEName();
            }
            if (j2eeName != null && mmd != null) {
                ComponentNameSpaceConfiguration compNSConfig;
                block18: {
                    compNSConfig = new ComponentNameSpaceConfiguration(null, j2eeName);
                    if (cl == null) {
                        cl = WebBeansUtil.getCurrentClassLoader();
                    }
                    compNSConfig.setClassLoader(cl);
                    compNSConfig.setModuleMetaData(mmd);
                    compNSConfig.setMetaDataComplete(false);
                    if (bag != null) {
                        try {
                            String crossEjbModuleBindingsStr;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Looking for env entries", (Object[])new Object[0]);
                            }
                            compNSConfig.setEnvEntries(bag.envEntries);
                            compNSConfig.setEnvEntryValues(bag.envEntryValues);
                            compNSConfig.setEnvEntryBindings(bag.envEntryBindings);
                            compNSConfig.setEnvironmentProperties(bag.envProperties);
                            compNSConfig.setEJBRefs(bag.ejbRefs);
                            compNSConfig.setEJBRefBindings(bag.ejbRefBindings);
                            compNSConfig.setWebServiceRefs(bag.webServiceRefs);
                            compNSConfig.setResourceRefs(bag.resourceRefs);
                            compNSConfig.setResourceRefBindings(bag.resourceRefBindings);
                            compNSConfig.setResourceEnvRefs(bag.resourceEnvRefs);
                            compNSConfig.setResourceEnvRefBindings(bag.resourceEnvRefBindings);
                            compNSConfig.setMsgDestRefs(bag.msgDestRefs);
                            compNSConfig.setMsgDestRefBindings(bag.msgDestRefBindings);
                            compNSConfig.setPersistenceUnitRefs(bag.persistenceUnitRefs);
                            compNSConfig.setPersistenceContextRefs(bag.persistenceContextRefs);
                            compNSConfig.setDataSourceDefinitions(bag.dataSourceDefinitions);
                            compNSConfig.setDataSourceDefinitionBindings(bag.dataSourceDefinitionBindings);
                            compNSConfig.setResourceRefConfigList(bag.resourceRefConfigList);
                            this.webBeansContext = bag.webBeansContext;
                            if (this.webBeansContext != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"WebBeansContext not null, try to get value of: com.ibm.ws.webbeans.crossEjbModuleBindings", (Object[])new Object[0]);
                                }
                                crossEjbModuleBindingsStr = this.webBeansContext.getSecurityService().doPrivilegedGetSystemProperty(CROSS_EJB_MODULE_BINDINGS, "false");
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"WebBeansContext is null, try to get value of: com.ibm.ws.webbeans.crossEjbModuleBindings", (Object[])new Object[0]);
                                }
                                crossEjbModuleBindingsStr = WebBeansContext.currentInstance().getSecurityService().doPrivilegedGetSystemProperty(CROSS_EJB_MODULE_BINDINGS, "false");
                            }
                            this.isCrossEjbModuleBindings = Boolean.valueOf(crossEjbModuleBindingsStr);
                            if (this.isCrossEjbModuleBindings && bag.classesScanned != null) {
                                for (String scannedClass : bag.classesScanned) {
                                    this.classToModuleWithBindings.put(scannedClass, j2eeName);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block18;
                            Tr.debug((TraceComponent)tc, (String)("Caught Exception looking for Env Entries: " + e), (Object[])new Object[0]);
                        }
                    }
                }
                compNSConfig.setOwningFlow(ComponentNameSpaceConfiguration.ReferenceFlowKind.MANAGED_BEAN);
                compNSConfig.setInjectionClasses(injectionClasses);
                InjectionEngine injectionEngine = (InjectionEngine)this.injectionEngineServiceRef.getService();
                if (injectionEngine != null) {
                    HashMap allInjectionTargets = new HashMap();
                    try {
                        injectionEngine.processInjectionMetaData(allInjectionTargets, compNSConfig);
                        if (!allInjectionTargets.isEmpty()) {
                            this.modules.put(j2eeName, allInjectionTargets);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("add a non-empty allInjectionTargets map for j2eeName of: " + j2eeName), (Object[])new Object[0]);
                            }
                        }
                    }
                    catch (InjectionException ie) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                        Tr.debug((TraceComponent)tc, (String)("loadAndInjectBeanClasses caught: " + (Object)((Object)ie)), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    public void addToClassToModuleWithBindings(Class<?> clazz, J2EEName j2eeName) {
        if (this.isCrossEjbModuleBindings && clazz != null && !this.classToModuleWithBindings.containsKey(clazz.getName())) {
            this.classToModuleWithBindings.put(clazz.getName(), j2eeName);
        }
    }

    public void removeModuleInjectionTargets() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeModuleInjectionTargets: ComponentMetaData is null", (Object[])new Object[0]);
            }
            return;
        }
        ModuleMetaData mmd = cmd.getModuleMetaData();
        if (mmd == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeModuleInjectionTargets: ModuleMetaData is null", (Object[])new Object[0]);
            }
            return;
        }
        J2EEName j2eeName = mmd.getJ2EEName();
        if (j2eeName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeModuleInjectionTargets: J2EEName is null", (Object[])new Object[0]);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeModuleInjectionTargets: removing " + j2eeName), (Object[])new Object[0]);
        }
        this.modules.remove(j2eeName);
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clear", (Object[])new Object[]{this});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        ComponentMetaData cmd;
        J2EEName name = null;
        ModuleMetaData mmd = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResourceReference", (Object[])new Object[]{resourceReference.getName(), resourceReference.getOwnerClass(), resourceReference.getResourceType(), this});
        }
        if ((cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData()) != null && (mmd = cmd.getModuleMetaData()) != null) {
            name = mmd.getJ2EEName();
        }
        HashMap<Class<?>, InjectionTarget[]> mod = this.modules.get(name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResourceReference looked up data " + mod + "for EE name " + name), (Object[])new Object[0]);
        }
        Object injectedObject = null;
        InjectionTarget[] targets = this.getInjectionTargets(resourceReference.getOwnerClass(), mod);
        if (targets != null) {
            for (InjectionTarget target : targets) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)target.getMember().toString(), (Object[])new Object[0]);
                }
                if (!target.getMember().getName().equals(resourceReference.getName())) continue;
                InjectionBinding binding = target.getInjectionBinding();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)binding.toString(), (Object[])new Object[0]);
                }
                if (!binding.getInjectionClassType().equals(resourceReference.getResourceType()) || !resourceReference.supports(binding.getAnnotationType())) continue;
                try {
                    injectedObject = binding.getInjectionObject();
                    break;
                }
                catch (InjectionException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"CWOWB0102", (Object[])new Object[]{e.getMessage()});
                    }
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".getResourceReference"), (String)"274", (Object)this);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResourceReference", injectedObject);
        }
        return (X)injectedObject;
    }

    public void injectJavaEEResources(Object managedBeanInstance) {
        block12: {
            ModuleMetaData mmd = null;
            J2EEName name = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"injectJavaEEResources", (Object[])new Object[]{managedBeanInstance});
            }
            final Object mbInstance = managedBeanInstance;
            ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (this.isCrossEjbModuleBindings) {
                Class<?> injectionClass = managedBeanInstance.getClass();
                String className = injectionClass.getName();
                name = this.classToModuleWithBindings.get(className);
            }
            if (name == null && cmd != null && (mmd = cmd.getModuleMetaData()) != null) {
                name = mmd.getJ2EEName();
            }
            if (name == null) {
                name = this.fallbackJ2EENames.get();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Retrived fallback J2EEName on Thread {0}, found {1}", (Object[])new Object[]{Thread.currentThread(), name});
                }
            }
            final HashMap<Class<?>, InjectionTarget[]> mod = this.modules.get(name);
            try {
                if (this.isCrossEjbModuleBindings) {
                    Boolean hasTargets = this.callInject(mbInstance, mod);
                    if (!hasTargets.booleanValue()) {
                        Set<J2EEName> modulesSet = this.modules.keySet();
                        Iterator<J2EEName> moduleIterator = modulesSet.iterator();
                        HashMap<Class<?>, InjectionTarget[]> otherMod = null;
                        while (!hasTargets.booleanValue() && moduleIterator.hasNext()) {
                            otherMod = this.modules.get(moduleIterator.next());
                            if (mod == otherMod) continue;
                            hasTargets = this.callInject(mbInstance, otherMod);
                        }
                    }
                } else {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ResourceInjectionServiceImpl.this.inject(mbInstance.getClass(), mbInstance, mod);
                            return null;
                        }
                    });
                }
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (!tc.isErrorEnabled()) break block12;
                Tr.error((TraceComponent)tc, (String)"CWOWB0102", (Object[])new Object[]{e.getLocalizedMessage()});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"injectJavaEEResources");
        }
    }

    private Boolean callInject(final Object mbInstance, final HashMap<Class<?>, InjectionTarget[]> mod) throws PrivilegedActionException {
        Boolean hasTargets = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                Boolean hasTargets = ResourceInjectionServiceImpl.this.inject(mbInstance.getClass(), mbInstance, mod);
                return hasTargets;
            }
        });
        return hasTargets;
    }

    private Boolean inject(Class clazz, Object toInject, HashMap<Class<?>, InjectionTarget[]> mod) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inject", (Object[])new Object[]{Util.identity((Object)toInject)});
        }
        Boolean hasTargets = Boolean.FALSE;
        InjectionTarget[] targets = this.getInjectionTargets(clazz, mod);
        if (null != targets) {
            hasTargets = Boolean.TRUE;
            for (InjectionTarget target : targets) {
                if (target.getInjectionBinding() instanceof InjectInjectionBinding) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"skipping --> [" + target + "]"});
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"about to inject resource --> [" + target + "]"});
                }
                try {
                    InjectionEngine injectionEngine = (InjectionEngine)this.injectionEngineServiceRef.getService();
                    injectionEngine.inject(toInject, target);
                }
                catch (Exception e) {
                    if (tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"CWOWB0102", (Object[])new Object[]{e.getMessage()});
                    }
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".inject"), (String)"180", (Object)this);
                    throw e;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"injected resource --> [" + target + "]"});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inject");
        }
        return hasTargets;
    }

    private InjectionTarget[] getInjectionTargets(Class<?> clazz, HashMap<Class<?>, InjectionTarget[]> mod) {
        InjectionTarget[] targets = null;
        if (mod == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{clazz + " no injection targets found - mod is null"});
            }
            return null;
        }
        targets = mod.get(clazz);
        if (targets == null || targets.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{clazz + " no injection targets found "});
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{clazz + " injection targets found " + Arrays.asList(targets)});
        }
        return targets;
    }

    public <T> T readExternal(Bean<T> bean, ObjectInput in) throws IOException, ClassNotFoundException {
        Object obj = in.readObject();
        if (obj.equals(DUMMY_STRING)) {
            return (T)((ResourceBean)bean).getActualInstance();
        }
        return (T)obj;
    }

    public <T> void writeExternal(Bean<T> bean, T actualResource, ObjectOutput out) throws IOException {
        if (actualResource instanceof Serializable) {
            out.writeObject(actualResource);
        } else {
            out.writeObject(DUMMY_STRING);
        }
    }

    public void putFallbackJ2EEName(J2EEName j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Stashing fallback J2EEName on Thread, name: {0}", (Object[])new Object[]{j2eeName});
        }
        this.fallbackJ2EENames.set(j2eeName);
    }

    public void removeFallbackJ2EEName() {
        J2EEName j2eeName = this.fallbackJ2EENames.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removing fallback J2EEName from Thread, removed name: {0}", (Object[])new Object[]{j2eeName});
        }
        this.fallbackJ2EENames.remove();
    }
}

