/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.config.OwbParametrizedTypeImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.ClassUtil;

public class BeanTypeSetResolver {
    private static final String DISCOVER_PARENT_PARAMETERIZED_TYPES = "com.ibm.ws.webbeans.discoverParentParameterizedTypes";
    private boolean resolveParameterizedTypes = false;
    private final Type beanType;
    private final Set<Type> hierarchy = new HashSet<Type>();

    public BeanTypeSetResolver(Type beanType) {
        this.beanType = beanType;
        String value = WebBeansContext.currentInstance().getOpenWebBeansConfiguration().getProperty(DISCOVER_PARENT_PARAMETERIZED_TYPES);
        if (value != null && value.equalsIgnoreCase("true")) {
            this.resolveParameterizedTypes = true;
        }
    }

    public void startConfiguration() {
        if (this.beanType == Object.class || this.beanType instanceof Class && ((Class)this.beanType).isSynthetic()) {
            return;
        }
        if (ClassUtil.isParametrizedType(this.beanType)) {
            this.parametrizedClassConfiguration((ParameterizedType)this.beanType);
        } else if (this.beanType instanceof Class) {
            this.normalClassConfiguration((Class)this.beanType);
        }
    }

    private void normalClassConfiguration(Class<?> beanClass) {
        if (ClassUtil.isDefinitionContainsTypeVariables(beanClass)) {
            OwbParametrizedTypeImpl pt = new OwbParametrizedTypeImpl(beanClass.getDeclaringClass(), beanClass);
            TypeVariable<Class<?>>[] tvs = beanClass.getTypeParameters();
            for (Type type : tvs) {
                pt.addTypeArgument(type);
            }
            this.hierarchy.add(pt);
        } else {
            this.hierarchy.add(beanClass);
        }
        Type superClass = beanClass.getGenericSuperclass();
        if (superClass != null && superClass != Object.class) {
            BeanTypeSetResolver superResolver = new BeanTypeSetResolver(superClass);
            superResolver.startConfiguration();
            this.hierarchy.addAll(superResolver.getHierarchy());
        }
        Type[] interfaces = beanClass.getGenericInterfaces();
        for (Type type : interfaces) {
            BeanTypeSetResolver superResolver = new BeanTypeSetResolver(type);
            superResolver.startConfiguration();
            this.hierarchy.addAll(superResolver.getHierarchy());
        }
    }

    private void parametrizedClassConfiguration(ParameterizedType parametrizedClass) {
        Type[] superInterfacesGeneric;
        this.hierarchy.add(parametrizedClass);
        Class rawType = (Class)parametrizedClass.getRawType();
        Type superClassGeneric = rawType.getGenericSuperclass();
        if (superClassGeneric != null) {
            this.addSuperParameterizedType(parametrizedClass, superClassGeneric);
        }
        for (Type superInterfaceGeneric : superInterfacesGeneric = rawType.getGenericInterfaces()) {
            this.addSuperParameterizedType(parametrizedClass, superInterfaceGeneric);
        }
    }

    private void addSuperParameterizedType(ParameterizedType parametrizedClass, Type superInterfaceGeneric) {
        boolean configured = false;
        BeanTypeSetResolver superResolver = null;
        if (ClassUtil.isParametrizedType(superInterfaceGeneric)) {
            OwbParametrizedTypeImpl resolvedType = this.resolveTypeArguments(parametrizedClass, (ParameterizedType)superInterfaceGeneric);
            superResolver = this.resolveParameterizedTypes ? new BeanTypeSetResolver(resolvedType) : new BeanTypeSetResolver(superInterfaceGeneric);
            this.hierarchy.add(resolvedType);
            configured = true;
        } else {
            superResolver = new BeanTypeSetResolver(superInterfaceGeneric);
            this.hierarchy.add(superInterfaceGeneric);
        }
        superResolver.startConfiguration();
        this.hierarchy.addAll(superResolver.getHierarchy());
        if (configured) {
            this.hierarchy.remove(superInterfaceGeneric);
        }
    }

    private OwbParametrizedTypeImpl resolveTypeArguments(ParameterizedType beanClass, ParameterizedType superClass) {
        Type[] superClassArgs;
        OwbParametrizedTypeImpl ptImpl = new OwbParametrizedTypeImpl(superClass.getOwnerType(), superClass.getRawType());
        TypeVariable<Class<?>>[] beanClassTypeVariables = ClassUtil.getClass(beanClass).getTypeParameters();
        Type[] beanClassArgs = beanClass.getActualTypeArguments();
        for (Type superClassArg : superClassArgs = superClass.getActualTypeArguments()) {
            boolean found = false;
            for (int i = 0; i < beanClassTypeVariables.length; ++i) {
                TypeVariable<Class<?>> beanClassTypeVariable = beanClassTypeVariables[i];
                Type beanClassArg = beanClassArgs[i];
                if (!ClassUtil.isTypeVariable(superClassArg) || !superClassArg.equals(beanClassTypeVariable)) continue;
                ptImpl.addTypeArgument(beanClassArg);
                found = true;
                break;
            }
            if (found) continue;
            if (ClassUtil.isParametrizedType(superClassArg)) {
                ptImpl.addTypeArgument(this.resolveTypeArguments(beanClass, (ParameterizedType)superClassArg));
                continue;
            }
            ptImpl.addTypeArgument(superClassArg);
        }
        return ptImpl;
    }

    public Set<Type> getHierarchy() {
        return this.hierarchy;
    }
}

