/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.ManagedBeanConfigurator;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.container.ResolutionUtil;
import org.apache.webbeans.container.SerializableBeanVault;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.creational.CreationalContextFactory;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.intercept.WebBeansInterceptorConfig;
import org.apache.webbeans.intercept.ejb.EJBInterceptorConfig;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.proxy.ProxyFactory;
import org.apache.webbeans.proxy.javassist.OpenWebBeansClassLoaderProvider;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansAnnotatedTypeUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class WebBeansContext {
    private final Map<Class<?>, Object> managerMap = new HashMap();
    private final Map<Class<?>, Object> serviceMap = new HashMap();
    private final WebBeansUtil webBeansUtil = new WebBeansUtil(this);
    private final ContextFactory contextFactory = new ContextFactory(this);
    private final AlternativesManager alternativesManager = new AlternativesManager(this);
    private final AnnotatedElementFactory annotatedElementFactory = new AnnotatedElementFactory(this);
    private final BeanManagerImpl beanManagerImpl = new BeanManagerImpl(this);
    private final ConversationManager conversationManager = new ConversationManager(this);
    private final CreationalContextFactory creationalContextFactory = new CreationalContextFactory(this);
    private final DecoratorsManager decoratorsManager = new DecoratorsManager(this);
    private final EJBInterceptorConfig ejbInterceptorConfig = new EJBInterceptorConfig(this);
    private final ExtensionLoader extensionLoader = new ExtensionLoader(this);
    private final InterceptorsManager interceptorsManager = new InterceptorsManager(this);
    private final WebBeansInterceptorConfig webBeansInterceptorConfig = new WebBeansInterceptorConfig(this);
    private final ProxyFactory proxyFactory;
    private final OpenWebBeansConfiguration openWebBeansConfiguration;
    private final PluginLoader pluginLoader = new PluginLoader();
    private final SerializableBeanVault serializableBeanVault = new SerializableBeanVault();
    private final StereoTypeManager stereoTypeManager = new StereoTypeManager();
    private final AnnotationManager annotationManager = new AnnotationManager(this);
    private final ResolutionUtil resolutionUtil = new ResolutionUtil(this);
    private final InjectionPointFactory injectionPointFactory = new InjectionPointFactory(this);
    private final InterceptorUtil interceptorUtil = new InterceptorUtil(this);
    private final DefinitionUtil definitionUtil = new DefinitionUtil(this);
    private final WebBeansAnnotatedTypeUtil annotatedTypeUtil = new WebBeansAnnotatedTypeUtil(this);
    private final ManagedBeanConfigurator managedBeanConfigurator = new ManagedBeanConfigurator(this);
    private final SecurityService securityService;
    private final LoaderService loaderService;
    private ScannerService scannerService;
    private InjectableBeanManager injBeanManager = null;
    private boolean webAppLifecycleStarted = false;

    public WebBeansContext() {
        this(null, new OpenWebBeansConfiguration());
    }

    public WebBeansContext(Map<Class<?>, Object> initialServices, Properties properties) {
        this(initialServices, new OpenWebBeansConfiguration(properties));
    }

    public WebBeansContext(Map<Class<?>, Object> initialServices, OpenWebBeansConfiguration openWebBeansConfiguration) {
        this.openWebBeansConfiguration = openWebBeansConfiguration;
        this.injBeanManager = new InjectableBeanManager(this.beanManagerImpl);
        if (initialServices == null || !initialServices.containsKey(LoaderService.class)) {
            String implementationLoaderServiceName = openWebBeansConfiguration.getProperty(LoaderService.class.getName());
            if (implementationLoaderServiceName == null) {
                this.serviceMap.put(LoaderService.class, new DefaultLoaderService());
            } else {
                this.serviceMap.put(LoaderService.class, LoaderService.class.cast(this.get(implementationLoaderServiceName)));
            }
        }
        if (initialServices != null) {
            for (Map.Entry<Class<?>, Object> entry : initialServices.entrySet()) {
                if (!entry.getKey().isAssignableFrom(entry.getValue().getClass())) {
                    throw new IllegalArgumentException("Initial service claiming to be of type " + entry.getKey() + " is a " + entry.getValue().getClass());
                }
                this.serviceMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.loaderService = this.getService(LoaderService.class);
        this.securityService = this.getService(SecurityService.class);
        this.proxyFactory = this.serviceMap.containsKey(ProxyFactory.class) ? (ProxyFactory)this.serviceMap.get(ProxyFactory.class) : new ProxyFactory();
        OpenWebBeansClassLoaderProvider.initProxyFactoryClassLoaderProvider();
        this.managerMap.put(this.getClass(), this);
        this.managerMap.put(AlternativesManager.class, this.alternativesManager);
        this.managerMap.put(AnnotatedElementFactory.class, this.annotatedElementFactory);
        this.managerMap.put(BeanManagerImpl.class, this.beanManagerImpl);
        this.managerMap.put(ConversationManager.class, this.conversationManager);
        this.managerMap.put(CreationalContextFactory.class, this.creationalContextFactory);
        this.managerMap.put(DecoratorsManager.class, this.decoratorsManager);
        this.managerMap.put(ExtensionLoader.class, this.extensionLoader);
        this.managerMap.put(InterceptorsManager.class, this.interceptorsManager);
        this.managerMap.put(ProxyFactory.class, this.proxyFactory);
        this.managerMap.put(OpenWebBeansConfiguration.class, openWebBeansConfiguration);
        this.managerMap.put(PluginLoader.class, this.pluginLoader);
        this.managerMap.put(SerializableBeanVault.class, this.serializableBeanVault);
        this.managerMap.put(StereoTypeManager.class, this.stereoTypeManager);
    }

    @Deprecated
    public static WebBeansContext getInstance() {
        WebBeansContext webBeansContext = WebBeansFinder.getSingletonInstance();
        return webBeansContext;
    }

    public static WebBeansContext currentInstance() {
        return WebBeansContext.getInstance();
    }

    public <T> T getService(Class<T> clazz) {
        T t = clazz.cast(this.serviceMap.get(clazz));
        if (t == null) {
            t = this.doServiceLoader(clazz);
            this.registerService(clazz, t);
        }
        return t;
    }

    public <T> void registerService(Class<T> clazz, T t) {
        this.serviceMap.put(clazz, t);
    }

    private <T> T doServiceLoader(Class<T> serviceInterface) {
        String implName = this.getOpenWebBeansConfiguration().getProperty(serviceInterface.getName());
        if (implName == null) {
            List<OpenWebBeansPlugin> plugins = this.getPluginLoader().getPlugins();
            if (plugins != null && plugins.size() > 0) {
                for (OpenWebBeansPlugin plugin : plugins) {
                    if (!plugin.supportService(serviceInterface)) continue;
                    return (T)plugin.getSupportedService(serviceInterface);
                }
            }
            return null;
        }
        return serviceInterface.cast(this.get(implName));
    }

    public ManagedBeanConfigurator getManagedBeanConfigurator() {
        return this.managedBeanConfigurator;
    }

    public InterceptorUtil getInterceptorUtil() {
        return this.interceptorUtil;
    }

    public DefinitionUtil getDefinitionUtil() {
        return this.definitionUtil;
    }

    public WebBeansAnnotatedTypeUtil getAnnotatedTypeUtil() {
        return this.annotatedTypeUtil;
    }

    public InjectionPointFactory getInjectionPointFactory() {
        return this.injectionPointFactory;
    }

    public ResolutionUtil getResolutionUtil() {
        return this.resolutionUtil;
    }

    public WebBeansUtil getWebBeansUtil() {
        return this.webBeansUtil;
    }

    @Deprecated
    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public OpenWebBeansConfiguration getOpenWebBeansConfiguration() {
        return this.openWebBeansConfiguration;
    }

    public AnnotatedElementFactory getAnnotatedElementFactory() {
        return this.annotatedElementFactory;
    }

    public BeanManagerImpl getBeanManagerImpl() {
        return this.beanManagerImpl;
    }

    public InjectableBeanManager getInjectableBeanManager() {
        return this.injBeanManager;
    }

    public SerializableBeanVault getSerializableBeanVault() {
        return this.serializableBeanVault;
    }

    public CreationalContextFactory getCreationalContextFactory() {
        return this.creationalContextFactory;
    }

    public DecoratorsManager getDecoratorsManager() {
        return this.decoratorsManager;
    }

    public WebBeansInterceptorConfig getWebBeansInterceptorConfig() {
        return this.webBeansInterceptorConfig;
    }

    public EJBInterceptorConfig getEJBInterceptorConfig() {
        return this.ejbInterceptorConfig;
    }

    public StereoTypeManager getStereoTypeManager() {
        return this.stereoTypeManager;
    }

    public AlternativesManager getAlternativesManager() {
        return this.alternativesManager;
    }

    public InterceptorsManager getInterceptorsManager() {
        return this.interceptorsManager;
    }

    public PluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public ScannerService getScannerService() {
        if (this.scannerService == null) {
            this.scannerService = this.getService(ScannerService.class);
        }
        return this.scannerService;
    }

    public ContextsService getContextsService() {
        return this.getService(ContextsService.class);
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    private Object get(String singletonName) {
        Class<?> clazz = ClassUtil.getClassFromName(singletonName);
        if (clazz == null) {
            throw new WebBeansException("Class not found exception in creating instance with class : " + singletonName, new ClassNotFoundException("Class with name: " + singletonName + " is not found in the system"));
        }
        return this.get(clazz);
    }

    public <T> T get(Class<T> clazz) {
        return this.get(clazz, true);
    }

    public <T> T get(Class<T> clazz, boolean createIfNotFound) {
        T object = clazz.cast(this.managerMap.get(clazz));
        if (object == null && createIfNotFound) {
            object = this.createInstance(clazz);
            this.managerMap.put(clazz, object);
        }
        return object;
    }

    private <T> T createInstance(Class<T> clazz) {
        try {
            try {
                Constructor<T> constructor = clazz.getConstructor(WebBeansContext.class);
                return constructor.newInstance(this);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor<T> constructor2 = clazz.getConstructor(new Class[0]);
                    return constructor2.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new WebBeansException("No suitable constructor : " + clazz.getName(), e.getCause());
                }
            }
        }
        catch (InstantiationException e) {
            throw new WebBeansException("Unable to instantiate class : " + clazz.getName(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new WebBeansException("Unable to instantiate class : " + clazz.getName(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new WebBeansException("Illegal access exception in creating instance with class : " + clazz.getName(), e);
        }
    }

    public void clear() {
        this.managerMap.clear();
    }

    public LoaderService getLoaderService() {
        return this.loaderService;
    }

    public void setWebAppLifecycleStarted(boolean webAppLifecycleStarted) {
        this.webAppLifecycleStarted = webAppLifecycleStarted;
    }

    public boolean isWebAppLifecycleStarted() {
        return this.webAppLifecycleStarted;
    }
}

