/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.JmsBeanMarker;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.third.ThirdpartyBeanImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.container.ManagerObjectFactory;
import org.apache.webbeans.container.ResolutionUtil;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DecoratorComparator;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.definition.DuplicateDefinitionException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.intercept.InterceptorComparator;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.plugins.OpenWebBeansJmsPlugin;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.creation.InjectionTargetProducer;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class BeanManagerImpl
implements BeanManager,
Referenceable {
    private static final String GET_BEANS_FILTER = "com.ibm.ws.webbeans.getBeansFilterNonAlternatives";
    private boolean shouldGetBeansFilter = Boolean.valueOf(SecurityUtil.doPrivilegedGetSystemProperty("com.ibm.ws.webbeans.getBeansFilterNonAlternatives", "false"));
    private static final long serialVersionUID = 2L;
    private final Map<Class<? extends Annotation>, List<Context>> contextMap = new HashMap<Class<? extends Annotation>, List<Context>>();
    private final Map<Class<? extends Annotation>, Context> singleContextMap = new HashMap<Class<? extends Annotation>, Context>();
    private final Set<Bean<?>> deploymentBeans = new CopyOnWriteArraySet();
    private final List<Interceptor<?>> webBeansInterceptors = new ArrayList();
    private final Map<Contextual<?>, Object> cacheProxies = new ConcurrentHashMap();
    private final Set<Decorator<?>> webBeansDecorators = new CopyOnWriteArraySet();
    private NotificationManager notificationManager = null;
    private InjectionResolver injectionResolver = null;
    private WebBeansXMLConfigurator xmlConfigurator = null;
    private final List<Class<?>> additionalDecoratorClasses = new ArrayList();
    private final List<Class<?>> additionalInterceptorClasses = new ArrayList();
    private final Map<Class<? extends Annotation>, Set<Annotation>> additionalInterceptorBindingTypes = new HashMap<Class<? extends Annotation>, Set<Annotation>>();
    private final List<Class<? extends Annotation>> additionalQualifiers = new ArrayList<Class<? extends Annotation>>();
    private final List<ExternalScope> additionalScopes = new ArrayList<ExternalScope>();
    private final List<AnnotatedType<?>> additionalAnnotatedTypes = new ArrayList();
    private final ErrorStack errorStack = new ErrorStack();
    private final ConcurrentHashMap<String, Bean<?>> passivationBeans = new ConcurrentHashMap();
    private final Map<Contextual<?>, InjectionTargetWrapper<?>> injectionTargetWrappers = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<Class<?>, InjectionTargetWrapper<?>> injectionTargetForJavaEeComponents = new ConcurrentHashMap();
    private final AnnotatedElementFactory annotatedElementFactory;
    private final WebBeansContext webBeansContext;
    private boolean inUse = false;

    public BeanManagerImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.injectionResolver = new InjectionResolver(webBeansContext);
        this.notificationManager = new NotificationManager(webBeansContext);
        this.annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
    }

    public <T> void putInjectionTargetWrapper(Contextual<T> contextual, InjectionTargetWrapper<T> wrapper) {
        Asserts.assertNotNull(contextual);
        Asserts.assertNotNull(wrapper);
        this.injectionTargetWrappers.put(contextual, wrapper);
    }

    public <T> InjectionTargetWrapper<T> getInjectionTargetWrapper(Contextual<T> contextual) {
        Asserts.assertNotNull(contextual);
        return this.injectionTargetWrappers.get(contextual);
    }

    public <T> void putInjectionTargetWrapperForJavaEeComponents(Class<T> javaEeComponentClass, InjectionTargetWrapper<T> wrapper) {
        Asserts.assertNotNull(javaEeComponentClass);
        Asserts.assertNotNull(wrapper);
        this.injectionTargetForJavaEeComponents.put(javaEeComponentClass, wrapper);
    }

    public <T> InjectionTargetWrapper<T> getInjectionTargetWrapper(Class<T> javaEeComponentClass) {
        Asserts.assertNotNull(javaEeComponentClass);
        return this.injectionTargetForJavaEeComponents.get(javaEeComponentClass);
    }

    public ErrorStack getErrorStack() {
        return this.errorStack;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public InjectionResolver getInjectionResolver() {
        return this.injectionResolver;
    }

    public synchronized void setXMLConfigurator(WebBeansXMLConfigurator xmlConfigurator) {
        if (this.xmlConfigurator != null) {
            throw new IllegalStateException("WebBeansXMLConfigurator is already defined!");
        }
        this.xmlConfigurator = xmlConfigurator;
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(scopeType, "scopeType paramter can not be null");
        Context standardContext = this.webBeansContext.getContextFactory().getStandardContext(scopeType);
        if (standardContext != null && standardContext.isActive()) {
            return standardContext;
        }
        Context singleContext = this.singleContextMap.get(scopeType);
        if (singleContext != null) {
            if (!singleContext.isActive()) {
                throw new ContextNotActiveException("WebBeans context with scope type annotation @" + scopeType.getSimpleName() + " does not exist within current thread");
            }
            return singleContext;
        }
        List<Context> others = this.contextMap.get(scopeType);
        Context found = null;
        if (others != null) {
            for (Context otherContext : others) {
                if (!otherContext.isActive()) continue;
                if (found != null) {
                    throw new IllegalStateException("More than one active context exists with scope type annotation @" + scopeType.getSimpleName());
                }
                found = otherContext;
            }
        }
        if (found == null) {
            throw new ContextNotActiveException("WebBeans context with scope type annotation @" + scopeType.getSimpleName() + " does not exist within current thread");
        }
        return found;
    }

    public BeanManager addBean(Bean<?> newBean) {
        this.inUse = true;
        return this.addInternalBean(newBean);
    }

    public BeanManager addInternalBean(Bean<?> newBean) {
        if (newBean instanceof AbstractOwbBean) {
            this.addPassivationInfo((OwbBean)newBean);
            this.deploymentBeans.add(newBean);
        } else {
            ThirdpartyBeanImpl bean = new ThirdpartyBeanImpl(newBean, this.webBeansContext);
            this.addPassivationInfo(bean);
            this.deploymentBeans.add(bean);
        }
        return this;
    }

    protected void addPassivationInfo(OwbBean<?> bean) throws DefinitionException {
        Bean oldBean;
        String id = bean.getId();
        if (id != null && (oldBean = (Bean)this.passivationBeans.putIfAbsent(id, bean)) != null) {
            throw new DuplicateDefinitionException("PassivationCapable bean id is not unique: " + id + " bean:" + bean);
        }
    }

    public BeanManager addContext(Context context) {
        this.addContext(context.getScope(), this.webBeansContext.getContextFactory().getCustomContext(context));
        return this;
    }

    public void addCustomInterceptorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        this.additionalInterceptorClasses.add(clazz);
    }

    public void addCustomDecoratorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        this.additionalDecoratorClasses.add(clazz);
    }

    public boolean containsCustomInterceptorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return this.additionalInterceptorClasses.contains(clazz);
    }

    public boolean containsCustomDecoratorClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return this.additionalDecoratorClasses.contains(clazz);
    }

    public void addInterceptorBindingType(Class<? extends Annotation> bindingType, Annotation ... inheritsArray) {
        Set<Annotation> inherits = this.additionalInterceptorBindingTypes.get(bindingType);
        if (inherits == null) {
            inherits = new HashSet<Annotation>();
            this.additionalInterceptorBindingTypes.put(bindingType, inherits);
        }
        for (Annotation ann : inheritsArray) {
            inherits.add(ann);
        }
    }

    public boolean hasInterceptorBindingType(Class<? extends Annotation> bindingType) {
        return this.additionalInterceptorBindingTypes.keySet().contains(bindingType);
    }

    public Set<Annotation> getInterceptorBindingTypeMetaAnnotations(Class<? extends Annotation> interceptorBindingType) {
        return Collections.unmodifiableSet(this.additionalInterceptorBindingTypes.get(interceptorBindingType));
    }

    public void fireEvent(Object event, Annotation ... bindings) {
        if (ClassUtil.isDefinitionContainsTypeVariables(event.getClass())) {
            throw new IllegalArgumentException("Event class : " + event.getClass().getName() + " can not be defined as generic type");
        }
        this.notificationManager.fireEvent(event, bindings);
    }

    public Set<Bean<?>> getComponents() {
        return this.deploymentBeans;
    }

    public BeanManager addDecorator(Decorator decorator) {
        OwbBean owbBean;
        this.webBeansDecorators.add(decorator);
        if (decorator instanceof OwbBean && (owbBean = (OwbBean)decorator).isPassivationCapable()) {
            this.addPassivationInfo((OwbBean)decorator);
        }
        return this;
    }

    public BeanManager addInterceptor(Interceptor interceptor) {
        OwbBean owbBean;
        this.webBeansInterceptors.add(interceptor);
        if (interceptor instanceof OwbBean && (owbBean = (OwbBean)interceptor).isPassivationCapable()) {
            this.addPassivationInfo((OwbBean)interceptor);
        }
        return this;
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... bindingTypes) {
        this.webBeansContext.getAnnotationManager().checkDecoratorResolverParams(types, bindingTypes);
        Set<Decorator<?>> intsSet = WebBeansDecoratorConfig.findDeployedWebBeansDecorator(this, types, bindingTypes);
        Iterator<Decorator<?>> itSet = intsSet.iterator();
        ArrayList decoratorList = new ArrayList();
        while (itSet.hasNext()) {
            WebBeansDecorator decorator = (WebBeansDecorator)itSet.next();
            decoratorList.add(decorator);
        }
        Collections.sort(decoratorList, new DecoratorComparator(this.webBeansContext));
        return decoratorList;
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        this.webBeansContext.getAnnotationManager().checkInterceptorResolverParams(interceptorBindings);
        Set<Interceptor<?>> intsSet = this.webBeansContext.getWebBeansInterceptorConfig().findDeployedWebBeansInterceptor(interceptorBindings, this.webBeansContext);
        Iterator<Interceptor<?>> itSet = intsSet.iterator();
        ArrayList interceptorList = new ArrayList();
        while (itSet.hasNext()) {
            WebBeansInterceptor interceptor = (WebBeansInterceptor)itSet.next();
            if (!interceptor.intercepts(type)) continue;
            interceptorList.add(interceptor);
        }
        Collections.sort(interceptorList, new InterceptorComparator(this.webBeansContext));
        return interceptorList;
    }

    public Set<Bean<?>> getBeans() {
        return this.deploymentBeans;
    }

    public List<Interceptor<?>> getInterceptors() {
        return this.webBeansInterceptors;
    }

    public Set<Decorator<?>> getDecorators() {
        return this.webBeansDecorators;
    }

    private void addContext(Class<? extends Annotation> scopeType, Context context) {
        Asserts.assertNotNull(scopeType, "scopeType parameter can not be null");
        Asserts.assertNotNull(context, "context parameter can not be null");
        List<Context> contextList = this.contextMap.get(scopeType);
        if (contextList == null) {
            Context singleContext = this.singleContextMap.get(scopeType);
            if (singleContext == null) {
                this.singleContextMap.put(scopeType, context);
            } else {
                contextList = new ArrayList<Context>();
                contextList.add(singleContext);
                contextList.add(context);
                this.contextMap.put(scopeType, contextList);
                this.singleContextMap.remove(scopeType);
            }
        } else {
            contextList.add(context);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BeanManagerImpl.class.getName(), new StringRefAddr("ManagerImpl", "ManagerImpl"), ManagerObjectFactory.class.getName(), null);
    }

    public BeanManager parse(InputStream xmlStream) {
        this.xmlConfigurator.configure(xmlStream);
        return this;
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        AnnotatedType<T> annotatedType = this.annotatedElementFactory.newAnnotatedType(type);
        return annotatedType;
    }

    public <T> CreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        if (contextual instanceof SerializableBean) {
            contextual = ((SerializableBean)contextual).getBean();
        }
        return this.webBeansContext.getCreationalContextFactory().getCreationalContext(contextual);
    }

    public Set<Bean<?>> getBeans(Type beanType, Annotation ... bindings) {
        if (ClassUtil.isTypeVariable(beanType)) {
            throw new IllegalArgumentException("Exception in getBeans method. Bean type can not be TypeVariable for bean type : " + beanType);
        }
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(bindings);
        if (!this.shouldGetBeansFilter) {
            return this.injectionResolver.implResolveByType(beanType, null, false, bindings);
        }
        return this.injectionResolver.implResolveByType(beanType, bindings);
    }

    public Set<Bean<?>> getBeans(String name) {
        Asserts.assertNotNull(name, "name parameter can not be null");
        if (!this.shouldGetBeansFilter) {
            return this.injectionResolver.implResolveByName(name, false);
        }
        return this.injectionResolver.implResolveByName(name);
    }

    public ELResolver getELResolver() {
        ELAdaptor elAdaptor = this.webBeansContext.getService(ELAdaptor.class);
        return elAdaptor.getOwbELResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> ownerCreationalContext) {
        AbstractOwbBean aob;
        Asserts.assertNotNull(injectionPoint, "injectionPoint parameter can not be null");
        Object instance = null;
        if (injectionPoint == null) {
            return null;
        }
        Bean<?> injectedBean = this.injectionResolver.getInjectionPointBean(injectionPoint);
        boolean isSetIPForProducers = false;
        ScannerService scannerService = this.webBeansContext.getScannerService();
        if (scannerService != null && scannerService.isBDABeansXmlScanningEnabled() && injectedBean instanceof AbstractOwbBean && ((aob = (AbstractOwbBean)injectedBean).getWebBeansType() == WebBeansType.PRODUCERFIELD || aob.getWebBeansType() == WebBeansType.PRODUCERMETHOD)) {
            isSetIPForProducers = true;
        }
        if (isSetIPForProducers) {
            InjectionResolver.injectionPoints.set(injectionPoint);
        }
        boolean ijbSet = false;
        if (InjectionPointBean.isStackEmpty()) {
            ijbSet = true;
            InjectionPointBean.setThreadLocal(injectionPoint);
        }
        try {
            if (WebBeansUtil.isDependent(injectedBean)) {
                instance = this.getReference(injectedBean, injectionPoint.getType(), ownerCreationalContext);
            } else {
                CreationalContextImpl injectedCreational = (CreationalContextImpl)this.createCreationalContext((Contextual)injectedBean);
                instance = this.getReference(injectedBean, injectionPoint.getType(), injectedCreational);
            }
        }
        finally {
            if (ijbSet) {
                InjectionPointBean.unsetThreadLocal();
            }
        }
        if (isSetIPForProducers) {
            InjectionResolver.injectionPoints.set(null);
            InjectionResolver.injectionPoints.remove();
        }
        return instance;
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> binding) {
        Annotation[] annotations = binding.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (binding.isAnnotationPresent(InterceptorBinding.class)) {
            for (Annotation ann : annotations) {
                set.add(ann);
            }
        }
        return set;
    }

    public Bean<?> getPassivationCapableBean(String id) {
        return this.passivationBeans.get(id);
    }

    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        Context context = null;
        Object instance = null;
        if (bean instanceof SerializableBean) {
            bean = ((SerializableBean)bean).getBean();
        }
        if (beanType != null && !ResolutionUtil.checkBeanTypeAssignableToGivenType(bean.getTypes(), beanType, bean instanceof NewBean)) {
            throw new IllegalArgumentException("Given bean type : " + beanType + " is not applicable for the bean instance : " + bean);
        }
        if (!(creationalContext instanceof CreationalContextImpl)) {
            creationalContext = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(creationalContext, bean);
        }
        if (this.webBeansContext.getWebBeansUtil().isScopeTypeNormal(bean.getScope())) {
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = this.cacheProxies.get(bean);
            if (instance == null) {
                instance = this.webBeansContext.getProxyFactory().createNormalScopedBeanProxy((AbstractOwbBean)bean, creationalContext);
                this.cacheProxies.put((Contextual<?>)bean, instance);
            }
        } else {
            context = this.getContext(bean.getScope());
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = context.get(bean, creationalContext);
        }
        return instance;
    }

    private Object getEjbOrJmsProxyReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        if (bean instanceof EnterpriseBeanMarker) {
            if (this.webBeansContext.getWebBeansUtil().isScopeTypeNormal(bean.getScope()) && this.cacheProxies.containsKey(bean)) {
                return this.cacheProxies.get(bean);
            }
            OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
            if (ejbPlugin == null) {
                throw new IllegalStateException("There is no EJB plugin provider. Injection is failed for bean : " + bean);
            }
            return ejbPlugin.getSessionBeanProxy(bean, ClassUtil.getClazz(beanType), creationalContext);
        }
        if (bean instanceof JmsBeanMarker) {
            OpenWebBeansJmsPlugin jmsPlugin = this.webBeansContext.getPluginLoader().getJmsPlugin();
            if (jmsPlugin == null) {
                throw new IllegalStateException("There is no JMS plugin provider. Injection is failed for bean : " + bean);
            }
            return jmsPlugin.getJmsBeanProxy(bean, ClassUtil.getClass(beanType));
        }
        return null;
    }

    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        Annotation[] annotations = stereotype.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (stereotype.isAnnotationPresent(Stereotype.class)) {
            for (Annotation ann : annotations) {
                set.add(ann);
            }
        }
        return set;
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.webBeansContext.getAnnotationManager().isQualifierAnnotation(annotationType);
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return this.webBeansContext.getAnnotationManager().isInterceptorBindingAnnotation(annotationType);
    }

    public boolean isScope(Class<? extends Annotation> annotationType) {
        if (AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), Scope.class) || AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), NormalScope.class)) {
            return true;
        }
        int size = this.additionalScopes.size();
        for (int i = 0; i < size; ++i) {
            ExternalScope ext = this.additionalScopes.get(i);
            if (!ext.getScope().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        int size = this.additionalScopes.size();
        for (int i = 0; i < size; ++i) {
            ExternalScope extScope = this.additionalScopes.get(i);
            if (!extScope.getScope().equals(annotationType)) continue;
            return extScope.isNormal();
        }
        return annotationType.getAnnotation(NormalScope.class) != null;
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        int size = this.additionalScopes.size();
        for (int i = 0; i < size; ++i) {
            ExternalScope extScope = this.additionalScopes.get(i);
            if (!extScope.getScope().equals(annotationType)) continue;
            return extScope.isPassivating();
        }
        NormalScope scope = annotationType.getAnnotation(NormalScope.class);
        if (scope != null) {
            return scope.passivating();
        }
        return false;
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), Stereotype.class);
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        return this.injectionResolver.resolve(beans);
    }

    public void validate(InjectionPoint injectionPoint) {
        Bean bean = injectionPoint.getBean();
        this.injectionResolver.checkInjectionPointType(injectionPoint);
        Class<?> rawType = ClassUtil.getRawTypeForInjectionPoint(injectionPoint);
        if (rawType.equals(InjectionPoint.class)) {
            if (AnnotationUtil.hasAnnotation(AnnotationUtil.getAnnotationsFromSet(injectionPoint.getQualifiers()), Default.class) && !bean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Bean " + bean.getBeanClass() + " scope can not define other scope except @Dependent to inject InjectionPoint");
            }
        } else {
            this.injectionResolver.checkInjectionPoints(injectionPoint);
        }
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        return this.createInjectionTarget(type, true);
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type, boolean fullProcessing) {
        ManagedBean<T> bean = this.webBeansContext.getWebBeansUtil().defineManagedBean(type, fullProcessing);
        if (bean == null) {
            throw new DefinitionException("Could not create InjectionTargetBean for type " + type.getJavaClass());
        }
        return new InjectionTargetProducer<T>(bean);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        if (ClassUtil.isDefinitionContainsTypeVariables(event.getClass())) {
            throw new IllegalArgumentException("Event type can not contain type variables. Event class is : " + event.getClass());
        }
        return this.notificationManager.resolveObservers(event, qualifiers);
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        ELAdaptor elAdaptor = this.webBeansContext.getService(ELAdaptor.class);
        return elAdaptor.getOwbWrappedExpressionFactory(expressionFactory);
    }

    public void addAdditionalQualifier(Class<? extends Annotation> qualifier) {
        if (!this.additionalQualifiers.contains(qualifier)) {
            this.additionalQualifiers.add(qualifier);
        }
    }

    public void addAdditionalAnnotatedType(AnnotatedType<?> annotatedType) {
        this.webBeansContext.getAnnotatedElementFactory().setAnnotatedType(annotatedType);
        this.additionalAnnotatedTypes.add(annotatedType);
    }

    public List<Class<? extends Annotation>> getAdditionalQualifiers() {
        return this.additionalQualifiers;
    }

    public void addAdditionalScope(ExternalScope additionalScope) {
        if (!this.additionalScopes.contains(additionalScope)) {
            this.additionalScopes.add(additionalScope);
        }
    }

    public List<ExternalScope> getAdditionalScopes() {
        return this.additionalScopes;
    }

    public List<AnnotatedType<?>> getAdditionalAnnotatedTypes() {
        return this.additionalAnnotatedTypes;
    }

    public void clear() {
        this.additionalAnnotatedTypes.clear();
        this.additionalDecoratorClasses.clear();
        this.additionalInterceptorClasses.clear();
        this.additionalInterceptorBindingTypes.clear();
        this.additionalQualifiers.clear();
        this.additionalScopes.clear();
        this.clearCacheProxies();
        this.singleContextMap.clear();
        this.contextMap.clear();
        this.deploymentBeans.clear();
        this.errorStack.clear();
        this.injectionTargetForJavaEeComponents.clear();
        this.injectionTargetWrappers.clear();
        this.passivationBeans.clear();
        this.webBeansDecorators.clear();
        this.webBeansInterceptors.clear();
    }

    public void clearCacheProxies() {
        this.cacheProxies.clear();
    }

    public boolean isInUse() {
        return this.inUse;
    }
}

