/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webbeans.context.ContextsServiceHelperService;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.ServletRequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SessionContextManager;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.FailOverService;

public class LibertyContextsService
extends AbstractContextsService {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(LibertyContextsService.class);
    private static ThreadLocal<RequestContext> requestContexts = null;
    private static ThreadLocal<SessionContext> sessionContexts = null;
    private static ThreadLocal<ApplicationContext> applicationContexts = null;
    private final ApplicationContext sharedApplicationContext;
    private static ThreadLocal<ConversationContext> conversationContexts = null;
    private static ThreadLocal<SingletonContext> singletonContexts = null;
    private static DependentContext dependentContext;
    private static Map<String, ApplicationContext> currentApplicationContexts;
    private static Map<String, SingletonContext> currentSingletonContexts;
    private final SessionContextManager sessionCtxManager = new SessionContextManager();
    private final ConversationManager conversationManager;
    private boolean supportsConversation = false;
    protected FailOverService failoverService = null;
    private static boolean retainApplicationScopeAcrossModuleRestarts;

    public static void removeThreadLocals() {
        requestContexts.remove();
        sessionContexts.remove();
        applicationContexts.remove();
        conversationContexts.remove();
        singletonContexts.remove();
        ContextsServiceHelperService.removeStaticThreadLocals();
    }

    public LibertyContextsService(WebBeansContext webBeansContext) {
        this.supportsConversation = webBeansContext.getOpenWebBeansConfiguration().supportsConversation();
        this.conversationManager = webBeansContext.getConversationManager();
        this.sharedApplicationContext = new ApplicationContext();
        this.sharedApplicationContext.setActive(true);
        retainApplicationScopeAcrossModuleRestarts = Boolean.valueOf(webBeansContext.getSecurityService().doPrivilegedGetSystemProperty("com.ibm.ws.webbeans.retainApplicationScopeAcrossModuleRestarts", "false"));
    }

    public SessionContextManager getSessionContextManager() {
        return this.sessionCtxManager;
    }

    @Override
    public void init(Object initializeObject) {
        String s = null;
        if (initializeObject != null) {
            s = initializeObject instanceof ServletContext ? LibertyContextsService.getApplicationName(initializeObject) : initializeObject.toString();
        }
        this.startContext(ApplicationScoped.class, s);
        this.startContext(Singleton.class, s);
        this.startContext(RequestScoped.class, null);
    }

    @Override
    public void destroy(Object destroyObject) {
        String s = null;
        if (destroyObject != null) {
            s = destroyObject instanceof ServletContext ? LibertyContextsService.getApplicationName(destroyObject) : destroyObject.toString();
        }
        this.destroyApplicationContext(s);
        this.sharedApplicationContext.destroy();
        this.destroySingletonContext(s);
        requestContexts.set(null);
        sessionContexts.set(null);
        conversationContexts.set(null);
        applicationContexts.set(null);
        singletonContexts.set(null);
        requestContexts.remove();
        sessionContexts.remove();
        conversationContexts.remove();
        applicationContexts.remove();
        singletonContexts.remove();
    }

    @Override
    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (scopeType.equals(RequestScoped.class)) {
            SessionContext sc;
            if (requestContexts.get() != null && (sc = requestContexts.get().getParentSession()) != null && !sc.isAnyRequestActive(requestContexts.get())) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Destroying a session context because the dependent requests have ended {0}.", sc);
                }
                sc.destroy();
                if (sc == sessionContexts.get()) {
                    sessionContexts.set(null);
                    sessionContexts.remove();
                }
            }
            this.destroyRequestContext((ServletRequestEvent)endParameters);
        } else if (scopeType.equals(SessionScoped.class)) {
            this.destroySessionContext((HttpSession)endParameters);
        } else if (scopeType.equals(ApplicationScoped.class)) {
            this.destroyApplicationContext((String)endParameters);
        } else if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            this.destroyConversationContext();
        } else if (!scopeType.equals(Dependent.class) && scopeType.equals(Singleton.class)) {
            this.destroySingletonContext((String)endParameters);
        }
    }

    @Override
    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getRequestContext();
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getSessionContext();
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            ApplicationContext c = this.getApplicationContext();
            if (c == null) {
                ComponentMetaDataAccessorImpl mda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
                if (mda == null) {
                    return null;
                }
                ComponentMetaData cmd = mda.getComponentMetaData();
                if (cmd == null) {
                    return null;
                }
                ModuleMetaData mmd = cmd.getModuleMetaData();
                if (mmd == null) {
                    return null;
                }
                ApplicationMetaData amd = mmd.getApplicationMetaData();
                if (amd == null) {
                    return null;
                }
                J2EEName jee = amd.getJ2EEName();
                if (jee == null) {
                    return null;
                }
                String appName = jee.getApplication();
                if (appName == null) {
                    return null;
                }
                if (currentApplicationContexts.containsKey(appName)) {
                    c = currentApplicationContexts.get(appName);
                }
            }
            return c;
        }
        if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            return this.getConversationContext();
        }
        if (scopeType.equals(Dependent.class)) {
            return dependentContext;
        }
        if (scopeType.equals(Singleton.class)) {
            return this.getSingletonContext();
        }
        return null;
    }

    @Override
    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        if (scopeType.equals(RequestScoped.class)) {
            this.initRequestContext((ServletRequestEvent)startParameter);
        } else if (scopeType.equals(SessionScoped.class)) {
            this.initSessionContext((HttpSession)startParameter);
        } else if (scopeType.equals(ApplicationScoped.class)) {
            this.initApplicationContext((String)startParameter);
        } else if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            this.initConversationContext((ConversationContext)startParameter);
        } else if (!scopeType.equals(Dependent.class) && scopeType.equals(Singleton.class)) {
            this.initSingletonContext((String)startParameter);
        }
    }

    @Override
    public boolean supportsContext(Class<? extends Annotation> scopeType) {
        return scopeType.equals(RequestScoped.class) || scopeType.equals(SessionScoped.class) || scopeType.equals(ApplicationScoped.class) || scopeType.equals(Dependent.class) || scopeType.equals(Singleton.class) || scopeType.equals(ConversationScoped.class) && this.supportsConversation;
    }

    public static String getApplicationName(Object startParameter) {
        ServletContext sc = (ServletContext)startParameter;
        String appName = (String)sc.getAttribute("com.ibm.websphere.servlet.enterprise.application.name");
        return appName;
    }

    public static boolean getRetainApplicationScopeAcrossModuleRestarts() {
        return retainApplicationScopeAcrossModuleRestarts;
    }

    private void initRequestContext(ServletRequestEvent event) {
        ServletRequestContext rq = new ServletRequestContext();
        rq.setActive(true);
        requestContexts.set(rq);
        if (event != null) {
            HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
            rq.setServletRequest(request);
            if (request != null) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    this.initSessionContext(session);
                }
                this.initApplicationContext(LibertyContextsService.getApplicationName(event.getServletContext()));
                this.initSingletonContext(LibertyContextsService.getApplicationName(event.getServletContext()));
                SessionContext parent = sessionContexts.get();
                if (parent == null && session != null) {
                    parent = this.sessionCtxManager.getSessionContextWithSessionId(session.getId());
                }
                if (parent != null) {
                    parent.addChildRequest(rq);
                }
            }
        } else {
            this.initApplicationContext(null);
            this.initSingletonContext(null);
        }
    }

    private void destroyRequestContext(ServletRequestEvent request) {
        ELContextStore elStore;
        RequestContext context;
        if (this.supportsConversation) {
            this.cleanupConversations();
        }
        if ((context = this.getRequestContext()) != null) {
            context.destroy();
        }
        if ((elStore = ELContextStore.getInstance(false)) != null) {
            elStore.destroyELContextStore();
        }
        requestContexts.set(null);
        requestContexts.remove();
        ContextsServiceHelperService.removeStaticThreadLocals();
    }

    private void cleanupConversations() {
        ConversationContext conversationContext = this.getConversationContext();
        if (conversationContext == null) {
            return;
        }
        Conversation conversation = this.conversationManager.getConversationBeanReference();
        if (conversation == null) {
            return;
        }
        if (conversation.isTransient()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Destroying the transient conversation context with cid : [{0}]", conversation.getId());
            }
            this.destroyConversationContext();
        } else {
            ConversationImpl owbConversation = (ConversationImpl)conversation;
            owbConversation.updateTimeOut();
            owbConversation.setInUsed(false);
        }
    }

    private void initSessionContext(HttpSession session) {
        SessionContext currentSessionContext;
        if (session == null) {
            currentSessionContext = new SessionContext();
        } else {
            String sessionId = session.getId();
            currentSessionContext = this.sessionCtxManager.getSessionContextWithSessionId(sessionId);
            if (currentSessionContext == null) {
                currentSessionContext = new SessionContext();
                this.sessionCtxManager.addNewSessionContext(sessionId, currentSessionContext);
            }
            if (this.failoverService == null) {
                this.failoverService = WebBeansFinder.getSingletonInstance().getService(FailOverService.class);
            }
            if (this.failoverService != null && this.failoverService.isSupportFailOver()) {
                this.failoverService.sessionIsInUse(session);
            }
            if (currentSessionContext != null && this.getRequestContext() != null) {
                currentSessionContext.addChildRequest(this.getRequestContext());
            }
        }
        currentSessionContext.setActive(true);
        sessionContexts.set(currentSessionContext);
    }

    private void destroySessionContext(HttpSession session) {
        if (session != null) {
            SessionContext context = sessionContexts.get();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Attempting to destroy context {0}.", context);
            }
            boolean childRequestsActive = false;
            if (context != null) {
                childRequestsActive = context.isAnyRequestActive();
            } else {
                SessionContext mgrContext = this.sessionCtxManager.getSessionContextWithSessionId(session.getId());
                if (mgrContext != null) {
                    childRequestsActive = mgrContext.isAnyRequestActive();
                }
            }
            if (childRequestsActive) {
                this.sessionCtxManager.registerHeldSession(context);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Held of destroying session context because a child request was active.");
                }
            } else {
                if (context != null) {
                    sessionContexts.set(context);
                    context.destroy();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Destroyed context {0}.", context);
                    }
                }
                sessionContexts.set(this.sessionCtxManager.getSessionContextWithSessionId(session.getId()));
                this.sessionCtxManager.destroySessionContextWithSessionId(session.getId());
                sessionContexts.set(null);
                sessionContexts.remove();
            }
        }
    }

    private void initApplicationContext(String applicationJ2EEName) {
        if (applicationJ2EEName != null) {
            if (currentApplicationContexts.containsKey(applicationJ2EEName)) {
                ApplicationContext context;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Found existing appContext to set on the thread local.");
                }
                if ((context = currentApplicationContexts.get(applicationJ2EEName)) != null && !context.isActive()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Context was inactive, activate it.");
                    }
                    context.setActive(true);
                }
                applicationContexts.set(context);
            } else {
                ApplicationContext currentApplicationContext = new ApplicationContext();
                currentApplicationContext.setActive(true);
                currentApplicationContexts.put(applicationJ2EEName, currentApplicationContext);
                applicationContexts.set(currentApplicationContext);
            }
        } else {
            applicationContexts.set(this.sharedApplicationContext);
        }
    }

    private void destroyApplicationContext(String applicationJ2EEName) {
        this.sessionCtxManager.destroyAllSessions();
        this.conversationManager.destroyAllConversations();
        if (!retainApplicationScopeAcrossModuleRestarts) {
            ApplicationContext context = null;
            if (applicationJ2EEName != null) {
                context = currentApplicationContexts.get(applicationJ2EEName);
            }
            if (context == null) {
                context = this.getApplicationContext();
            }
            if (context != null) {
                context.destroy();
            }
            if (applicationJ2EEName != null) {
                currentApplicationContexts.remove(applicationJ2EEName);
            }
        }
        applicationContexts.set(null);
        applicationContexts.remove();
        WebBeansFinder.getSingletonInstance().getBeanManagerImpl().clearCacheProxies();
    }

    private void initSingletonContext(String applicationJ2EEName) {
        if (applicationJ2EEName != null && currentSingletonContexts.containsKey(applicationJ2EEName)) {
            singletonContexts.set(currentSingletonContexts.get(applicationJ2EEName));
        } else {
            SingletonContext context = new SingletonContext();
            context.setActive(true);
            if (applicationJ2EEName != null) {
                currentSingletonContexts.put(applicationJ2EEName, context);
            }
            singletonContexts.set(context);
        }
    }

    private void destroySingletonContext(String applicationJ2EEName) {
        SingletonContext context = null;
        if (applicationJ2EEName != null) {
            context = currentSingletonContexts.get(applicationJ2EEName);
        }
        if (context == null) {
            context = this.getSingletonContext();
        }
        if (context != null) {
            context.destroy();
        }
        if (applicationJ2EEName != null) {
            currentSingletonContexts.remove(applicationJ2EEName);
        }
        singletonContexts.set(null);
        singletonContexts.remove();
    }

    private void initConversationContext(ConversationContext context) {
        if (context == null) {
            if (conversationContexts.get() == null) {
                ConversationContext newContext = new ConversationContext();
                newContext.setActive(true);
                conversationContexts.set(newContext);
            } else {
                conversationContexts.get().setActive(true);
            }
        } else {
            context.setActive(true);
            conversationContexts.set(context);
        }
    }

    private void destroyConversationContext() {
        ConversationContext context = this.getConversationContext();
        if (context != null) {
            context.destroy();
        }
        conversationContexts.set(null);
        conversationContexts.remove();
    }

    private RequestContext getRequestContext() {
        return requestContexts.get();
    }

    private SessionContext getSessionContext() {
        SessionContext context = sessionContexts.get();
        if (null == context) {
            this.lazyStartSessionContext();
            context = sessionContexts.get();
        }
        return context;
    }

    private ApplicationContext getApplicationContext() {
        ApplicationContext appContext = applicationContexts.get();
        return appContext;
    }

    private SingletonContext getSingletonContext() {
        return singletonContexts.get();
    }

    private ConversationContext getConversationContext() {
        return conversationContexts.get();
    }

    private Context lazyStartSessionContext() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, ">lazyStartSessionContext");
        }
        Context webContext = null;
        Context context = this.getCurrentContext(RequestScoped.class);
        if (context instanceof ServletRequestContext) {
            ServletRequestContext requestContext = (ServletRequestContext)context;
            HttpServletRequest servletRequest = requestContext.getServletRequest();
            if (null != servletRequest) {
                try {
                    HttpSession currentSession = servletRequest.getSession();
                    this.initSessionContext(currentSession);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Lazy SESSION context initialization SUCCESS");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0013", e));
                }
            } else {
                logger.log(Level.WARNING, "Could NOT lazily initialize session context because NO active request context");
            }
        } else {
            logger.log(Level.WARNING, "Could NOT lazily initialize session context because of " + context + " RequestContext");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "<lazyStartSessionContext " + webContext);
        }
        return webContext;
    }

    @Override
    public void activateContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(ApplicationScoped.class) && applicationContexts.get() == null) {
            applicationContexts.set(this.sharedApplicationContext);
        }
        if (scopeType.equals(SessionScoped.class)) {
            this.getSessionContext().setActive(true);
        } else {
            super.activateContext(scopeType);
        }
    }

    public static void destroyApplicationContextByName(String appName) {
        ApplicationContext c;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, " >destroyApplicationContextByName " + appName);
        }
        if (null != (c = currentApplicationContexts.remove(appName))) {
            c.destroy();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, " removed ApplicationContext " + c);
            logger.log(Level.FINE, " <destroyApplicationContextByName ");
        }
    }

    static {
        currentApplicationContexts = new ConcurrentHashMap<String, ApplicationContext>();
        currentSingletonContexts = new ConcurrentHashMap<String, SingletonContext>();
        retainApplicationScopeAcrossModuleRestarts = false;
        requestContexts = new ThreadLocal();
        sessionContexts = new ThreadLocal();
        applicationContexts = new ThreadLocal();
        conversationContexts = new ThreadLocal();
        singletonContexts = new ThreadLocal();
        dependentContext = new DependentContext();
        dependentContext.setActive(true);
    }
}

