/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.creational.BeanInstanceBag;
import org.apache.webbeans.util.WebBeansUtil;

public class SessionContext
extends AbstractContext
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient Set<WeakReference<RequestContext>> childRequests = Collections.newSetFromMap(new ConcurrentHashMap());

    public SessionContext() {
        super(SessionScoped.class);
    }

    @Override
    public void setComponentInstanceMap() {
        this.componentInstanceMap = new ConcurrentHashMap();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        this.scopeType = (Class)in.readObject();
        Map map = (Map)in.readObject();
        this.setComponentInstanceMap();
        Iterator it = map.entrySet().iterator();
        Bean<?> contextual = null;
        while (it.hasNext()) {
            String id = (String)it.next().getKey();
            if (id != null) {
                contextual = webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id);
            }
            if (contextual == null) continue;
            this.componentInstanceMap.put(contextual, (BeanInstanceBag)map.get(id));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.scopeType);
        Iterator it = this.componentInstanceMap.keySet().iterator();
        HashMap<String, BeanInstanceBag> map = new HashMap<String, BeanInstanceBag>();
        while (it.hasNext()) {
            Contextual contextual = (Contextual)it.next();
            String id = WebBeansUtil.isPassivationCapable(contextual);
            if (id == null) {
                throw new NotSerializableException("cannot serialize " + contextual.toString());
            }
            map.put(id, (BeanInstanceBag)this.componentInstanceMap.get(contextual));
        }
        out.writeObject(map);
    }

    public void addChildRequest(RequestContext requestContext) {
        this.childRequests.add(new WeakReference<RequestContext>(requestContext));
    }

    public boolean isAnyRequestActive() {
        return this.isAnyRequestActive(null);
    }

    public boolean isAnyRequestActive(RequestContext endingRequest) {
        boolean held = false;
        Iterator<WeakReference<RequestContext>> iterator = this.childRequests.iterator();
        while (iterator.hasNext()) {
            WeakReference<RequestContext> wrc = iterator.next();
            RequestContext rc = (RequestContext)wrc.get();
            if (rc != null && rc.isActive() && !rc.equals(endingRequest)) {
                rc.setParentSession(this);
                held = true;
                continue;
            }
            iterator.remove();
        }
        return held;
    }

    @Override
    public void destroy() {
        this.childRequests.clear();
        super.destroy();
    }
}

