/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class SessionContextManager {
    private final Map<String, SessionContext> sessionContexts;
    private final Set<String> heldSessionIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WeakReference<SessionContext>> heldSessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Timer heldSessionsTimer;
    private static final long HALF_HOUR = 1800000L;

    public SessionContextManager() {
        this.sessionContexts = new ConcurrentHashMap<String, SessionContext>();
        CleanUpExpiredSessionsTask cleanUpTask = new CleanUpExpiredSessionsTask();
        ClassLoader originalCL = null;
        try {
            originalCL = WebBeansUtil.getCurrentClassLoader();
            WebBeansUtil.setCurrentClassLoader(null);
            this.heldSessionsTimer = new Timer(true);
        }
        finally {
            if (originalCL != null) {
                WebBeansUtil.setCurrentClassLoader(originalCL);
            }
        }
        this.heldSessionsTimer.scheduleAtFixedRate((TimerTask)cleanUpTask, 0L, 1800000L);
    }

    public void addNewSessionContext(String sessionId, SessionContext context) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        Asserts.assertNotNull(context, "context parameter can not be null");
        this.sessionContexts.put(sessionId, context);
    }

    public SessionContext getSessionContextWithSessionId(String sessionId) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        return this.sessionContexts.get(sessionId);
    }

    public void destroySessionContextWithSessionId(String sessionId) {
        SessionContext sessionContext = this.sessionContexts.remove(sessionId);
        if (sessionContext != null) {
            sessionContext.destroy();
        }
    }

    public void destroyAllSessions() {
        Collection<SessionContext> allSessionContexts = this.sessionContexts.values();
        if (allSessionContexts != null && allSessionContexts.size() > 0) {
            for (SessionContext sessionContext : allSessionContexts) {
                sessionContext.destroy();
            }
            allSessionContexts.clear();
        }
    }

    public void registerHeldSessionById(String Id) {
        this.heldSessionIds.add(Id);
    }

    public void registerHeldSession(SessionContext sContext) {
        this.heldSessions.add(new WeakReference<SessionContext>(sContext));
    }

    private class CleanUpExpiredSessionsTask
    extends TimerTask {
        private CleanUpExpiredSessionsTask() {
        }

        @Override
        public void run() {
            Iterator idIterator = SessionContextManager.this.heldSessionIds.iterator();
            while (idIterator.hasNext()) {
                String id = (String)idIterator.next();
                SessionContext sContext = SessionContextManager.this.getSessionContextWithSessionId(id);
                if (sContext == null || !sContext.isActive()) {
                    idIterator.remove();
                    continue;
                }
                if (sContext.isAnyRequestActive()) continue;
                SessionContextManager.this.destroySessionContextWithSessionId(id);
                idIterator.remove();
            }
            Iterator sessionIterator = SessionContextManager.this.heldSessions.iterator();
            while (sessionIterator.hasNext()) {
                WeakReference wr = (WeakReference)sessionIterator.next();
                if (wr.get() == null || ((SessionContext)wr.get()).isActive()) {
                    sessionIterator.remove();
                    continue;
                }
                if (((SessionContext)wr.get()).isAnyRequestActive()) continue;
                ((SessionContext)wr.get()).destroy();
                sessionIterator.remove();
            }
        }
    }
}

