/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public class BeanInstanceBag<T>
implements Serializable {
    private static final long serialVersionUID = 1656996021599122499L;
    private static final TraceComponent tc = Tr.register(BeanInstanceBag.class);
    private final CreationalContext<T> beanCreationalContext;
    private T beanInstance;
    private final Lock lock = new ReentrantLock();

    public BeanInstanceBag(CreationalContext<T> beanCreationalContext) {
        this.beanCreationalContext = beanCreationalContext;
    }

    public CreationalContext<T> getBeanCreationalContext() {
        return this.beanCreationalContext;
    }

    public void setBeanInstance(T beanInstance) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Bean instance set from {0} to {1}", (Object[])new Object[]{Util.identity(this.beanInstance), Util.identity(beanInstance)});
        }
        this.beanInstance = beanInstance;
    }

    public T getBeanInstance() {
        return this.beanInstance;
    }

    public T create(Contextual<T> contextual) {
        try {
            this.lock.lock();
            if (this.beanInstance == null) {
                this.beanInstance = contextual.create(this.beanCreationalContext);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Created beanInstance: {0}", (Object[])new Object[]{Util.identity(this.beanInstance)});
        }
        return this.beanInstance;
    }
}

