/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.security;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.spi.SecurityService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedSecurityService
implements SecurityService {
    private static final int METHOD_CLASS_GETDECLAREDCONSTRUCTOR = 1;
    private static final int METHOD_CLASS_GETDECLAREDCONSTRUCTORS = 2;
    private static final int METHOD_CLASS_GETDECLAREDMETHOD = 3;
    private static final int METHOD_CLASS_GETDECLAREDMETHODS = 4;
    private static final int METHOD_CLASS_GETDECLAREDFIELD = 5;
    private static final int METHOD_CLASS_GETDECLAREDFIELDS = 6;
    private static final PrivilegedActionGetSystemProperties SYSTEM_PROPERTY_ACTION = new PrivilegedActionGetSystemProperties();

    public ManagedSecurityService() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean isCalledFromWebBeansContext = false;
        for (int i = 3; i < 20; ++i) {
            String declaringClass = stackTrace[i].getClassName();
            String methodName = stackTrace[i].getMethodName();
            if (!declaringClass.equals(WebBeansContext.class.getName()) || !methodName.equals("<init>")) continue;
            isCalledFromWebBeansContext = true;
            break;
        }
        if (!isCalledFromWebBeansContext) {
            throw new SecurityException("ManagedSecurityService must directly get created by WebBeansContext!");
        }
        if (this.getClass() != ManagedSecurityService.class) {
            throw new SecurityException("ManagedSecurityService must not get subclassed!");
        }
    }

    public Principal getCurrentPrincipal() {
        return null;
    }

    public <T> Constructor<T> doPrivilegedGetDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, parameterTypes, 1));
        if (obj instanceof NoSuchMethodException) {
            return null;
        }
        return (Constructor)obj;
    }

    public <T> Constructor<?>[] doPrivilegedGetDeclaredConstructors(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 2));
        return (Constructor[])obj;
    }

    public <T> Method doPrivilegedGetDeclaredMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, new Object[]{name, parameterTypes}, 3));
        if (obj instanceof NoSuchMethodException) {
            return null;
        }
        return (Method)obj;
    }

    public <T> Method[] doPrivilegedGetDeclaredMethods(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 4));
        return (Method[])obj;
    }

    public <T> Field doPrivilegedGetDeclaredField(Class<T> clazz, String name) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, name, 5));
        if (obj instanceof NoSuchFieldException) {
            return null;
        }
        return (Field)obj;
    }

    public <T> Field[] doPrivilegedGetDeclaredFields(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 6));
        return (Field[])obj;
    }

    public void doPrivilegedSetAccessible(AccessibleObject obj, boolean flag) {
        AccessController.doPrivileged(new PrivilegedActionForSetAccessible(obj, flag));
    }

    public boolean doPrivilegedIsAccessible(AccessibleObject obj) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedActionForIsAccessible(obj));
    }

    public <T> T doPrivilegedObjectCreate(Class<T> clazz) throws PrivilegedActionException, IllegalAccessException, InstantiationException {
        return (T)AccessController.doPrivileged(new PrivilegedActionForObjectCreation(clazz));
    }

    public void doPrivilegedSetSystemProperty(String propertyName, String value) {
        AccessController.doPrivileged(new PrivilegedActionForSetProperty(propertyName, value));
    }

    public String doPrivilegedGetSystemProperty(String propertyName, String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedActionForProperty(propertyName, defaultValue));
    }

    public Properties doPrivilegedGetSystemProperties() {
        return AccessController.doPrivileged(SYSTEM_PROPERTY_ACTION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForObjectCreation
    implements PrivilegedExceptionAction<Object> {
        private Class<?> clazz;

        protected PrivilegedActionForObjectCreation(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Object run() throws Exception {
            try {
                return this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionGetSystemProperties
    implements PrivilegedAction<Properties> {
        protected PrivilegedActionGetSystemProperties() {
        }

        @Override
        public Properties run() {
            return System.getProperties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForSetProperty
    implements PrivilegedAction<Object> {
        private final String propertyName;
        private final String value;

        protected PrivilegedActionForSetProperty(String propertyName, String value) {
            this.propertyName = propertyName;
            this.value = value;
        }

        @Override
        public String run() {
            System.setProperty(this.propertyName, this.value);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForProperty
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        protected PrivilegedActionForProperty(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForIsAccessible
    implements PrivilegedAction<Object> {
        private AccessibleObject object;

        protected PrivilegedActionForIsAccessible(AccessibleObject object) {
            this.object = object;
        }

        @Override
        public Object run() {
            return this.object.isAccessible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForSetAccessible
    implements PrivilegedAction<Object> {
        private AccessibleObject object;
        private boolean flag;

        protected PrivilegedActionForSetAccessible(AccessibleObject object, boolean flag) {
            this.object = object;
            this.flag = flag;
        }

        @Override
        public Object run() {
            this.object.setAccessible(this.flag);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForClass
    implements PrivilegedAction<Object> {
        private Class<?> clazz;
        private Object parameters;
        private int method;

        protected PrivilegedActionForClass(Class<?> clazz, Object parameters, int method) {
            this.clazz = clazz;
            this.parameters = parameters;
            this.method = method;
        }

        @Override
        public Object run() {
            try {
                switch (this.method) {
                    case 1: {
                        return this.clazz.getDeclaredConstructor((Class[])this.parameters);
                    }
                    case 2: {
                        return this.clazz.getDeclaredConstructors();
                    }
                    case 3: {
                        String name = (String)((Object[])this.parameters)[0];
                        Class[] realParameters = (Class[])((Object[])this.parameters)[1];
                        return this.clazz.getDeclaredMethod(name, realParameters);
                    }
                    case 4: {
                        return this.clazz.getDeclaredMethods();
                    }
                    case 5: {
                        return this.clazz.getDeclaredField((String)this.parameters);
                    }
                    case 6: {
                        return this.clazz.getDeclaredFields();
                    }
                }
                return new WebBeansException("unknown security method: " + this.method);
            }
            catch (Exception exception) {
                return exception;
            }
        }
    }
}

