/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public final class DecoratorUtil {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(DecoratorUtil.class);

    private DecoratorUtil() {
    }

    public static void checkDecoratorConditions(Class<?> decoratorClazz) {
        Method[] methods;
        Asserts.assertNotNull(decoratorClazz, "Decorator class is null");
        for (Method method : methods = decoratorClazz.getDeclaredMethods()) {
            if (AnnotationUtil.hasMethodAnnotation(method, Produces.class)) {
                throw new WebBeansConfigurationException("Decorator class : " + decoratorClazz + " can not have producer methods but it has one with name : " + method.getName());
            }
            if (!AnnotationUtil.hasMethodParameterAnnotation(method, Observes.class)) continue;
            throw new WebBeansConfigurationException("Decorator class : " + decoratorClazz + " can not have observer methods but it has one with name : " + method.getName());
        }
    }

    public static void checkManagedBeanDecoratorConditions(AbstractInjectionTargetBean<?> bean, List<Decorator<?>> decoratorList) {
        Asserts.assertNotNull("bean", "bean parameter can not be null");
        Set<Annotation> annSet = bean.getQualifiers();
        Annotation[] anns = new Annotation[annSet.size()];
        anns = annSet.toArray(anns);
        if (decoratorList == null) {
            decoratorList = bean.getWebBeansContext().getBeanManagerImpl().resolveDecorators(bean.getTypes(), anns);
        }
        if (!decoratorList.isEmpty()) {
            Method[] methods;
            Class clazz = bean.getReturnType();
            if (ClassUtil.isFinal(clazz.getModifiers())) {
                throw new WebBeansConfigurationException("Bean : " + bean.getReturnType().getName() + " can not be declared final, because it has one or more decorators");
            }
            for (Method method : methods = clazz.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || !ClassUtil.isFinal(modifiers)) continue;
                for (WebBeansDecorator webBeansDecorator : decoratorList) {
                    Class<?> decClazz = webBeansDecorator.getClazz();
                    try {
                        if (decClazz.getMethod(method.getName(), method.getParameterTypes()) == null) continue;
                        throw new WebBeansConfigurationException("Bean : " + bean.getReturnType().getName() + " can not define non-private, non-static, final method : " + method.getName() + ", because one of its decorators implements this method");
                    }
                    catch (SecurityException e) {
                        logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0006", decClazz.getName(), method.getName(), e));
                        throw new WebBeansException(e);
                    }
                    catch (NoSuchMethodException e) {
                    }
                }
            }
        }
    }
}

