/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Decorator;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.proxy.MethodHandler;
import org.apache.webbeans.util.WebBeansUtil;

public class DelegateHandler
implements InvocationHandler,
MethodHandler,
Serializable,
Externalizable {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(DelegateHandler.class);
    private static final long serialVersionUID = -3063755008944970684L;
    private transient List<Object> decorators;
    private final transient ThreadLocal<InvokeFrame> currentInvokeFrame = new ThreadLocal();
    private transient Boolean hasDecoratorClasses = false;
    private transient ArrayList<ArrayList<Class<?>>> decoratorClasses = null;
    private transient OwbBean<?> bean = null;
    private transient InvocationContext ejbContext;
    private static final Method objectFinalizeMethod = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                return Object.class.getDeclaredMethod("finalize", null);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    });

    public DelegateHandler() {
    }

    public DelegateHandler(OwbBean<?> bean) {
        this.bean = bean;
    }

    public DelegateHandler(OwbBean<?> bean, InvocationContext ejbContext) {
        this.bean = bean;
        this.ejbContext = ejbContext;
    }

    private static void traceInvocation(Object nextTarget, Method nextMethod, Object[] arguments) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("DelegateHandler.invoke invoking: target = %s, method = %s, arg = %s", LogUtil.id(nextTarget), nextMethod, LogUtil.printArray(arguments)));
        }
    }

    /*
     * Exception decompiling
     */
    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean nextTargetIsTheDecoratedMethod(Method method, Object nextTarget) {
        Class<?>[] params2;
        if (!(nextTarget instanceof InvocationContext)) {
            return false;
        }
        Method nextMethod = ((InvocationContext)nextTarget).getMethod();
        if (method == null || nextMethod == null) {
            return false;
        }
        if (!method.getDeclaringClass().isAssignableFrom(nextMethod.getDeclaringClass()) && !nextMethod.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) {
            return false;
        }
        if (!method.getName().equals(nextMethod.getName())) {
            return false;
        }
        Class<?>[] params1 = nextMethod.getParameterTypes();
        if (params1.length == (params2 = method.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i].equals(params2[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] arguments) throws Exception {
        return this.invoke(instance, method, method, arguments);
    }

    private boolean hasParameterizedTypes(List<Decorator<?>> decorators) {
        for (Decorator<?> dec : decorators) {
            for (Type t : dec.getDecoratedTypes()) {
                if (!(t instanceof ParameterizedType)) continue;
                return true;
            }
        }
        return false;
    }

    public void setDecorators(List<Object> objects, List<Decorator<?>> decorators) {
        InvokeFrame current = this.currentInvokeFrame.get();
        if (current != null) {
            String msg = String.format("Invoke stack is not empty: decorators = %s, new decorators = %s, state = %s", LogUtil.printArray(decorators.toArray()), LogUtil.printArray(objects.toArray()), current);
            IllegalStateException e = new IllegalStateException(msg);
            logger.severe(String.format("DelegateHandler.setDecorators %s", LogUtil.printThrowable(e)));
        }
        this.decorators = objects;
        if (this.hasParameterizedTypes(decorators)) {
            this.hasDecoratorClasses = true;
            ArrayList lol = new ArrayList();
            for (Decorator<?> dec : decorators) {
                ArrayList<Class> obs = new ArrayList<Class>();
                for (Type type : dec.getDecoratedTypes()) {
                    Class clazz = null;
                    if (type instanceof Class) {
                        clazz = (Class)type;
                    } else {
                        ParameterizedType pt = (ParameterizedType)type;
                        clazz = (Class)pt.getRawType();
                    }
                    obs.add(clazz);
                }
                lol.add(obs);
            }
            this.decoratorClasses = lol;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String id = WebBeansUtil.isPassivationCapable(this.bean);
        if (id != null) {
            out.writeObject(id);
            out.writeObject(this.decorators);
            out.writeBoolean(this.hasDecoratorClasses);
            if (this.hasDecoratorClasses.booleanValue()) {
                out.writeObject(this.decoratorClasses);
            }
        } else {
            out.writeObject("");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String id = (String)in.readObject();
        if (id.equals("")) {
            return;
        }
        this.bean = (OwbBean)WebBeansContext.currentInstance().getBeanManagerImpl().getPassivationCapableBean(id);
        this.decorators = (List)in.readObject();
        this.hasDecoratorClasses = in.readBoolean();
        this.decoratorClasses = this.hasDecoratorClasses != false ? (ArrayList)in.readObject() : null;
    }

    private static abstract class InvokeFrame {
        private final Object finalTarget;
        private final Method finalMethod;
        private final Object realTarget;
        private final Method realMethod;
        private final OwbBean<?> bean;
        final InvokeFrame prev;
        private Object nextTarget = null;
        private Method nextMethod = null;
        private boolean nextTargetFinal = false;

        protected InvokeFrame(Object finalTarget, Method finalMethod, OwbBean<?> bean, Object realTarget, Method realMethod, InvokeFrame prev) {
            this.finalTarget = finalTarget;
            this.finalMethod = finalMethod;
            this.bean = bean;
            this.realTarget = realTarget;
            this.realMethod = realMethod;
            this.prev = prev;
        }

        abstract int getDecoratorPosition();

        void rewindToPosition(int pos) {
            this.nextTarget = null;
            this.nextMethod = null;
            this.nextTargetFinal = false;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("DelegateHandler.InvokeFrame.rewindToPosition pos = %d, %s", pos, this));
            }
        }

        protected final void setNextTarget(Object nextTarget, Method nextMethod, boolean isFinalTarget) {
            this.nextTarget = nextTarget;
            this.nextMethod = nextMethod;
            this.nextTargetFinal = isFinalTarget;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("DelegateHandler.InvokeFrame.setNextTarget nextTarget = %s, nextMethod = %s, isFinalTarget = %b, state = %s", LogUtil.id(nextTarget), nextMethod, isFinalTarget, this));
            }
            if (nextMethod == null) {
                return;
            }
            if (!nextMethod.isAccessible()) {
                this.bean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)nextMethod, true);
            }
        }

        protected final void setNextTargetToFinal() throws WebBeansException {
            if (this.nextTargetFinal) {
                String msg = String.format("Attempt to invoke final target for second time: %s", this);
                IllegalStateException e = new IllegalStateException(msg);
                logger.severe(String.format("DelegateHandler.InvokeFrame.setNextTargetToFinal %s", LogUtil.printThrowable(e)));
                throw new WebBeansException(e);
            }
            this.setNextTarget(this.finalTarget, this.finalMethod, true);
        }

        abstract void findNextTarget() throws WebBeansException;

        final Object getNextTarget() {
            return this.nextTarget;
        }

        final Method getNextMethod() {
            return this.nextMethod;
        }

        final boolean isNextTargetDecorator() {
            return !this.nextTargetFinal;
        }

        public String toString() {
            return String.format("{ finalTarget = %s, finalMethod = %s, realTarget = %s, realMethod = %s, nextTarget = %s, nextMethod = %s, nextTargetFinal = %b, prev = %s }", LogUtil.id(this.finalTarget), this.finalMethod, LogUtil.id(this.realTarget), this.realMethod, LogUtil.id(this.nextTarget), this.nextMethod, this.nextTargetFinal, this.prev);
        }

        private boolean isMatchingMethod(Method m) {
            Class<?>[] mParams;
            if (m.equals(this.realMethod)) {
                return true;
            }
            if (!m.getName().equals(this.realMethod.getName())) {
                return false;
            }
            Class<?> c = this.realMethod.getDeclaringClass();
            Class<?> newC = m.getDeclaringClass();
            if (!newC.isAssignableFrom(c)) {
                return false;
            }
            Class<?>[] newParams = m.getParameterTypes();
            if (newParams.length != (mParams = this.realMethod.getParameterTypes()).length) {
                return false;
            }
            Iterator<Class<?>> mTypes = Arrays.asList(mParams).iterator();
            for (Class<?> newParam : newParams) {
                if (newParam.isAssignableFrom(mTypes.next())) continue;
                return false;
            }
            return true;
        }

        private boolean matches(Object target, Method method) {
            return this.isMatchingMethod(method);
        }

        final boolean differs(Object target, Method method) {
            return !this.matches(target, method);
        }

        private static boolean objectHasMatchingMethod(Object o, Method m) {
            try {
                if (o.getClass().getMethod(m.getName(), m.getParameterTypes()) != null) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return false;
        }

        private static boolean ejbMethodMatches(Method m, Method ejbM) {
            return m.getName().equals(ejbM.getName()) && m.getReturnType().equals(ejbM.getReturnType());
        }

        private static Object selectRealTarget(Object target, InvokeFrame prev) {
            return prev == null ? target : prev.realTarget;
        }

        private static int getInitialPosition(InvokeFrame prev) {
            return prev == null ? 0 : prev.getDecoratorPosition();
        }

        static InvokeFrame create(Object target, Method method, Method proceed, List<Object> decorators, ArrayList<ArrayList<Class<?>>> decoratorClasses, OwbBean<?> bean, InvocationContext ejbContext, InvokeFrame prev) {
            Object realTarget = InvokeFrame.selectRealTarget(target, prev);
            int decPos = InvokeFrame.getInitialPosition(prev);
            Object finalTarget = null;
            Method finalMethod = null;
            if (bean instanceof EnterpriseBeanMarker) {
                if (ejbContext != null) {
                    if (InvokeFrame.ejbMethodMatches(method, ejbContext.getMethod())) {
                        finalTarget = ejbContext;
                    } else {
                        finalTarget = ejbContext.getTarget();
                        finalMethod = method;
                    }
                }
            } else {
                finalTarget = realTarget;
                Method method2 = finalMethod = InvokeFrame.objectHasMatchingMethod(realTarget, proceed) ? proceed : method;
            }
            if (decoratorClasses == null) {
                return new DecoratingInvokeFrame(finalTarget, finalMethod, bean, realTarget, method, prev, decorators.listIterator(decPos));
            }
            return new ParameterizedDecoratingInvokeFrame(finalTarget, finalMethod, bean, realTarget, method, prev, decorators.listIterator(decPos), decoratorClasses.listIterator(decPos));
        }
    }

    private static class DecoratingInvokeFrame
    extends InvokeFrame {
        protected final ListIterator<Object> decorators;
        protected final String methodName;
        protected final Class<?>[] methodParamTypes;

        protected DecoratingInvokeFrame(Object finalTarget, Method finalMethod, OwbBean<?> bean, Object target, Method method, InvokeFrame prev, ListIterator<Object> decorators) {
            super(finalTarget, finalMethod, bean, target, method, prev);
            this.decorators = decorators;
            this.methodName = method.getName();
            this.methodParamTypes = method.getParameterTypes();
        }

        private boolean isMethodInClassInterfaces(Class<?> c) {
            HashSet interfaces = new HashSet(Arrays.asList(c.getInterfaces()));
            for (Class<?> superClass = c.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                interfaces.addAll(Arrays.asList(superClass.getInterfaces()));
            }
            for (Class clazz : interfaces) {
                try {
                    if (clazz.getMethod(this.methodName, this.methodParamTypes) == null) continue;
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            return false;
        }

        @Override
        final int getDecoratorPosition() {
            return this.decorators.nextIndex();
        }

        @Override
        void rewindToPosition(int pos) {
            while (this.decorators.nextIndex() > pos) {
                this.decorators.previous();
            }
            super.rewindToPosition(pos);
        }

        @Override
        void findNextTarget() throws WebBeansException {
            while (this.decorators.hasNext()) {
                Object d = this.decorators.next();
                Class<?> dClass = d.getClass();
                try {
                    Method dMethod = dClass.getMethod(this.methodName, this.methodParamTypes);
                    if (dMethod == null || !this.isMethodInClassInterfaces(dClass)) continue;
                    this.setNextTarget(d, dMethod, false);
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            this.setNextTargetToFinal();
        }
    }

    private static final class ParameterizedDecoratingInvokeFrame
    extends DecoratingInvokeFrame {
        private final ListIterator<ArrayList<Class<?>>> decoratorClasses;
        private final List<Class<?>> methodParamList;

        protected ParameterizedDecoratingInvokeFrame(Object finalTarget, Method finalMethod, OwbBean<?> bean, Object target, Method method, InvokeFrame prev, ListIterator<Object> decorators, ListIterator<ArrayList<Class<?>>> decoratorClasses) {
            super(finalTarget, finalMethod, bean, target, method, prev, decorators);
            this.decoratorClasses = decoratorClasses;
            this.methodParamList = Arrays.asList(this.methodParamTypes);
        }

        private boolean isMatchingParamTypes(Class<?>[] paramTypes) {
            if (paramTypes.length != this.methodParamTypes.length) {
                return false;
            }
            Iterator<Class<?>> methodParams = this.methodParamList.iterator();
            for (Class<?> pType : paramTypes) {
                if (pType.isAssignableFrom(methodParams.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        void rewindToPosition(int pos) {
            while (this.decoratorClasses.nextIndex() > pos) {
                this.decoratorClasses.previous();
            }
            super.rewindToPosition(pos);
        }

        @Override
        void findNextTarget() throws WebBeansException {
            while (this.decorators.hasNext()) {
                Object d = this.decorators.next();
                List dTypeClasses = this.decoratorClasses.next();
                for (Class dClass : dTypeClasses) {
                    for (Method dMethod : dClass.getMethods()) {
                        if (!dMethod.getName().equals(this.methodName) || !this.isMatchingParamTypes(dMethod.getParameterTypes())) continue;
                        this.setNextTarget(d, dMethod, false);
                        return;
                    }
                }
            }
            this.setNextTargetToFinal();
        }
    }

    private static final class LogUtil {
        private LogUtil() {
            throw new AssertionError();
        }

        static String id(Object o) {
            if (o == null) {
                return "null";
            }
            return String.format("%s@%08x", o.getClass().getName(), System.identityHashCode(o));
        }

        static String printThrowable(Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print("ERROR ");
            t.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }

        static String printArray(Object[] array) {
            if (array == null) {
                return "null";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print("[");
            String sep = " ";
            for (Object arg : array) {
                pw.print(sep);
                sep = ", ";
                if (arg instanceof String) {
                    pw.print('\"');
                    pw.print(arg);
                    pw.print('\"');
                    continue;
                }
                pw.print(LogUtil.id(arg));
            }
            pw.print(" ]");
            pw.flush();
            return sw.toString();
        }
    }
}

