/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.lifecycle;

import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.webbeans.services.ResourceInjectionServiceImpl;
import com.ibm.wsspi.adaptable.module.Container;
import java.util.logging.Level;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.LibertyContextsService;
import org.apache.webbeans.lifecycle.AbstractLifeCycle;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ResourceInjectionService;

public class EjbLifecycle
extends AbstractLifeCycle {
    private final String CLASS_NAME = EjbLifecycle.class.getName();

    public EjbLifecycle(WebBeansContext context) {
        super(null, context);
        this.logger = WebBeansLoggerFacade.getLogger(EjbLifecycle.class);
    }

    @Override
    protected void beforeStartApplication(Object startupObject) {
        if (startupObject instanceof ModuleInfo) {
            ModuleInfo moduleInfo = (ModuleInfo)startupObject;
            Container moduleContainer = moduleInfo.getContainer();
            this.scannerService.init((Object)moduleContainer);
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, this.CLASS_NAME, "beforeStartApplication", "scanner service init not called since the object is not a ServletContext");
        }
    }

    @Override
    public void stopApplication(Object endObject) {
        super.stopApplication(endObject);
        ResourceInjectionService riService = this.webBeansContext.getService(ResourceInjectionService.class);
        if (riService != null && riService instanceof ResourceInjectionServiceImpl) {
            ResourceInjectionServiceImpl riServiceImpl = (ResourceInjectionServiceImpl)riService;
            riServiceImpl.removeModuleInjectionTargets();
        }
    }

    @Override
    protected void afterStopApplication(Object stopObject) {
        ResourceInjectionService injectionServices = this.getWebBeansContext().getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        this.cleanupShutdownThreadLocals();
    }

    private void cleanupShutdownThreadLocals() {
        InjectionPointBean.removeThreadLocal();
        LibertyContextsService.removeThreadLocals();
    }
}

