/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.el;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.el.ContextStores;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class ELContextStore {
    private static ThreadLocal<ELContextStore> contextStores = new ThreadLocal();
    private static boolean propertySet = false;
    private static boolean elStorePerCL = false;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ELContextStore.class);
    private final Map<Bean<?>, CreationalStore> dependentObjects = new HashMap();
    private final Map<String, Bean<?>> beanNameToDependentBeanMapping = new HashMap();
    private final Map<String, Object> normalScopedObjects = new HashMap<String, Object>();
    private BeanManagerImpl beanManager;

    public static ELContextStore getInstance(boolean createIfNotExist) {
        ELContextStore store = null;
        ELContextStore.oneShotSettings();
        if (!elStorePerCL) {
            store = contextStores.get();
            if (store == null && createIfNotExist) {
                store = new ELContextStore();
                contextStores.set(store);
            }
        } else {
            ContextStores cs = null;
            WebBeansContext wbc = WebBeansContext.currentInstance();
            if (wbc != null) {
                cs = createIfNotExist ? wbc.get(ContextStores.class) : wbc.get(ContextStores.class, false);
            }
            if (null != cs) {
                store = cs.elContextStores.get();
                contextStores.set(store);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "returning store of: " + store);
            }
        }
        return store;
    }

    private static void oneShotSettings() {
        if (!propertySet) {
            propertySet = true;
            elStorePerCL = Boolean.valueOf(WebBeansContext.currentInstance().getSecurityService().doPrivilegedGetSystemProperty("com.ibm.ws.cdi.ELContextStorePerClassLoader", "false"));
            if (elStorePerCL && logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "elStorePerCL set to true");
            }
        }
    }

    public Object findBeanByName(String name) {
        Object cachedBean = this.normalScopedObjects.get(name);
        if (cachedBean != null) {
            return cachedBean;
        }
        Bean<?> dependentBean = this.beanNameToDependentBeanMapping.get(name);
        if (dependentBean == null) {
            return null;
        }
        CreationalStore cs = this.dependentObjects.get(dependentBean);
        if (cs != null) {
            return cs.getObject();
        }
        return null;
    }

    private ELContextStore() {
    }

    public void addDependent(Bean<?> bean, Object dependent, CreationalContext<?> creationalContext) {
        this.dependentObjects.put(bean, new CreationalStore(dependent, creationalContext));
        this.beanNameToDependentBeanMapping.put(bean.getName(), bean);
    }

    public Object getDependent(Bean<?> bean) {
        CreationalStore sc = this.dependentObjects.get(bean);
        return sc != null ? sc.getObject() : null;
    }

    public void addNormalScoped(String beanName, Object contextualInstance) {
        this.normalScopedObjects.put(beanName, contextualInstance);
    }

    public BeanManagerImpl getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = WebBeansContext.getInstance().getBeanManagerImpl();
        }
        return this.beanManager;
    }

    public void destroyDependents() {
        if (this.dependentObjects.size() > 0) {
            Set<Bean<?>> beans = this.dependentObjects.keySet();
            Iterator<Bean<?>> iterator = beans.iterator();
            while (iterator.hasNext()) {
                Bean<?> bean;
                Bean<?> o = bean = iterator.next();
                CreationalStore store = this.dependentObjects.get(bean);
                o.destroy(store.getObject(), store.getCreational());
            }
            this.dependentObjects.clear();
        }
        this.beanNameToDependentBeanMapping.clear();
    }

    public void destroyELContextStore() {
        this.beanManager = null;
        this.normalScopedObjects.clear();
        if (null != contextStores) {
            contextStores.set(null);
            contextStores.remove();
        } else {
            ContextStores cs = null;
            WebBeansContext wbc = WebBeansContext.currentInstance();
            if (wbc != null) {
                cs = wbc.get(ContextStores.class, false);
            }
            if (cs != null) {
                cs.elContextStores.set(null);
                cs.elContextStores.remove();
            }
        }
    }

    static {
        if (elStorePerCL) {
            contextStores = null;
        }
    }

    private static class CreationalStore {
        private final Object object;
        private final CreationalContext<?> creational;

        public CreationalStore(Object object, CreationalContext<?> creational) {
            this.object = object;
            this.creational = creational;
        }

        public Object getObject() {
            return this.object;
        }

        public CreationalContext<?> getCreational() {
            return this.creational;
        }
    }
}

