/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Decorator;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.proxy.MethodHandler;
import org.apache.webbeans.proxy.ProxyFactory;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.MethodMap;

public abstract class InterceptorHandler
implements InvocationHandler,
MethodHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(InterceptorHandler.class);
    protected OwbBean<?> bean = null;
    protected volatile transient MethodMap<List<InterceptorData>> interceptedMethodMap = null;
    protected WebBeansContext webBeansContext;
    private volatile DelegateHandler decoratorDelegateHandler = null;

    protected InterceptorHandler(OwbBean<?> bean) {
        this.bean = bean;
        this.webBeansContext = bean.getWebBeansContext();
    }

    protected boolean isNotInterceptedOrDecoratedMethod(Method method) {
        return false;
    }

    protected void setNotInterceptedOrDecoratedMethod(Method method) {
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments, CreationalContextImpl<?> ownerCreationalContext) throws Exception {
        return this.invoke(instance, method, arguments, ownerCreationalContext);
    }

    public Object invoke(Object instance, Method method, Object[] arguments, CreationalContextImpl<?> ownerCreationalContext) throws Exception {
        if (instance == null) {
            return null;
        }
        Object result = null;
        try {
            boolean isNotInterceptedOrDecoratedMethod = this.isNotInterceptedOrDecoratedMethod(method);
            String methodName = method.getName();
            if (!isNotInterceptedOrDecoratedMethod && !ClassUtil.isObjectMethod(methodName) && this.bean instanceof InjectionTargetBean) {
                InjectionTargetBean injectionTarget = (InjectionTargetBean)this.bean;
                InterceptorDataImpl decoratorInterceptorDataImpl = null;
                if (this.webBeansContext.getInterceptorUtil().isWebBeansBusinessMethod(method)) {
                    List<InterceptorData> interceptorStack;
                    if (!injectionTarget.getDecoratorStack().isEmpty()) {
                        this.resolveDecoratorDelegateHandler(instance, ownerCreationalContext, injectionTarget);
                    }
                    if (!(interceptorStack = injectionTarget.getInterceptorStack()).isEmpty()) {
                        List<InterceptorData> interceptorMethods;
                        if (this.interceptedMethodMap == null) {
                            this.interceptedMethodMap = new MethodMap();
                        }
                        if (this.decoratorDelegateHandler != null) {
                            WebBeansDecoratorInterceptor lastInterceptor = new WebBeansDecoratorInterceptor(this.decoratorDelegateHandler, instance);
                            decoratorInterceptorDataImpl = new InterceptorDataImpl(true, lastInterceptor, this.webBeansContext);
                            decoratorInterceptorDataImpl.setDefinedInInterceptorClass(true);
                            decoratorInterceptorDataImpl.setAroundInvoke(this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(lastInterceptor.getClass(), "invokeDecorators", new Class[]{InvocationContext.class}));
                        }
                        if ((interceptorMethods = this.interceptedMethodMap.get(method)) == null) {
                            ArrayList<InterceptorData> filteredInterceptorStack = new ArrayList<InterceptorData>();
                            for (InterceptorData interceptData : interceptorStack) {
                                if (interceptData.getAroundInvoke() == null || interceptData.getInterceptorBindingMethod() != null && interceptData.getInterceptorBindingMethod().isSynthetic()) continue;
                                filteredInterceptorStack.add(interceptData);
                            }
                            InterceptorUtil interceptorUtil = this.webBeansContext.getInterceptorUtil();
                            interceptorUtil.filterCommonInterceptorStackList(filteredInterceptorStack, method);
                            interceptorUtil.filterOverridenAroundInvokeInterceptor(this.bean.getBeanClass(), filteredInterceptorStack);
                            this.interceptedMethodMap.put(method, filteredInterceptorStack);
                            interceptorMethods = filteredInterceptorStack;
                        }
                        if (decoratorInterceptorDataImpl != null) {
                            interceptorMethods = new ArrayList<InterceptorData>(interceptorMethods);
                            interceptorMethods.add(decoratorInterceptorDataImpl);
                        }
                        if (!interceptorMethods.isEmpty()) {
                            return this.callAroundInvokes(method, arguments, interceptorMethods);
                        }
                    }
                    if (this.decoratorDelegateHandler != null) {
                        return this.decoratorDelegateHandler.invoke(instance, method, arguments);
                    }
                }
                this.setNotInterceptedOrDecoratedMethod(method);
            }
            if (!method.isAccessible()) {
                this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)method, true);
            }
            result = method.invoke(instance, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getCause();
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            throw e;
        }
        return result;
    }

    private synchronized void resolveDecoratorDelegateHandler(Object instance, CreationalContextImpl<?> ownerCreationalContext, InjectionTargetBean<?> injectionTarget) throws Exception {
        if (this.decoratorDelegateHandler == null) {
            DelegateHandler newDelegateHandler = new DelegateHandler(this.bean);
            ProxyFactory proxyFactory = this.webBeansContext.getProxyFactory();
            Object delegate = proxyFactory.createDecoratorDelegate(this.bean, newDelegateHandler);
            ArrayList decoratorbeans = new ArrayList();
            List<AbstractMap.SimpleEntry<Object, Decorator<?>>> decs = WebBeansDecoratorConfig.getDecoratorStack(injectionTarget, instance, delegate, ownerCreationalContext);
            ArrayList<Object> decorators = new ArrayList<Object>();
            for (AbstractMap.SimpleEntry<Object, Decorator<?>> el : decs) {
                decorators.add(el.getKey());
                decoratorbeans.add(el.getValue());
            }
            newDelegateHandler.setDecorators(decorators, decoratorbeans);
            this.decoratorDelegateHandler = newDelegateHandler;
        }
    }

    protected abstract Object callAroundInvokes(Method var1, Object[] var2, List<InterceptorData> var3) throws Exception;

    protected BeanManagerImpl getBeanManager() {
        return this.webBeansContext.getBeanManagerImpl();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeLong(1L);
        String passivationId = this.bean.getId();
        if (passivationId != null) {
            s.writeObject(passivationId);
        } else {
            s.writeObject(null);
            logger.log(Level.WARNING, "WARN_0010", this.bean);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (s.readLong() == 1L) {
            this.webBeansContext = WebBeansContext.currentInstance();
            String passivationId = (String)s.readObject();
            if (passivationId != null) {
                this.bean = (OwbBean)this.webBeansContext.getBeanManagerImpl().getPassivationCapableBean(passivationId);
            }
        } else {
            logger.log(Level.WARNING, "WARN_0011", this.bean);
        }
    }
}

