/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.DependentScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;

public class InvocationContextImpl
implements InvocationContext {
    public static final String INVOCATION_CONTEXT_UNWRAP = "com.ibm.ws.webbeans.invocationContextUnwrap";
    private final Map<String, Object> contextData = new HashMap<String, Object>();
    private final Method method;
    private final Object[] parameters;
    private final List<InterceptorData> interceptorDatas;
    private Object target;
    private final InterceptionType type;
    private int currentMethod = 1;
    private CreationalContext<?> creationalContext;
    private final OwbBean<?> owbBean;
    private InvocationContext ejbInvocationContext;
    private final WebBeansContext webBeansContext;
    private Object ccKey;

    public InvocationContextImpl(WebBeansContext webBeansContext, OwbBean<?> bean, Object instance, Method method, Object[] parameters, List<InterceptorData> datas, InterceptionType type) {
        this.webBeansContext = webBeansContext;
        this.owbBean = bean;
        this.method = method;
        this.parameters = parameters;
        this.interceptorDatas = datas;
        this.type = type;
        if (instance == null) {
            this.configureTarget(bean);
        } else {
            String propValue = webBeansContext.getOpenWebBeansConfiguration().getProperty(INVOCATION_CONTEXT_UNWRAP, "false");
            boolean invocationContextUnwrap = Boolean.parseBoolean(propValue);
            if (invocationContextUnwrap && instance instanceof ProxyObject) {
                ProxyObject proxy = (ProxyObject)instance;
                MethodHandler handler = proxy.getHandler();
                if (handler instanceof DependentScopedBeanInterceptorHandler) {
                    DependentScopedBeanInterceptorHandler interHandler = (DependentScopedBeanInterceptorHandler)handler;
                    this.target = interHandler.getActualInstance();
                } else {
                    this.target = instance;
                }
            } else {
                this.target = instance;
            }
        }
    }

    public void setCreationalContext(CreationalContext<?> ownerCreationalContext) {
        this.creationalContext = ownerCreationalContext;
    }

    public void setEJBInvocationContext(InvocationContext c) {
        this.ejbInvocationContext = c;
    }

    private void configureTarget(OwbBean<?> bean) {
        Context webbeansContext = bean.getWebBeansContext().getBeanManagerImpl().getContext(bean.getScope());
        this.target = webbeansContext.get(bean, this.creationalContext);
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object proceed() throws Exception {
        try {
            if (this.type.equals((Object)InterceptionType.AROUND_INVOKE)) {
                return this.proceedAroundInvokes(this.interceptorDatas);
            }
            if (this.type.equals((Object)InterceptionType.AROUND_TIMEOUT)) {
                return this.proceedAroundTimeouts(this.interceptorDatas);
            }
            return this.proceedCommonAnnots(this.interceptorDatas, this.type);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw ite;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private Object proceedAroundInvokes(List<InterceptorData> datas) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            Object t;
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method tmpMethod = intc.getAroundInvoke();
            Method aroundInvokeMethod = SecurityUtil.doPrivilegedGetNewReferenceToMethod(tmpMethod);
            if (!aroundInvokeMethod.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)aroundInvokeMethod, true);
            }
            if ((t = intc.createNewInstance(this.ccKey != null ? this.ccKey : this.target, (CreationalContextImpl)this.creationalContext)) == null) {
                t = this.target;
            }
            ++this.currentMethod;
            result = aroundInvokeMethod.invoke(t, this);
        } else if (!(this.owbBean instanceof EnterpriseBeanMarker)) {
            if (!this.method.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
            }
            result = this.method.invoke(this.target, this.parameters);
        } else if (this.ejbInvocationContext != null) {
            result = this.ejbInvocationContext.proceed();
        }
        return result;
    }

    private Object proceedAroundTimeouts(List<InterceptorData> datas) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            Object t;
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method tmpMethod = intc.getAroundTimeout();
            Method aroundTimeoutMethod = SecurityUtil.doPrivilegedGetNewReferenceToMethod(tmpMethod);
            if (!aroundTimeoutMethod.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)aroundTimeoutMethod, true);
            }
            if ((t = intc.createNewInstance(this.ccKey != null ? this.ccKey : this.target, (CreationalContextImpl)this.creationalContext)) == null) {
                t = this.target;
            }
            ++this.currentMethod;
            result = aroundTimeoutMethod.invoke(t, this);
        } else if (!(this.owbBean instanceof EnterpriseBeanMarker)) {
            if (!this.method.isAccessible()) {
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
                this.owbBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
            }
            result = this.method.invoke(this.target, this.parameters);
        } else if (this.ejbInvocationContext != null) {
            result = this.ejbInvocationContext.proceed();
        }
        return result;
    }

    private Object proceedCommonAnnots(List<InterceptorData> datas, InterceptionType type) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method tmpMethod = null;
            if (type.equals((Object)InterceptionType.POST_CONSTRUCT)) {
                tmpMethod = intc.getPostConstruct();
            } else if (type.equals((Object)InterceptionType.POST_ACTIVATE)) {
                tmpMethod = intc.getPostActivate();
            } else if (type.equals((Object)InterceptionType.PRE_PASSIVATE)) {
                tmpMethod = intc.getPrePassivate();
            } else if (type.equals((Object)InterceptionType.PRE_DESTROY)) {
                tmpMethod = intc.getPreDestroy();
            } else {
                throw new IllegalArgumentException("Unsupportet InterceptionType: " + type);
            }
            if (tmpMethod == null) {
                throw new IllegalArgumentException("Could not find intercepted Method!");
            }
            Method commonAnnMethod = SecurityUtil.doPrivilegedGetNewReferenceToMethod(tmpMethod);
            if (!commonAnnMethod.isAccessible()) {
                this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)commonAnnMethod, true);
            }
            ++this.currentMethod;
            Object t = intc.createNewInstance(this.ccKey != null ? this.ccKey : this.target, (CreationalContextImpl)this.creationalContext);
            if (t == null) {
                if (!(this.owbBean instanceof EnterpriseBeanMarker)) {
                    t = this.target;
                    result = commonAnnMethod.invoke(t, new Object[0]);
                    this.proceedCommonAnnots(datas, type);
                }
            } else {
                result = commonAnnMethod.invoke(t, this);
            }
        } else if (this.owbBean instanceof EnterpriseBeanMarker && this.ejbInvocationContext != null) {
            result = this.ejbInvocationContext.proceed();
        }
        return result;
    }

    public void setParameters(Object[] params) {
        if (this.getMethod() != null) {
            if (params == null) {
                if (this.parameters.length >= 0) {
                    throw new IllegalArgumentException("Gvien parameters is null but expected not null parameters");
                }
            } else {
                if (params.length != this.parameters.length) {
                    throw new IllegalArgumentException("Expected " + this.parameters.length + " parameters, but only got " + params.length + " parameters");
                }
                Class<?>[] methodParameters = this.method.getParameterTypes();
                int i = 0;
                for (Object obj : params) {
                    Class<?> parameterType = methodParameters[i++];
                    if (obj == null) {
                        if (!parameterType.isPrimitive()) continue;
                        throw new IllegalArgumentException("Expected parameter " + i + " to be primitive type " + parameterType.getName() + ", but got a parameter that is null");
                    }
                    if (parameterType.isPrimitive()) {
                        parameterType = ClassUtil.getPrimitiveWrapper(parameterType);
                    }
                    if (parameterType.isInstance(obj)) continue;
                    throw new IllegalArgumentException("Expected parameter " + i + " to be of type " + parameterType.getName() + ", but got a parameter of type " + obj.getClass().getName());
                }
                System.arraycopy(params, 0, this.parameters, 0, params.length);
            }
        }
    }

    public Object getTimer() {
        return null;
    }

    public void setCcKey(Object ccKey) {
        this.ccKey = ccKey;
    }
}

