/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.lifecycle;

import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.ws.webbeans.impl.scanner.LibertyScannerService;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContextEvent;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.LibertyContextsService;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public abstract class AbstractLifeCycle
implements ContainerLifecycle {
    protected Logger logger;
    protected ScannerService scannerService;
    protected final ContextsService contextsService;
    private final BeansDeployer deployer;
    private final WebBeansXMLConfigurator xmlDeployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl beanManager;
    protected final WebBeansContext webBeansContext;

    protected AbstractLifeCycle() {
        this(null);
    }

    protected AbstractLifeCycle(Properties properties) {
        this(properties, WebBeansContext.getInstance());
    }

    protected AbstractLifeCycle(Properties properties, WebBeansContext webBeansContext) {
        this.beforeInitApplication(properties);
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
        this.xmlDeployer = new WebBeansXMLConfigurator();
        this.deployer = new BeansDeployer(this.xmlDeployer, this.webBeansContext);
        this.jndiService = this.webBeansContext.getService(JNDIService.class);
        this.beanManager.setXMLConfigurator(this.xmlDeployer);
        this.scannerService = this.webBeansContext.getScannerService();
        this.contextsService = this.webBeansContext.getService(ContextsService.class);
        this.initApplication(properties);
    }

    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public void startApplication(Object startupObject) {
        this.logger.info("INFO_0005");
        long begin = System.currentTimeMillis();
        ModuleInfo moduleInfoObject = null;
        boolean hasModuleInfo = false;
        String j2eeApplicationName = null;
        if (startupObject instanceof CDIMetaData && (moduleInfoObject = ((CDIMetaData)startupObject).getModuleInfo()) != null) {
            hasModuleInfo = true;
            j2eeApplicationName = moduleInfoObject.getApplicationInfo().getDeploymentName();
        }
        if (hasModuleInfo) {
            this.beforeStartApplication(moduleInfoObject);
        } else {
            this.beforeStartApplication(startupObject);
        }
        this.webBeansContext.getPluginLoader().startUp(this.webBeansContext);
        if (hasModuleInfo) {
            this.contextsService.init((Object)j2eeApplicationName);
        } else {
            this.contextsService.init(startupObject);
        }
        this.logger.fine("Scanning classpaths for beans artifacts.");
        if (this.scannerService instanceof LibertyScannerService) {
            if (hasModuleInfo) {
                ((LibertyScannerService)this.scannerService).scan((CDIMetaData)startupObject);
            } else {
                ((LibertyScannerService)this.scannerService).scan(null);
            }
        } else {
            this.scannerService.scan();
        }
        this.logger.fine("Deploying scanned beans.");
        this.deployer.deploy(this.scannerService);
        if (hasModuleInfo) {
            this.contextsService.init((Object)j2eeApplicationName);
        } else {
            this.contextsService.init(startupObject);
        }
        if (hasModuleInfo) {
            this.afterStartApplication(j2eeApplicationName);
        } else {
            this.afterStartApplication(startupObject);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "INFO_0001", Long.toString(System.currentTimeMillis() - begin));
        }
    }

    public void stopApplication(Object endObject) {
        block7: {
            this.logger.fine("OpenWebBeans Container is stopping.");
            try {
                ModuleInfo moduleInfoObject = null;
                boolean hasModuleInfo = false;
                String j2eeApplicationName = null;
                if (endObject instanceof ModuleInfo) {
                    hasModuleInfo = true;
                    moduleInfoObject = (ModuleInfo)endObject;
                    j2eeApplicationName = moduleInfoObject.getApplicationInfo().getDeploymentName();
                } else if (endObject instanceof ServletContextEvent) {
                    j2eeApplicationName = LibertyContextsService.getApplicationName(((ServletContextEvent)endObject).getServletContext());
                }
                if (hasModuleInfo) {
                    this.beforeStopApplication(moduleInfoObject);
                } else {
                    this.beforeStopApplication(endObject);
                }
                this.contextsService.startContext(ApplicationScoped.class, (Object)j2eeApplicationName);
                this.beanManager.fireEvent(new BeforeShutdownImpl(), new Annotation[0]);
                this.contextsService.destroy(endObject);
                this.jndiService.unbind("java:comp/BeanManager");
                this.webBeansContext.getPluginLoader().shutDown();
                this.webBeansContext.getExtensionLoader().clear();
                InjectionResolver injectionResolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
                injectionResolver.clearCaches();
                this.webBeansContext.getProxyFactory().clear();
                this.webBeansContext.getAnnotatedElementFactory().clear();
                this.afterStopApplication(endObject);
                this.beanManager.clear();
                WebBeansFinder.clearInstances(WebBeansUtil.getCurrentClassLoader());
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block7;
                this.logger.log(Level.SEVERE, "ERROR_0021", e);
            }
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public ContextsService getContextService() {
        return this.contextsService;
    }

    public void initApplication(Properties properties) {
        this.afterInitApplication(properties);
    }

    protected void beforeInitApplication(Properties properties) {
    }

    protected void afterInitApplication(Properties properties) {
    }

    protected void afterStartApplication(Object startupObject) {
    }

    protected void afterStopApplication(Object stopObject) {
    }

    protected void beforeStartApplication(Object startupObject) {
    }

    protected void beforeStopApplication(Object stopObject) {
    }
}

