/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.DependentScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorHandler;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.proxy.Factory;
import org.apache.webbeans.proxy.MethodHandler;
import org.apache.webbeans.proxy.javassist.JavassistFactory;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;
import sun.reflect.ReflectionFactory;

public final class ProxyFactory {
    private final ConcurrentMap<OwbBean<?>, Class<?>> buildInBeanProxyClasses = new ConcurrentHashMap();
    private final ConcurrentMap<OwbBean<?>, Class<?>> normalScopedBeanProxyClasses = new ConcurrentHashMap();
    private final ConcurrentMap<OwbBean<?>, Class<?>> dependentScopedBeanProxyClasses = new ConcurrentHashMap();
    private final ConcurrentMap<OwbBean<?>, Class<?>> interceptorProxyClasses = new ConcurrentHashMap();
    private final ConcurrentMap<ResourceBean<?, ?>, Class<?>> resourceBeanProxyClasses = new ConcurrentHashMap();
    private final ConcurrentMap<OwbBean<?>, ConcurrentMap<Class<?>, Class<?>>> ejbProxyClasses = new ConcurrentHashMap();
    private final Factory factory;
    public static final String PROCEED_WHEN_NO_ARG_CONSTRUCTOR_MISSING = "org.apache.webbeans.proxy.ProceedWhenDepNoArgConstructorMissing";
    private static final TraceComponent tc = Tr.register(ProxyFactory.class);
    private final Map<String, Class<? extends InterceptorHandler>> interceptorHandlerClasses = new ConcurrentHashMap<String, Class<? extends InterceptorHandler>>();

    public ProxyFactory() {
        this(new JavassistFactory());
    }

    public ProxyFactory(Factory factory) {
        this.factory = factory;
    }

    public void setHandler(Object proxy, MethodHandler handler) {
        this.factory.setHandler(proxy, handler);
    }

    public Map<OwbBean<?>, Class<?>> getInterceptorProxyClasses() {
        return this.interceptorProxyClasses;
    }

    public void clear() {
        this.normalScopedBeanProxyClasses.clear();
        this.dependentScopedBeanProxyClasses.clear();
        this.interceptorProxyClasses.clear();
        this.ejbProxyClasses.clear();
    }

    public Class<?> getEjbBeanProxyClass(OwbBean<?> bean, Class<?> iface) {
        ConcurrentMap typeToProxyClassMap = (ConcurrentMap)this.ejbProxyClasses.get(bean);
        if (typeToProxyClassMap != null) {
            return (Class)typeToProxyClassMap.get(iface);
        }
        return null;
    }

    public Object createDecoratorDelegate(OwbBean<?> bean, DelegateHandler newDelegateHandler) throws Exception {
        Class<?> proxyClass = this.getInterceptorProxyClasses().get(bean);
        if (proxyClass == null) {
            proxyClass = this.createProxyClass(bean);
            this.getInterceptorProxyClasses().put(bean, proxyClass);
        }
        Object delegate = this.createProxy(proxyClass);
        this.setHandler(delegate, newDelegateHandler);
        return delegate;
    }

    public Class<?> getResourceBeanProxyClass(ResourceBean<?, ?> resourceBean) {
        try {
            Class<?> oldClazz;
            Class<?> proxyClass = (Class<?>)this.resourceBeanProxyClasses.get(resourceBean);
            if (proxyClass == null && (oldClazz = this.resourceBeanProxyClasses.putIfAbsent(resourceBean, proxyClass = this.createProxyClass(resourceBean))) != null) {
                return oldClazz;
            }
            return proxyClass;
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
            return null;
        }
    }

    public Class<?> defineEjbBeanProxyClass(OwbBean<?> bean, Class<?> iface, Class<?> superClass, Class<?>[] interfaces) {
        Class<?> proxyClass = null;
        ConcurrentHashMap typeToProxyClassMap = (ConcurrentHashMap)this.ejbProxyClasses.get(bean);
        if (typeToProxyClassMap == null) {
            typeToProxyClassMap = new ConcurrentHashMap();
            ConcurrentHashMap existingMap = this.ejbProxyClasses.putIfAbsent(bean, typeToProxyClassMap);
            ConcurrentHashMap concurrentHashMap = typeToProxyClassMap = existingMap != null ? existingMap : typeToProxyClassMap;
        }
        if ((proxyClass = (Class<?>)typeToProxyClassMap.get(iface)) == null) {
            proxyClass = this.factory.getProxyClass(superClass, interfaces);
            typeToProxyClassMap.putIfAbsent(iface, proxyClass);
        }
        return proxyClass;
    }

    public Object createNormalScopedBeanProxy(OwbBean<?> bean, CreationalContext<?> creationalContext) {
        Object result = null;
        try {
            Class<?> proxyClass = (Class<?>)this.normalScopedBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                proxyClass = this.createProxyClass(bean);
                this.normalScopedBeanProxyClasses.putIfAbsent(bean, proxyClass);
            }
            result = this.createProxy(proxyClass);
            if (!(bean instanceof WebBeansDecorator) && !(bean instanceof WebBeansInterceptor)) {
                InterceptorHandler interceptorHandler = this.createInterceptorHandler(bean, creationalContext);
                this.setHandler(result, interceptorHandler);
            }
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    private Object createProxy(Class<?> proxyClass) throws InstantiationException, IllegalAccessException {
        return this.factory.createProxy(proxyClass);
    }

    private InterceptorHandler createInterceptorHandler(OwbBean<?> bean, CreationalContext<?> creationalContext) {
        String scopeClassName = bean.getScope().getName();
        Class<InterceptorHandler> interceptorHandlerClass = null;
        if (!this.interceptorHandlerClasses.containsKey(scopeClassName)) {
            String proxyMappingConfigKey = "org.apache.webbeans.proxy.mapping." + scopeClassName;
            String className = bean.getWebBeansContext().getOpenWebBeansConfiguration().getProperty(proxyMappingConfigKey);
            if (className != null) {
                try {
                    interceptorHandlerClass = Class.forName(className, true, WebBeansUtil.getCurrentClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new WebBeansConfigurationException("Configured InterceptorHandler " + className + " cannot be found", e);
                }
            } else {
                interceptorHandlerClass = NormalScopedBeanInterceptorHandler.class;
            }
            this.interceptorHandlerClasses.put(scopeClassName, interceptorHandlerClass);
        } else {
            interceptorHandlerClass = this.interceptorHandlerClasses.get(scopeClassName);
        }
        if (interceptorHandlerClass.equals(NormalScopedBeanInterceptorHandler.class)) {
            return new NormalScopedBeanInterceptorHandler(bean, creationalContext);
        }
        try {
            Constructor<? extends InterceptorHandler> ct = interceptorHandlerClass.getConstructor(OwbBean.class, CreationalContext.class);
            return ct.newInstance(bean, creationalContext);
        }
        catch (NoSuchMethodException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + interceptorHandlerClass.getName() + " has the wrong contructor", e);
        }
        catch (InvocationTargetException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + interceptorHandlerClass.getName() + " has the wrong contructor", e);
        }
        catch (InstantiationException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + interceptorHandlerClass.getName() + " has the wrong contructor", e);
        }
        catch (IllegalAccessException e) {
            throw new WebBeansConfigurationException("Configured InterceptorHandler " + interceptorHandlerClass.getName() + " has the wrong contructor", e);
        }
    }

    public Object createBuildInBeanProxy(OwbBean<?> bean) {
        Object result = null;
        try {
            Class<?> proxyClass = (Class<?>)this.buildInBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                proxyClass = this.createProxyClass(bean);
                this.buildInBeanProxyClasses.putIfAbsent(bean, proxyClass);
            }
            result = this.createProxy(proxyClass);
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    public Object createDependentScopedBeanProxy(OwbBean<?> bean, Object actualInstance, CreationalContext<?> creastionalContext) {
        List<InterceptorData> interceptors = null;
        List<Decorator<?>> decorators = null;
        InjectionTargetBean injectionTargetBean = null;
        if (bean instanceof InjectionTargetBean) {
            injectionTargetBean = (InjectionTargetBean)bean;
            interceptors = injectionTargetBean.getInterceptorStack();
            decorators = injectionTargetBean.getDecoratorStack();
        }
        if (interceptors == null && decorators == null) {
            return actualInstance;
        }
        boolean notInInterceptorClassAndLifecycle = false;
        if (interceptors != null && interceptors.size() > 0) {
            for (InterceptorData id : interceptors) {
                if (!id.isDefinedInInterceptorClass() && id.isLifecycleInterceptor()) continue;
                notInInterceptorClassAndLifecycle = true;
                break;
            }
        }
        if (!notInInterceptorClassAndLifecycle && decorators.isEmpty()) {
            CreationalContextImpl ccImpl;
            if (creastionalContext instanceof CreationalContextImpl && (ccImpl = (CreationalContextImpl)creastionalContext).getBean() != null && ccImpl.getBean().equals(bean)) {
                ccImpl.addDependent(actualInstance, bean, actualInstance);
            }
            return actualInstance;
        }
        try {
            Object result = null;
            Class<?> proxyClass = (Class<?>)this.dependentScopedBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                proxyClass = this.createProxyClass(bean);
                this.dependentScopedBeanProxyClasses.putIfAbsent(bean, proxyClass);
            }
            try {
                result = this.createProxy(proxyClass);
            }
            catch (Exception e) {
                OpenWebBeansConfiguration wobc;
                String propValue = null;
                boolean proceedWhenNoArgMissing = false;
                WebBeansContext wbc = bean.getWebBeansContext();
                if (wbc != null && (wobc = wbc.getOpenWebBeansConfiguration()) != null) {
                    propValue = wobc.getProperty(PROCEED_WHEN_NO_ARG_CONSTRUCTOR_MISSING, "false");
                    proceedWhenNoArgMissing = Boolean.parseBoolean(propValue);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("proceedWhenNoArgMissing property has a value of: " + proceedWhenNoArgMissing), (Object[])new Object[0]);
                }
                if (wbc == null || !proceedWhenNoArgMissing || this.hasNoArgConstructor(wbc, proxyClass)) {
                    WebBeansUtil.throwRuntimeExceptions(e);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"try to create instance without noArg Constructor", (Object[])new Object[0]);
                }
                result = this.createWithoutNoArg(proxyClass);
            }
            if (!(bean instanceof WebBeansDecorator) && !(bean instanceof WebBeansInterceptor)) {
                this.setHandler(result, new DependentScopedBeanInterceptorHandler(bean, actualInstance, creastionalContext));
            }
            return result;
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
            return null;
        }
    }

    private boolean hasNoArgConstructor(WebBeansContext wbc, Class<?> pc) {
        Constructor[] ctxs;
        for (Constructor ct : ctxs = wbc.getSecurityService().doPrivilegedGetDeclaredConstructors(pc)) {
            Class<?>[] ca = ct.getParameterTypes();
            if (ca.length != 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"proxy class has no-arg constructor", (Object[])new Object[0]);
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"proxy class does NOT have no-arg constructor", (Object[])new Object[0]);
        }
        return false;
    }

    private Object createWithoutNoArg(Class<?> pc) throws Exception {
        class WithParm
        implements PrivilegedExceptionAction {
            Class<?> pxyClass;

            public WithParm(Class<?> c) {
                this.pxyClass = c;
            }

            public Object run() throws Exception {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling to get Reflection Factory", (Object[])new Object[0]);
                }
                ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
                Class<Object> obj = Object.class;
                Constructor declaredConstructor = obj.getDeclaredConstructor(new Class[0]);
                Constructor<?> newConstructor = rf.newConstructorForSerialization(this.pxyClass, declaredConstructor);
                return newConstructor.newInstance(new Object[0]);
            }
        }
        WithParm x = new WithParm(pc);
        return AccessController.doPrivileged(x);
    }

    public Class<?> createProxyClass(OwbBean<?> bean) {
        ProxyInfo info = ProxyFactory.getProxyInfo(bean);
        return this.factory.getProxyClass(info.getSuperClass(), info.getInterfaces());
    }

    public Class<?> createAbstractDecoratorProxyClass(OwbBean<?> bean) {
        return this.createProxyClass(bean);
    }

    public boolean isProxyInstance(Object o) {
        return this.factory.isProxyInstance(o);
    }

    public Object createProxy(MethodHandler handler, Class<?>[] interfaces) throws IllegalAccessException, InstantiationException {
        return this.factory.createProxy(handler, interfaces);
    }

    private static ProxyInfo getProxyInfo(Bean<?> bean) {
        HashSet interfaceList = new HashSet();
        Class<?> superClass = null;
        for (Type generic : bean.getTypes()) {
            Class<?> type = ClassUtil.getClazz(generic);
            if (type.isInterface()) {
                interfaceList.add(type);
                continue;
            }
            if (superClass != null && (!superClass.isAssignableFrom(type) || type == Object.class)) continue;
            superClass = type;
        }
        if (!interfaceList.contains(Serializable.class)) {
            interfaceList.add(Serializable.class);
        }
        Class[] interfaceArray = new Class[interfaceList.size()];
        interfaceArray = interfaceList.toArray(interfaceArray);
        return new ProxyInfo(superClass, interfaceArray);
    }

    private static class ProxyInfo {
        private final Class<?> superClass;
        private final Class<?>[] interfaces;

        private ProxyInfo(Class<?> superClass, Class<?>[] interfaces) {
            this.superClass = superClass;
            this.interfaces = interfaces;
        }

        public Class<?> getSuperClass() {
            return this.superClass;
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces;
        }
    }
}

