/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.proxy.MethodHandler;
import org.apache.webbeans.spi.ResourceInjectionService;

public class ResourceProxyHandler
implements InvocationHandler,
MethodHandler,
Serializable,
Externalizable {
    private static final long serialVersionUID = 2608686651845218158L;
    private transient Object actualResource;
    private transient ResourceBean bean;
    private transient ObjectInput passivationInput = null;

    public ResourceProxyHandler() {
    }

    public ResourceProxyHandler(ResourceBean bean, Object actualResource) {
        this.bean = bean;
        this.actualResource = actualResource;
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Throwable {
        this.delayedReadExternal();
        return this.invoke(instance, method, arguments);
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] arguments) throws Throwable {
        this.delayedReadExternal();
        try {
            return method.invoke(this.actualResource, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.delayedReadExternal();
        out.writeObject(this.bean.getId());
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ResourceInjectionService resourceInjectionService = webBeansContext.getService(ResourceInjectionService.class);
        resourceInjectionService.writeExternal((Bean)this.bean, this.actualResource, out);
    }

    @Override
    public void readExternal(ObjectInput in) {
        this.passivationInput = in;
    }

    private synchronized void delayedReadExternal() {
        if (this.passivationInput == null) {
            return;
        }
        try {
            String id = (String)this.passivationInput.readObject();
            WebBeansContext webBeansContext = WebBeansContext.currentInstance();
            this.bean = (ResourceBean)webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id);
            ResourceInjectionService resourceInjectionService = webBeansContext.getService(ResourceInjectionService.class);
            this.actualResource = resourceInjectionService.readExternal((Bean)this.bean, this.passivationInput);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.passivationInput = null;
        }
    }
}

