/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy.javassist;

import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.util.ThreadContextAccessor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.WeakHashMap;
import javassist.util.proxy.ProxyFactory;

public class OpenWebBeansClassLoaderProvider
implements ProxyFactory.ClassLoaderProvider {
    private static ThreadLocal<Boolean> useCurrentClassLoader = new ThreadLocal();
    private static ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    private final WeakHashMap<ClassLoader, Boolean> proxyCapableClassLoaders = new WeakHashMap();

    public static void initProxyFactoryClassLoaderProvider() {
        ProxyFactory.classLoaderProvider = new OpenWebBeansClassLoaderProvider();
    }

    public void useCurrentClassLoader() {
        useCurrentClassLoader.set(true);
    }

    public void reset() {
        useCurrentClassLoader.set(null);
        useCurrentClassLoader.remove();
    }

    public ClassLoader get(ProxyFactory proxyFactory) {
        ClassLoader loader;
        Class classToProxy = proxyFactory.getSuperclass();
        if (classToProxy != null && !classToProxy.getName().equals(Object.class.getName()) && this.isProxyCapable(loader = this.getClassLoader(classToProxy))) {
            return loader;
        }
        return threadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
    }

    private ClassLoader getClassLoader(final Class<?> klass) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return klass.getClassLoader();
            }
        });
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private synchronized boolean isProxyCapable(ClassLoader loader) {
        Boolean proxyCapable = this.proxyCapableClassLoaders.get(loader);
        if (proxyCapable == null) {
            try {
                Class<?> proxyFactoryClass = Class.forName(ProxyFactory.class.getName(), false, loader);
                proxyCapable = proxyFactoryClass == ProxyFactory.class;
            }
            catch (ClassNotFoundException ex) {
                proxyCapable = false;
            }
            this.proxyCapableClassLoaders.put(loader, proxyCapable);
        }
        return proxyCapable;
    }
}

