/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MethodMap<T> {
    private final ReferenceQueue<Class<?>> q = new ReferenceQueue();
    private final Map<Key, T> map = new ConcurrentHashMap<Key, T>();

    private void processQ() {
        Reference<Class<?>> stale;
        while ((stale = this.q.poll()) != null) {
            this.map.remove(stale);
        }
        return;
    }

    public void clear() {
        this.processQ();
        this.map.clear();
    }

    public void put(Method m, T value) {
        this.processQ();
        this.map.put(Key.create(m, this.q), value);
    }

    public T get(Method m) {
        this.processQ();
        return this.map.get(Key.create(m));
    }

    private static final class Key
    extends WeakReference<Class<?>> {
        private final Class<?> clz;
        private final String desc;
        private final int hash;

        static Key create(Method m, ReferenceQueue<Class<?>> q) {
            Class<?> c = m.getDeclaringClass();
            String desc = m.toString();
            int hash = Arrays.asList(c, desc).hashCode();
            return q == null ? new Key(c, desc, hash) : new Key(c, desc, hash, q);
        }

        static Key create(Method m) {
            return Key.create(m, null);
        }

        private Key(Class<?> c, String desc, int hash, ReferenceQueue<Class<?>> q) {
            super(c, q);
            this.desc = desc;
            this.hash = hash;
            this.clz = null;
        }

        private Key(Class<?> c, String desc, int hash) {
            super(c);
            this.desc = desc;
            this.hash = hash;
            this.clz = c;
            this.clear();
        }

        @Override
        public Class<?> get() {
            return this.clz == null ? (Class)super.get() : this.clz;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.equals0((Key)obj);
        }

        private boolean equals0(Key k) {
            if (!this.desc.equals(k.desc)) {
                return false;
            }
            Object c = this.get();
            if (c == null) {
                return false;
            }
            return c.equals(k.get());
        }

        public String toString() {
            return this.getClass().getName() + " for " + this.desc;
        }
    }
}

